/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.join;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.iterator.LazyMutableClosableIteration;
import org.eclipse.rdf4j.federated.evaluation.join.JoinExecutorBase;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.util.QueryAlgebraUtil;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.repository.sparql.federation.CollectionIteration;

public class HashJoin
extends JoinExecutorBase<BindingSet> {
    public HashJoin(FederationEvalStrategy strategy, CloseableIteration<BindingSet, QueryEvaluationException> leftIter, TupleExpr rightArg, Set<String> joinVars, BindingSet bindings, QueryInfo queryInfo) throws QueryEvaluationException {
        super(strategy, leftIter, rightArg, bindings, queryInfo);
        this.setJoinVars(joinVars);
    }

    @Override
    protected void handleBindings() throws Exception {
        int totalBindingsLeft = 0;
        int totalBindingsRight = 0;
        Collection<String> rightFreeVars = QueryAlgebraUtil.getFreeVars(this.rightArg);
        Set<String> joinVars = this.getJoinVars();
        try (LazyMutableClosableIteration rightArgIter = new LazyMutableClosableIteration(this.strategy.evaluate(this.rightArg, this.bindings));){
            while (!this.isClosed() && this.leftIter.hasNext()) {
                int blockSizeL = 10;
                if (totalBindingsLeft > 20) {
                    blockSizeL = 100;
                }
                ArrayList<BindingSet> leftBlock = new ArrayList<BindingSet>(blockSizeL);
                for (int i = 0; i < blockSizeL && this.leftIter.hasNext(); ++i) {
                    leftBlock.add((BindingSet)this.leftIter.next());
                    ++totalBindingsLeft;
                }
                int blockSizeR = 10;
                while (!this.isClosed() && rightArgIter.hasNext()) {
                    if (totalBindingsRight > 20) {
                        blockSizeR = 100;
                    }
                    ArrayList<BindingSet> rightBlock = new ArrayList<BindingSet>(blockSizeR);
                    for (int i = 0; i < blockSizeR && rightArgIter.hasNext(); ++i) {
                        rightBlock.add(rightArgIter.next());
                        ++totalBindingsRight;
                    }
                    this.performJoin(leftBlock, rightBlock, joinVars, rightFreeVars);
                }
                rightArgIter.resetCursor();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("JoinStats: left iter of " + this.getDisplayId() + " had " + totalBindingsLeft + " results.");
        }
    }

    protected void performJoin(Collection<BindingSet> leftBlock, Collection<BindingSet> rightBlock, Set<String> joinVariables, Collection<String> freeVariablesRight) {
        this.addResult(HashJoin.join(leftBlock, rightBlock, joinVariables, freeVariablesRight));
    }

    static CloseableIteration<BindingSet, QueryEvaluationException> join(Collection<BindingSet> leftBlock, Collection<BindingSet> rightBlock, Set<String> joinVariables, Collection<String> freeVariablesRight) {
        LinkedList<MapBindingSet> res = new LinkedList<MapBindingSet>();
        for (BindingSet left : leftBlock) {
            for (BindingSet right : rightBlock) {
                Value rightValue;
                Value leftValue;
                boolean match = false;
                for (String joinVariable : joinVariables) {
                    leftValue = left.getValue(joinVariable);
                    rightValue = right.getValue(joinVariable);
                    if (leftValue == null || !leftValue.equals(rightValue)) continue;
                    match = true;
                    break;
                }
                for (String freeVariable : freeVariablesRight) {
                    if (joinVariables.contains(freeVariable)) continue;
                    leftValue = left.getValue(freeVariable);
                    rightValue = right.getValue(freeVariable);
                    if (leftValue == null || !leftValue.equals(rightValue)) continue;
                    match = true;
                }
                if (!match) continue;
                MapBindingSet mergedBindings = new MapBindingSet();
                for (Binding b : left) {
                    mergedBindings.addBinding(b);
                }
                for (Binding b : right) {
                    mergedBindings.addBinding(b);
                }
                res.add(mergedBindings);
            }
        }
        return new CollectionIteration<BindingSet, QueryEvaluationException>(res);
    }
}

