/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.binary;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.rdf4j.common.io.ByteSink;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.binary.BinaryRDFConstants;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;

public class BinaryRDFWriter
extends AbstractRDFWriter
implements RDFWriter,
ByteSink {
    private final BlockingQueue<Statement> statementQueue;
    private final Map<Value, AtomicInteger> valueFreq;
    private final Map<Value, Integer> valueIdentifiers;
    private final AtomicInteger maxValueId = new AtomicInteger(-1);
    private final DataOutputStream out;
    private byte[] buf;

    public BinaryRDFWriter(OutputStream out) {
        this(out, 100);
    }

    public BinaryRDFWriter(OutputStream out, int bufferSize) {
        this.out = new DataOutputStream(new BufferedOutputStream(out));
        this.statementQueue = new ArrayBlockingQueue<Statement>(bufferSize);
        this.valueFreq = new HashMap<Value, AtomicInteger>(3 * bufferSize);
        this.valueIdentifiers = new LinkedHashMap<Value, Integer>(bufferSize);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.BINARY;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        super.startRDF();
        try {
            this.out.write(BinaryRDFConstants.MAGIC_NUMBER);
            this.out.writeInt(1);
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            while (!this.statementQueue.isEmpty()) {
                this.writeStatement();
            }
            this.out.writeByte(127);
            this.out.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            this.out.writeByte(0);
            this.writeString(prefix);
            this.writeString(uri);
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            this.out.writeByte(2);
            this.writeString(comment);
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    protected void consumeStatement(Statement st) {
        this.statementQueue.add(st);
        this.incValueFreq(st.getSubject());
        this.incValueFreq(st.getPredicate());
        this.incValueFreq(st.getObject());
        this.incValueFreq(st.getContext());
        if (this.statementQueue.remainingCapacity() > 0) {
            return;
        }
        try {
            this.writeStatement();
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    private void writeStatement() throws RDFHandlerException, IOException {
        Statement st = (Statement)this.statementQueue.remove();
        int subjId = this.getValueId(st.getSubject());
        int predId = this.getValueId(st.getPredicate());
        int objId = this.getValueId(st.getObject());
        int contextId = this.getValueId(st.getContext());
        this.decValueFreq(st.getSubject());
        this.decValueFreq(st.getPredicate());
        this.decValueFreq(st.getObject());
        this.decValueFreq(st.getContext());
        this.out.writeByte(1);
        this.writeValueOrId(st.getSubject(), subjId);
        this.writeValueOrId(st.getPredicate(), predId);
        this.writeValueOrId(st.getObject(), objId);
        this.writeValueOrId(st.getContext(), contextId);
    }

    private void incValueFreq(Value v) {
        if (v != null) {
            AtomicInteger freq = this.valueFreq.get(v);
            if (freq != null) {
                freq.incrementAndGet();
            } else {
                this.valueFreq.put(v, new AtomicInteger(1));
            }
        }
    }

    private void decValueFreq(Value v) {
        int newFreq;
        AtomicInteger freq;
        if (v != null && (freq = this.valueFreq.get(v)) != null && (newFreq = freq.decrementAndGet()) == 0) {
            this.valueFreq.remove(v);
        }
    }

    private int getValueId(Value v) throws IOException, RDFHandlerException {
        AtomicInteger freq;
        if (v == null) {
            return -1;
        }
        Integer id = this.valueIdentifiers.get(v);
        if (id == null && (freq = this.valueFreq.get(v)) != null && freq.get() >= 2) {
            id = this.assignValueId(v);
        }
        if (id != null) {
            return id;
        }
        return -1;
    }

    private Integer assignValueId(Value v) throws IOException, RDFHandlerException {
        Integer id = null;
        if (id == null) {
            id = this.maxValueId.incrementAndGet();
        }
        this.out.writeByte(3);
        this.out.writeInt(id);
        this.writeValue(v);
        this.valueIdentifiers.put(v, id);
        return id;
    }

    private void writeValueOrId(Value value, int id) throws RDFHandlerException, IOException {
        if (value == null) {
            this.out.writeByte(0);
        } else if (id >= 0) {
            this.out.writeByte(6);
            this.out.writeInt(id);
        } else {
            this.writeValue(value);
        }
    }

    private void writeValue(Value value) throws RDFHandlerException, IOException {
        if (value instanceof IRI) {
            this.writeURI((IRI)value);
        } else if (value instanceof BNode) {
            this.writeBNode((BNode)value);
        } else if (value instanceof Literal) {
            this.writeLiteral((Literal)value);
        } else if (value instanceof Triple) {
            this.writeTriple((Triple)value);
        } else {
            throw new RDFHandlerException("Unknown Value object type: " + value.getClass());
        }
    }

    private void writeURI(IRI uri) throws IOException {
        this.out.writeByte(1);
        this.writeString(uri.toString());
    }

    private void writeBNode(BNode bnode) throws IOException {
        this.out.writeByte(2);
        this.writeString(bnode.getID());
    }

    private void writeLiteral(Literal literal) throws IOException {
        String label = literal.getLabel();
        IRI datatype = literal.getDatatype();
        if (Literals.isLanguageLiteral(literal)) {
            this.out.writeByte(4);
            this.writeString(label);
            this.writeString(literal.getLanguage().get());
        } else {
            this.out.writeByte(5);
            this.writeString(label);
            this.writeString(datatype.toString());
        }
    }

    private void writeTriple(Triple triple) throws IOException {
        this.out.writeByte(7);
        this.writeValue(triple.getSubject());
        this.writeValue(triple.getPredicate());
        this.writeValue(triple.getObject());
    }

    private void writeString(String s) throws IOException {
        int strLen = s.length();
        this.out.writeInt(strLen);
        int stringBytes = strLen << 1;
        if (this.buf == null || this.buf.length < stringBytes) {
            this.buf = new byte[stringBytes << 1];
        }
        int pos = 0;
        for (int i = 0; i < strLen; ++i) {
            char v = s.charAt(i);
            this.buf[pos++] = (byte)(v >>> 8 & 0xFF);
            this.buf[pos++] = (byte)(v >>> 0 & 0xFF);
        }
        this.out.write(this.buf, 0, stringBytes);
    }
}

