/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.concurrent.locks.ReadPrefReadWriteLockManager;
import org.eclipse.rdf4j.common.concurrent.locks.StampedLockManager;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.ConcurrentCleaner;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.DASH;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.model.vocabulary.RSX;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ShaclSailBaseConfiguration;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.ContextWithShapes;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.CombinedShapeSource;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ForwardChainingShapeSource;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclSail
extends ShaclSailBaseConfiguration {
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private static final Logger logger = LoggerFactory.getLogger(ShaclSail.class);
    private static final ConcurrentCleaner cleaner = new ConcurrentCleaner();
    private SailRepository shapesRepo;
    final ReadPrefReadWriteLockManager serializableValidationLock = new ReadPrefReadWriteLockManager();
    private StampedLockManager.Cache<List<ContextWithShapes>> cachedShapes;
    private boolean supportsSnapshotIsolation;
    private final transient AtomicLong singleConnectionCounter = new AtomicLong();
    final Object singleConnectionMonitor = new Object();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final RevivableExecutorService executorService = this.getExecutorService();

    @InternalUseOnly
    StampedLockManager.Cache.WritableState getCachedShapesForWriting() throws InterruptedException {
        return this.cachedShapes.getWriteState();
    }

    @InternalUseOnly
    public StampedLockManager.Cache.ReadableState getCachedShapes() throws InterruptedException {
        return this.cachedShapes.getReadState();
    }

    public ShaclSail(NotifyingSail baseSail) {
        super(baseSail);
        cleaner.register(this, new CleanableState(this.initialized, this.executorService));
        this.supportsSnapshotIsolation = baseSail.getSupportedIsolationLevels().contains(IsolationLevels.SNAPSHOT);
    }

    public ShaclSail() {
        cleaner.register(this, new CleanableState(this.initialized, this.executorService));
    }

    @Override
    public void setBaseSail(Sail baseSail) {
        super.setBaseSail(baseSail);
        this.supportsSnapshotIsolation = baseSail.getSupportedIsolationLevels().contains(IsolationLevels.SNAPSHOT);
    }

    @Experimental
    protected RevivableExecutorService getExecutorService() {
        return new RevivableExecutorService(() -> Executors.newFixedThreadPool(AVAILABLE_PROCESSORS, r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            t.setName("ShaclSail validation thread " + t.getId());
            return t;
        }));
    }

    void closeConnection() {
        this.singleConnectionCounter.compareAndSet(1L, 0L);
    }

    boolean usesSingleConnection() {
        assert (this.singleConnectionCounter.get() != 0L);
        return this.singleConnectionCounter.get() == 1L;
    }

    public static List<IRI> getSupportedShaclPredicates() {
        return Arrays.asList(SHACL.TARGET_CLASS, SHACL.PATH, SHACL.PROPERTY, SHACL.OR, SHACL.AND, SHACL.MIN_COUNT, SHACL.MAX_COUNT, SHACL.MIN_LENGTH, SHACL.MAX_LENGTH, SHACL.PATTERN, SHACL.FLAGS, SHACL.NODE_KIND_PROP, SHACL.LANGUAGE_IN, SHACL.DATATYPE, SHACL.MIN_EXCLUSIVE, SHACL.MIN_INCLUSIVE, SHACL.MAX_EXCLUSIVE, SHACL.MAX_INCLUSIVE, SHACL.CLASS, SHACL.TARGET_NODE, SHACL.DEACTIVATED, SHACL.TARGET_SUBJECTS_OF, SHACL.IN, SHACL.UNIQUE_LANG, SHACL.NOT, SHACL.TARGET_OBJECTS_OF, SHACL.HAS_VALUE, SHACL.TARGET_PROP, SHACL.INVERSE_PATH, SHACL.NODE, SHACL.QUALIFIED_MAX_COUNT, SHACL.QUALIFIED_MIN_COUNT, SHACL.QUALIFIED_VALUE_SHAPE, SHACL.SHAPES_GRAPH, SHACL.MESSAGE, DASH.hasValueIn, RSX.targetShape);
    }

    @Override
    public void init() throws SailException {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        super.init();
        this.executorService.init();
        if (this.shapesRepo != null) {
            this.shapesRepo.shutDown();
            this.shapesRepo = null;
        }
        if (super.getBaseSail().getDataDir() != null) {
            Object path = super.getBaseSail().getDataDir().getPath();
            if (((String)path).endsWith("/")) {
                path = ((String)path).substring(0, ((String)path).length() - 1);
            }
            path = (String)path + "/shapes-graph/";
            logger.info("Shapes will be persisted in: " + (String)path);
            this.shapesRepo = new SailRepository(new MemoryStore(new File((String)path)));
        } else {
            this.shapesRepo = new SailRepository(new MemoryStore());
        }
        this.shapesRepo.init();
        try (SailRepositoryConnection shapesRepoConnection = this.shapesRepo.getConnection();){
            shapesRepoConnection.begin(IsolationLevels.NONE);
            shapesRepoConnection.commit();
        }
        this.cachedShapes = new StampedLockManager.Cache<List>(new StampedLockManager(), () -> {
            IRI[] shapesGraphs = (IRI[])this.getShapesGraphs().stream().map(g -> {
                if (g.equals(RDF4J.NIL)) {
                    return null;
                }
                return g;
            }).toArray(IRI[]::new);
            boolean onlyRdf4jShaclShapeGraph = shapesGraphs.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(shapesGraphs[0]);
            return this.getShapes(shapesGraphs, onlyRdf4jShaclShapeGraph);
        });
        try {
            this.cachedShapes.warmUp();
        }
        catch (InterruptedException e) {
            throw ShaclSail.convertToSailException(e);
        }
    }

    @InternalUseOnly
    public List<ContextWithShapes> getShapes(RepositoryConnection shapesRepoConnection, SailConnection sailConnection, IRI[] shapesGraphs) throws SailException {
        try (ShapeSource shapeSource = new CombinedShapeSource(shapesRepoConnection, sailConnection).withContext(shapesGraphs);){
            List<ContextWithShapes> list = Shape.Factory.getShapes(shapeSource, this);
            return list;
        }
    }

    @InternalUseOnly
    public List<ContextWithShapes> getShapes(RepositoryConnection shapesRepoConnection, IRI[] shapesGraphs) throws SailException {
        try (ForwardChainingShapeSource shapeSource = new ForwardChainingShapeSource(shapesRepoConnection).withContext(shapesGraphs);){
            List<ContextWithShapes> list = Shape.Factory.getShapes(shapeSource, this);
            return list;
        }
    }

    @Override
    public synchronized void shutDown() throws SailException {
        if (this.shapesRepo != null) {
            this.shapesRepo.shutDown();
            this.shapesRepo = null;
        }
        this.cachedShapes = null;
        boolean terminated = this.shutdownExecutorService(false);
        this.initialized.set(false);
        super.shutDown();
        if (!terminated) {
            this.shutdownExecutorService(true);
        }
    }

    private boolean shutdownExecutorService(boolean forced) {
        boolean terminated = false;
        this.executorService.shutdown();
        try {
            terminated = this.executorService.awaitTermination(200L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        if (forced && !terminated) {
            this.executorService.shutdownNow();
            logger.error("Shutdown ShaclSail while validation is still running.");
            terminated = true;
        }
        return terminated;
    }

    <T> Future<T> submitToExecutorService(Callable<T> runnable) {
        return this.executorService.submit(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyingSailConnection getConnection() throws SailException {
        this.init();
        Object object = this.singleConnectionMonitor;
        synchronized (object) {
            this.singleConnectionCounter.incrementAndGet();
        }
        try {
            NotifyingSailConnection connection = super.getConnection();
            if (connection instanceof MemoryStoreConnection) {
                if (this.isSerializableValidation()) {
                    return new ShaclSailConnection(this, connection, super.getConnection(), this.shapesRepo.getConnection(), super.getConnection());
                }
                return new ShaclSailConnection(this, connection, super.getConnection(), this.shapesRepo.getConnection());
            }
            if (this.isSerializableValidation()) {
                return new ShaclSailConnection(this, connection, this.shapesRepo.getConnection(), super.getConnection());
            }
            return new ShaclSailConnection(this, connection, this.shapesRepo.getConnection());
        }
        catch (Throwable t) {
            this.singleConnectionCounter.decrementAndGet();
            throw t;
        }
    }

    /*
     * Exception decompiling
     */
    @InternalUseOnly
    public List<ContextWithShapes> getShapes(IRI[] shapesGraphs, boolean onlyRdf4jShaclShapeGraph) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setShapesGraphs(Set<IRI> shapesGraphs) {
        block9: {
            if (this.initialized.get()) {
                try (StampedLockManager.Cache.WritableState writeState = this.cachedShapes.getWriteState();){
                    super.setShapesGraphs(shapesGraphs);
                    writeState.purge();
                    break block9;
                }
                catch (InterruptedException e) {
                    throw ShaclSail.convertToSailException(e);
                }
            }
            super.setShapesGraphs(shapesGraphs);
        }
    }

    @Override
    public boolean isSerializableValidation() {
        if (!this.supportsSnapshotIsolation && super.isSerializableValidation() && logger.isDebugEnabled()) {
            logger.debug("Serializable validation is enabled but can not be used because the base sail does not support IsolationLevels.SNAPSHOT!");
        }
        return this.supportsSnapshotIsolation && super.isSerializableValidation();
    }

    static SailException convertToSailException(InterruptedException e) {
        Thread.currentThread().interrupt();
        return new SailException(e);
    }

    @Experimental
    protected static class RevivableExecutorService
    implements ExecutorService {
        private final Supplier<ExecutorService> supplier;
        ExecutorService delegate;
        boolean initialized = false;

        public RevivableExecutorService(Supplier<ExecutorService> supplier) {
            this.supplier = supplier;
        }

        public void init() {
            assert (this.delegate == null || this.delegate.isTerminated());
            this.delegate = this.supplier.get();
            this.initialized = true;
        }

        @Override
        public void shutdown() {
            if (this.initialized) {
                this.delegate.shutdown();
            }
        }

        @Override
        public List<Runnable> shutdownNow() {
            if (this.initialized) {
                return this.delegate.shutdownNow();
            }
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return !this.initialized || this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return !this.initialized || this.delegate.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return !this.initialized || this.delegate.awaitTermination(timeout, unit);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            assert (this.initialized);
            return this.delegate.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            assert (this.initialized);
            return this.delegate.submit(task, result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            assert (this.initialized);
            return this.delegate.submit(task);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            assert (this.initialized);
            return this.delegate.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            assert (this.initialized);
            return this.delegate.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            assert (this.initialized);
            return this.delegate.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            assert (this.initialized);
            return this.delegate.invokeAny(tasks, timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            assert (this.initialized);
            this.delegate.execute(command);
        }
    }

    public static class TransactionSettings {
        private final String value;

        TransactionSettings(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static final class ValidationApproach
        extends Enum<ValidationApproach>
        implements TransactionSetting {
            public static final /* enum */ ValidationApproach Disabled = new ValidationApproach("Disabled", 0);
            public static final /* enum */ ValidationApproach Bulk = new ValidationApproach("Bulk", 1);
            public static final /* enum */ ValidationApproach Auto = new ValidationApproach("Auto", 2);
            private final String value;
            private final int priority;
            private static final /* synthetic */ ValidationApproach[] $VALUES;

            public static ValidationApproach[] values() {
                return (ValidationApproach[])$VALUES.clone();
            }

            public static ValidationApproach valueOf(String name) {
                return Enum.valueOf(ValidationApproach.class, name);
            }

            private ValidationApproach(String value, int priority) {
                this.value = value;
                this.priority = priority;
            }

            @Override
            public String getName() {
                return ValidationApproach.class.getCanonicalName();
            }

            @Override
            public String getValue() {
                return this.value;
            }

            public static ValidationApproach getHighestPriority(ValidationApproach v1, ValidationApproach v2) {
                assert (v1 != null || v2 != null);
                if (v1 == null) {
                    return v2;
                }
                if (v2 == null) {
                    return v1;
                }
                if (v1.priority < v2.priority) {
                    return v1;
                }
                return v2;
            }

            static {
                $VALUES = new ValidationApproach[]{Disabled, Bulk, Auto};
            }
        }

        @Experimental
        public static enum PerformanceHint implements TransactionSetting
        {
            ParallelValidation("ParallelValidation"),
            SerialValidation("SerialValidation"),
            CacheEnabled("CacheEnabled"),
            CacheDisabled("CacheDisabled");

            private final String value;

            private PerformanceHint(String value) {
                this.value = value;
            }

            @Override
            public String getName() {
                return PerformanceHint.class.getCanonicalName();
            }

            @Override
            public String getValue() {
                return this.value;
            }
        }
    }

    static class CleanableState
    implements Runnable {
        private final AtomicBoolean initialized;
        private final ExecutorService executorService;

        CleanableState(AtomicBoolean initialized, ExecutorService executorService) {
            this.initialized = initialized;
            this.executorService = executorService;
        }

        @Override
        public void run() {
            if (this.initialized.get()) {
                logger.error("ShaclSail was garbage collected without shutdown() having been called first.");
            }
            this.executorService.shutdownNow();
        }
    }
}

