/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import java.math.BigInteger;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.IntegerCastFunction;

public class NonPositiveIntegerCast
extends IntegerCastFunction {
    @Override
    protected IRI getXsdDatatype() {
        return XSD.NON_POSITIVE_INTEGER;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return XMLDatatypeUtil.isValidNonPositiveInteger(lexicalValue);
    }

    @Override
    protected Optional<Literal> createTypedLiteral(ValueFactory vf, BigInteger integerValue) {
        if (integerValue.compareTo(BigInteger.ZERO) <= 0) {
            return Optional.of(vf.createLiteral(integerValue.toString(), this.getXsdDatatype()));
        }
        return Optional.empty();
    }

    @Override
    protected Optional<Literal> createTypedLiteral(ValueFactory vf, boolean booleanValue) {
        Literal result = null;
        if (!booleanValue) {
            result = vf.createLiteral("0", this.getXsdDatatype());
        }
        return Optional.ofNullable(result);
    }
}

