/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.structures;

import java.math.BigInteger;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTask;
import org.eclipse.rdf4j.federated.structures.QueryType;
import org.eclipse.rdf4j.federated.util.QueryStringUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryInfo {
    private static final Logger log = LoggerFactory.getLogger(QueryInfo.class);
    protected static final AtomicInteger NEXT_QUERY_ID = new AtomicInteger(1);
    private final BigInteger queryID;
    private final String query;
    private final String baseURI;
    private final QueryType queryType;
    private final long maxExecutionTimeMs;
    private final long start;
    private final boolean includeInferred;
    private final Dataset dataset;
    private TupleQueryResultHandler resultHandler = null;
    private final FederationContext federationContext;
    private final FederationEvalStrategy strategy;
    protected boolean done = false;
    protected Set<ParallelTask<?>> scheduledSubtasks = ConcurrentHashMap.newKeySet();

    public QueryInfo(String query, String baseURI, QueryType queryType, int maxExecutionTime, boolean includeInferred, FederationContext federationContext, FederationEvalStrategy strategy, Dataset dataset) {
        this.queryID = federationContext.getQueryManager().getNextQueryId();
        this.federationContext = federationContext;
        this.query = query;
        this.baseURI = baseURI;
        this.queryType = queryType;
        this.dataset = dataset;
        int _maxExecutionTime = maxExecutionTime <= 0 ? federationContext.getConfig().getEnforceMaxQueryTime() : maxExecutionTime;
        this.maxExecutionTimeMs = _maxExecutionTime * 1000;
        this.includeInferred = includeInferred;
        this.start = System.currentTimeMillis();
        this.strategy = strategy;
    }

    public QueryInfo(Resource subj, IRI pred, Value obj, int maxExecutionTime, boolean includeInferred, FederationContext federationContext, FederationEvalStrategy strategy, Dataset dataset) {
        this(QueryStringUtil.toString(subj, pred, obj), null, QueryType.GET_STATEMENTS, maxExecutionTime, includeInferred, federationContext, strategy, dataset);
    }

    public BigInteger getQueryID() {
        return this.queryID;
    }

    public String getQuery() {
        return this.query;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public boolean getIncludeInferred() {
        return this.includeInferred;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public FederationEvalStrategy getStrategy() {
        return this.strategy;
    }

    public FederationContext getFederationContext() {
        return this.federationContext;
    }

    public long getMaxRemainingTimeMS() {
        if (this.maxExecutionTimeMs <= 0L) {
            return Long.MAX_VALUE;
        }
        long runningTime = System.currentTimeMillis() - this.start;
        long maxTime = this.maxExecutionTimeMs - runningTime;
        if (log.isTraceEnabled()) {
            log.trace("Applying max remaining time: " + maxTime);
        }
        return maxTime;
    }

    public synchronized void registerScheduledTask(ParallelTask<?> task) throws QueryEvaluationException {
        if (this.done) {
            task.cancel();
            throw new QueryEvaluationException("Query is aborted or closed, cannot accept new tasks");
        }
        this.scheduledSubtasks.add(task);
    }

    public Optional<TupleQueryResultHandler> getResultHandler() {
        return Optional.ofNullable(this.resultHandler);
    }

    public void setResultHandler(TupleQueryResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public synchronized void abort() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.abortScheduledTasks();
    }

    public synchronized void close() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.closeScheduledTasks();
    }

    protected void abortScheduledTasks() {
        Throwable throwable = null;
        for (ParallelTask<?> task : this.scheduledSubtasks) {
            try {
                task.cancel();
            }
            catch (Throwable t) {
                if (throwable != null) {
                    t.addSuppressed(throwable);
                }
                throwable = t;
            }
        }
        this.scheduledSubtasks.clear();
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
    }

    private void closeScheduledTasks() {
        Throwable throwable = null;
        for (ParallelTask<?> task : this.scheduledSubtasks) {
            try {
                task.close();
            }
            catch (Throwable t) {
                if (throwable != null) {
                    t.addSuppressed(throwable);
                }
                throwable = t;
            }
        }
        this.scheduledSubtasks.clear();
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.queryID == null ? 0 : this.queryID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryInfo other = (QueryInfo)obj;
        if (this.queryID == null) {
            return other.queryID == null;
        }
        return this.queryID.equals(other.queryID);
    }
}

