/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.concurrent;

import java.lang.ref.WeakReference;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.impl.QueueCursor;
import org.eclipse.rdf4j.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedXQueueCursor<T>
extends QueueCursor<CloseableIteration<T, QueryEvaluationException>> {
    private static final Logger log = LoggerFactory.getLogger(FedXQueueCursor.class);
    private final BlockingQueue<CloseableIteration<T, QueryEvaluationException>> queueRef;

    public static <T> FedXQueueCursor<T> create(int capacity, WeakReference<?> callerReference) {
        assert (callerReference == null);
        return FedXQueueCursor.create(capacity);
    }

    public static <T> FedXQueueCursor<T> create(int capacity) {
        ArrayBlockingQueue<CloseableIteration<T, QueryEvaluationException>> queue = new ArrayBlockingQueue<CloseableIteration<T, QueryEvaluationException>>(capacity, false);
        return new FedXQueueCursor<T>(queue);
    }

    private FedXQueueCursor(BlockingQueue<CloseableIteration<T, QueryEvaluationException>> queue) {
        super(queue);
        this.queueRef = queue;
    }

    @Override
    protected QueryEvaluationException convert(Exception e) {
        if (e instanceof QueryEvaluationException) {
            return (QueryEvaluationException)e;
        }
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        return super.convert(e);
    }

    @Override
    public void handleClose() throws QueryEvaluationException {
        try {
            Throwable throwable = null;
            while (!this.queueRef.isEmpty()) {
                try {
                    Object take = this.queueRef.poll();
                    if (!(take instanceof CloseableIteration)) continue;
                    ((CloseableIteration)take).close();
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (throwable != null) {
                        t.addSuppressed(throwable);
                    }
                    throwable = t;
                }
            }
            this.done();
            if (throwable != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new SailException(throwable);
            }
        }
        finally {
            super.handleClose();
        }
    }
}

