/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.monitoring;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryLog {
    private static final Logger log = LoggerFactory.getLogger(QueryLog.class);
    private final AtomicBoolean active = new AtomicBoolean(false);
    private Logger queryLog;

    public QueryLog() {
        log.info("Initializing logging of queries");
        this.initQueryLog();
    }

    private void initQueryLog() {
        this.queryLog = LoggerFactory.getLogger((String)"QueryLog");
        this.active.set(true);
    }

    public void logQuery(QueryInfo query) {
        if (this.active.get()) {
            this.queryLog.info(query.getQuery().replace("\r\n", " ").replace("\n", " "));
        }
        if (log.isTraceEnabled()) {
            log.trace("#Query: " + query.getQuery());
        }
    }
}

