/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;

@Experimental
public class PeekMarkIterator<E>
implements CloseableIteration<E> {
    private final CloseableIteration<E> iterator;
    private boolean mark;
    private ArrayList<E> buffer;
    private Iterator<E> bufferIterator = Collections.emptyIterator();
    private E next;
    private int resetPossible;
    private boolean closed;

    PeekMarkIterator(CloseableIteration<E> iterator) {
        this.iterator = iterator;
    }

    private void calculateNext() {
        if (this.next != null) {
            return;
        }
        if (this.bufferIterator.hasNext()) {
            this.next = this.bufferIterator.next();
        } else {
            if (!this.mark && this.resetPossible > -1) {
                --this.resetPossible;
            }
            if (this.iterator.hasNext()) {
                this.next = this.iterator.next();
            }
        }
        if (this.mark && this.next != null) {
            assert (this.resetPossible > 0);
            this.buffer.add(this.next);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        this.calculateNext();
        return this.next != null;
    }

    @Override
    public E next() {
        if (this.closed) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        this.calculateNext();
        E result = this.next;
        this.next = null;
        if (!this.mark && this.resetPossible == 0) {
            --this.resetPossible;
        }
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    public E peek() {
        if (this.closed) {
            return null;
        }
        this.calculateNext();
        return this.next;
    }

    public void mark() {
        if (this.closed) {
            throw new IllegalStateException("The iteration has been closed.");
        }
        this.mark = true;
        this.resetPossible = 1;
        if (this.buffer != null && !this.bufferIterator.hasNext()) {
            this.buffer.clear();
            this.bufferIterator = Collections.emptyIterator();
        } else {
            this.buffer = new ArrayList();
        }
        if (this.next != null) {
            this.buffer.add(this.next);
        }
    }

    public void reset() {
        if (this.closed) {
            throw new IllegalStateException("The iteration has been closed.");
        }
        if (this.buffer == null) {
            throw new IllegalStateException("Mark never set");
        }
        if (this.resetPossible < 0) {
            throw new IllegalStateException("Reset not possible");
        }
        if (this.mark && this.bufferIterator.hasNext()) {
            while (this.bufferIterator.hasNext()) {
                this.buffer.add(this.bufferIterator.next());
            }
        }
        if (this.resetPossible == 0) {
            assert (!this.mark);
            this.buffer.add(this.next);
            this.next = null;
            this.bufferIterator = this.buffer.iterator();
        } else if (this.resetPossible > 0) {
            this.next = null;
            this.bufferIterator = this.buffer.iterator();
        }
        this.mark = false;
        this.resetPossible = 1;
    }

    boolean isMarked() {
        return !this.closed && this.mark;
    }

    boolean isResettable() {
        return !this.closed && (this.mark || this.resetPossible >= 0);
    }

    @Override
    public void close() {
        this.closed = true;
        this.iterator.close();
        this.buffer = null;
    }

    public void unmark() {
        this.mark = false;
        this.resetPossible = -1;
        if (this.bufferIterator.hasNext()) {
            this.buffer = null;
        } else if (this.buffer != null) {
            this.buffer.clear();
            this.bufferIterator = Collections.emptyIterator();
        }
    }
}

