/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;

public class AllTargetsPlanNode
implements PlanNode {
    private final Select select;
    private StackTraceElement[] stackTrace;
    private boolean printed;
    private ValidationExecutionLogger validationExecutionLogger;

    public AllTargetsPlanNode(SailConnection sailConnection, Resource[] dataGraph, ArrayDeque<EffectiveTarget.EffectiveTargetFragment> chain, List<StatementMatcher.Variable<Value>> vars, ConstraintComponent.Scope scope) {
        List<SparqlFragment> sparqlFragments = chain.stream().map(EffectiveTarget.EffectiveTargetFragment::getQueryFragment).collect(Collectors.toList());
        SparqlFragment sparqlFragment = SparqlFragment.join(sparqlFragments);
        List<String> varNames = vars.stream().map(StatementMatcher.Variable::getName).collect(Collectors.toList());
        this.select = new Select(sailConnection, sparqlFragment, null, new AllTargetsBindingSetMapper(varNames, scope, false, dataGraph), dataGraph);
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            private CloseableIteration<? extends ValidationTuple> iterator;

            @Override
            protected void init() {
                this.iterator = AllTargetsPlanNode.this.select.iterator();
            }

            @Override
            public void localClose() {
                if (this.iterator != null) {
                    this.iterator.close();
                }
            }

            @Override
            protected ValidationTuple loggingNext() {
                return (ValidationTuple)this.iterator.next();
            }

            @Override
            protected boolean localHasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public int depth() {
        return this.select.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.select.getId() + " -> " + this.getId()).append("\n");
        this.select.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    public String toString() {
        return "AllTargetsPlanNode";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.select.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return false;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllTargetsPlanNode that = (AllTargetsPlanNode)o;
        return this.select.equals(that.select);
    }

    public int hashCode() {
        return Objects.hash(this.select);
    }

    public static class AllTargetsBindingSetMapper
    implements Function<BindingSet, ValidationTuple> {
        private final List<String> varNames;
        private final ConstraintComponent.Scope scope;
        private final boolean hasValue;
        private final Resource[] contexts;

        public AllTargetsBindingSetMapper(List<String> varNames, ConstraintComponent.Scope scope, boolean hasValue, Resource[] contexts) {
            this.varNames = varNames;
            this.scope = scope;
            this.hasValue = hasValue;
            this.contexts = contexts;
        }

        @Override
        public ValidationTuple apply(BindingSet b) {
            return new ValidationTuple(b, this.varNames, this.scope, false, this.contexts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllTargetsBindingSetMapper that = (AllTargetsBindingSetMapper)o;
            return this.hasValue == that.hasValue && this.varNames.equals(that.varNames) && this.scope == that.scope && Arrays.equals(this.contexts, that.contexts);
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{this.varNames, this.scope, this.hasValue});
            result = 31 * result + Arrays.hashCode(this.contexts);
            return result;
        }
    }
}

