/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.dawg;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.dawg.DAWGTestResultSetSchema;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class DAWGTestResultSetWriter
implements TupleQueryResultHandler {
    private final RDFHandler rdfHandler;
    private final ValueFactory vf;
    private BNode resultSetNode;
    private final Map<BNode, BNode> bnodeMap = new HashMap<BNode, BNode>();

    public DAWGTestResultSetWriter(RDFHandler rdfHandler) {
        this(rdfHandler, SimpleValueFactory.getInstance());
    }

    public DAWGTestResultSetWriter(RDFHandler rdfHandler, ValueFactory vf) {
        this.rdfHandler = rdfHandler;
        this.vf = vf;
    }

    @Override
    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        try {
            this.rdfHandler.startRDF();
            this.resultSetNode = this.vf.createBNode();
            this.bnodeMap.clear();
            this.reportStatement(this.resultSetNode, RDF.TYPE, DAWGTestResultSetSchema.RESULTSET);
            for (String bindingName : bindingNames) {
                Literal bindingNameLit = this.vf.createLiteral(bindingName);
                this.reportStatement(this.resultSetNode, DAWGTestResultSetSchema.RESULTVARIABLE, bindingNameLit);
            }
        }
        catch (RDFHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public void endQueryResult() throws TupleQueryResultHandlerException {
        this.resultSetNode = null;
        try {
            this.rdfHandler.endRDF();
        }
        catch (RDFHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        try {
            BNode solutionNode = this.vf.createBNode();
            this.reportStatement(this.resultSetNode, DAWGTestResultSetSchema.SOLUTION, solutionNode);
            for (Binding binding : bindingSet) {
                BNode bindingNode = this.vf.createBNode();
                this.reportStatement(solutionNode, DAWGTestResultSetSchema.BINDING, bindingNode);
                this.reportStatement(bindingNode, DAWGTestResultSetSchema.VARIABLE, this.vf.createLiteral(binding.getName()));
                Value value = binding.getValue();
                if (value instanceof BNode) {
                    BNode mappedBNode = this.bnodeMap.get(value);
                    if (mappedBNode == null) {
                        mappedBNode = this.vf.createBNode();
                        this.bnodeMap.put((BNode)value, mappedBNode);
                    }
                    value = mappedBNode;
                }
                this.reportStatement(bindingNode, DAWGTestResultSetSchema.VALUE, value);
            }
        }
        catch (RDFHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    private void reportStatement(Resource subject, IRI predicate, Value object) throws RDFHandlerException {
        this.rdfHandler.handleStatement(this.vf.createStatement(subject, predicate, object));
    }

    @Override
    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle boolean results");
    }

    @Override
    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
    }
}

