/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.AbstractBulkJoinPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.GroupByCountFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TrimToTarget;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxCountConstraintComponent
extends AbstractConstraintComponent {
    private static final Logger logger = LoggerFactory.getLogger(MaxCountConstraintComponent.class);
    private static final String SPARQL_VALIDATION_APPROACH_LIMIT_PROPERTY = "org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MaxCountConstraintComponent.sparqlValidationApproachLimit";
    public static long SPARQL_VALIDATION_APPROACH_LIMIT = System.getProperty("org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MaxCountConstraintComponent.sparqlValidationApproachLimit") == null ? 1L : Long.parseLong(System.getProperty("org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MaxCountConstraintComponent.sparqlValidationApproachLimit"));
    private final long maxCount;

    public MaxCountConstraintComponent(long maxCount) {
        this.maxCount = maxCount;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.MAX_COUNT, (Value)Values.literal((BigInteger)BigInteger.valueOf(this.maxCount)), new Resource[0]);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.MaxCountConstraintComponent;
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        Optional<Path> path = this.getTargetChain().getPath();
        PlanNode mergeNode = overrideTargetNode != null ? effectiveTarget.extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null) : MaxCountConstraintComponent.getAllTargetsIncludingThoseAddedByPath(connectionsGroup, validationSettings, scope, effectiveTarget, path.get(), false);
        mergeNode = Unique.getInstance(new TrimToTarget(mergeNode, connectionsGroup), false, connectionsGroup);
        PlanNode relevantTargetsWithPath = this.maxCount >= 0L ? new BulkedExternalInnerJoin(mergeNode, connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), this.getTargetChain().getPath().get().getTargetQueryFragment(new StatementMatcher.Variable<String>("a"), new StatementMatcher.Variable<String>("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()), false, null, BulkedExternalInnerJoin.getMapper("a", "c", scope, validationSettings.getDataGraph()), connectionsGroup, AbstractBulkJoinPlanNode.DEFAULT_VARS) : new BulkedExternalLeftOuterJoin(mergeNode, connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), this.getTargetChain().getPath().get().getTargetQueryFragment(new StatementMatcher.Variable<String>("a"), new StatementMatcher.Variable<String>("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()), b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true, validationSettings.getDataGraph()), connectionsGroup, AbstractBulkJoinPlanNode.DEFAULT_VARS);
        relevantTargetsWithPath = connectionsGroup.getCachedNodeFor(relevantTargetsWithPath);
        GroupByCountFilter groupByCount = new GroupByCountFilter(relevantTargetsWithPath, count -> count > this.maxCount, connectionsGroup);
        return Unique.getInstance(new TrimToTarget(groupByCount, connectionsGroup), false, connectionsGroup);
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, ValidationSettings validationSettings) {
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getPlanNode(connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, true, null);
            return Unique.getInstance(new ShiftToPropertyShape(allTargetsPlan, connectionsGroup), true, connectionsGroup);
        }
        return EmptyNode.getInstance();
    }

    @Override
    public ConstraintComponent deepClone() {
        return new MaxCountConstraintComponent(this.maxCount);
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        Object query = effectiveTarget.getQuery(false);
        if (this.maxCount == 0L) {
            StatementMatcher.Variable<Value> value = StatementMatcher.Variable.VALUE;
            Optional<SparqlFragment> sparqlFragment = this.getTargetChain().getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), value, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()));
            String pathQuery = sparqlFragment.orElseThrow(IllegalStateException::new).getFragment();
            query = (String)query + "\n" + pathQuery;
        } else if (this.maxCount > 0L) {
            StringBuilder paths = new StringBuilder();
            ArrayList<StatementMatcher.Variable<Value>> valueVariables = new ArrayList<StatementMatcher.Variable<Value>>();
            int i = 0;
            while ((long)i < this.maxCount + 1L) {
                StatementMatcher.Variable<Value> value = stableRandomVariableProvider.next();
                valueVariables.add(value);
                String pathQuery = this.getTargetChain().getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), value, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of())).orElseThrow(IllegalStateException::new).getFragment();
                paths.append(pathQuery).append("\n");
                ++i;
            }
            HashSet<CallSite> notEquals = new HashSet<CallSite>();
            for (int i2 = 0; i2 < valueVariables.size(); ++i2) {
                for (int j = 0; j < valueVariables.size(); ++j) {
                    if (i2 == j) continue;
                    if (i2 > j) {
                        notEquals.add((CallSite)((Object)(((StatementMatcher.Variable)valueVariables.get(i2)).asSparqlVariable() + " != " + ((StatementMatcher.Variable)valueVariables.get(j)).asSparqlVariable())));
                        continue;
                    }
                    notEquals.add((CallSite)((Object)(((StatementMatcher.Variable)valueVariables.get(j)).asSparqlVariable() + " != " + ((StatementMatcher.Variable)valueVariables.get(i2)).asSparqlVariable())));
                }
            }
            String innerCondition = String.join((CharSequence)" && ", notEquals);
            query = (String)query + "\n" + paths.toString().trim() + "\nFILTER(" + innerCondition + ")";
        }
        List<StatementMatcher.Variable<Value>> allTargetVariables = effectiveTarget.getAllTargetVariables();
        return new ValidationQuery(this.getTargetChain().getNamespaces(), (String)query, allTargetVariables, null, scope, this, null, null);
    }

    @Override
    public ValidationApproach getOptimalBulkValidationApproach() {
        if (this.maxCount > SPARQL_VALIDATION_APPROACH_LIMIT) {
            if (logger.isDebugEnabled()) {
                logger.debug("maxCount is {}, which is greater than the limit of {}, using ValidationApproach.Transactional instead of ValidationApproach.SPARQL for {}", new Object[]{this.maxCount, SPARQL_VALIDATION_APPROACH_LIMIT, this.stringRepresentationOfValue((Value)this.getId())});
            }
            return ValidationApproach.Transactional;
        }
        return ValidationApproach.SPARQL;
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaxCountConstraintComponent that = (MaxCountConstraintComponent)o;
        return this.maxCount == that.maxCount;
    }

    public int hashCode() {
        return Long.hashCode(this.maxCount) + "MaxCountConstraintComponent".hashCode();
    }
}

