/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import org.mapdb.Serializer;
import org.mapdb.Store;

public final class Atomic {
    private Atomic() {
    }

    public static final class Var<E> {
        protected final Store store;
        protected final long recid;
        protected final Serializer<E> serializer;

        public Var(Store store, long recid2, Serializer<E> serializer) {
            this.store = store;
            this.recid = recid2;
            this.serializer = serializer;
        }

        public long getRecid() {
            return this.recid;
        }

        public java.lang.String toString() {
            E v = this.get();
            return v == null ? null : v.toString();
        }

        public final E get() {
            return this.store.get(this.recid, this.serializer);
        }

        public final boolean compareAndSet(E expect, E update) {
            return this.store.compareAndSwap(this.recid, expect, update, this.serializer);
        }

        public final void set(E newValue) {
            this.store.update(this.recid, newValue, this.serializer);
        }

        public final E getAndSet(E newValue) {
            E current;
            while (!this.compareAndSet(current = this.get(), newValue)) {
            }
            return current;
        }
    }

    public static final class String {
        protected final Store store;
        protected final long recid;

        public String(Store store, long recid2) {
            this.store = store;
            this.recid = recid2;
        }

        public long getRecid() {
            return this.recid;
        }

        public java.lang.String toString() {
            return this.get();
        }

        public final java.lang.String get() {
            return this.store.get(this.recid, Serializer.STRING_NOSIZE);
        }

        public final boolean compareAndSet(java.lang.String expect, java.lang.String update) {
            return this.store.compareAndSwap(this.recid, expect, update, Serializer.STRING_NOSIZE);
        }

        public final void set(java.lang.String newValue) {
            this.store.update(this.recid, newValue, Serializer.STRING_NOSIZE);
        }

        public final java.lang.String getAndSet(java.lang.String newValue) {
            java.lang.String current;
            while (!this.compareAndSet(current = this.get(), newValue)) {
            }
            return current;
        }
    }

    public static final class Boolean {
        protected final Store store;
        protected final long recid;

        public Boolean(Store store, long recid2) {
            this.store = store;
            this.recid = recid2;
        }

        public long getRecid() {
            return this.recid;
        }

        public final boolean get() {
            return this.store.get(this.recid, Serializer.BOOLEAN);
        }

        public final boolean compareAndSet(boolean expect, boolean update) {
            return this.store.compareAndSwap(this.recid, expect, update, Serializer.BOOLEAN);
        }

        public final void set(boolean newValue) {
            this.store.update(this.recid, newValue, Serializer.BOOLEAN);
        }

        public final boolean getAndSet(boolean newValue) {
            boolean current;
            while (!this.compareAndSet(current = this.get(), newValue)) {
            }
            return current;
        }

        public java.lang.String toString() {
            return java.lang.Boolean.toString(this.get());
        }
    }

    public static final class Long
    extends Number {
        private static final long serialVersionUID = 2882620413591274781L;
        protected final Store store;
        protected final long recid;

        public Long(Store store, long recid2) {
            this.store = store;
            this.recid = recid2;
        }

        public long getRecid() {
            return this.recid;
        }

        public final long get() {
            return this.store.get(this.recid, Serializer.LONG);
        }

        public final void set(long newValue) {
            this.store.update(this.recid, newValue, Serializer.LONG);
        }

        public final long getAndSet(long newValue) {
            long current;
            while (!this.compareAndSet(current = this.get(), newValue)) {
            }
            return current;
        }

        public final boolean compareAndSet(long expect, long update) {
            return this.store.compareAndSwap(this.recid, expect, update, Serializer.LONG);
        }

        public final long getAndIncrement() {
            long next;
            long current;
            while (!this.compareAndSet(current = this.get(), next = current + 1L)) {
            }
            return current;
        }

        public final long getAndDecrement() {
            long next;
            long current;
            while (!this.compareAndSet(current = this.get(), next = current - 1L)) {
            }
            return current;
        }

        public final long getAndAdd(long delta) {
            long next;
            long current;
            while (!this.compareAndSet(current = this.get(), next = current + delta)) {
            }
            return current;
        }

        public final long incrementAndGet() {
            long next;
            long current;
            while (!this.compareAndSet(current = this.get(), next = current + 1L)) {
            }
            return next;
        }

        public final long decrementAndGet() {
            long next;
            long current;
            while (!this.compareAndSet(current = this.get(), next = current - 1L)) {
            }
            return next;
        }

        public final long addAndGet(long delta) {
            long next;
            long current;
            while (!this.compareAndSet(current = this.get(), next = current + delta)) {
            }
            return next;
        }

        public java.lang.String toString() {
            return java.lang.Long.toString(this.get());
        }

        @Override
        public int intValue() {
            return (int)this.get();
        }

        @Override
        public long longValue() {
            return this.get();
        }

        @Override
        public float floatValue() {
            return this.get();
        }

        @Override
        public double doubleValue() {
            return this.get();
        }
    }

    public static final class Integer
    extends Number {
        private static final long serialVersionUID = 4615119399830853054L;
        protected final Store store;
        protected final long recid;

        public Integer(Store store, long recid2) {
            this.store = store;
            this.recid = recid2;
        }

        public long getRecid() {
            return this.recid;
        }

        public final int get() {
            return this.store.get(this.recid, Serializer.INTEGER);
        }

        public final void set(int newValue) {
            this.store.update(this.recid, newValue, Serializer.INTEGER);
        }

        public final int getAndSet(int newValue) {
            int current;
            while (!this.compareAndSet(current = this.get(), newValue)) {
            }
            return current;
        }

        public final boolean compareAndSet(int expect, int update) {
            return this.store.compareAndSwap(this.recid, expect, update, Serializer.INTEGER);
        }

        public final int getAndIncrement() {
            int next;
            int current;
            while (!this.compareAndSet(current = this.get(), next = current + 1)) {
            }
            return current;
        }

        public final int getAndDecrement() {
            int next;
            int current;
            while (!this.compareAndSet(current = this.get(), next = current - 1)) {
            }
            return current;
        }

        public final int getAndAdd(int delta) {
            int next;
            int current;
            while (!this.compareAndSet(current = this.get(), next = current + delta)) {
            }
            return current;
        }

        public final int incrementAndGet() {
            int next;
            int current;
            while (!this.compareAndSet(current = this.get(), next = current + 1)) {
            }
            return next;
        }

        public final int decrementAndGet() {
            int next;
            int current;
            while (!this.compareAndSet(current = this.get(), next = current - 1)) {
            }
            return next;
        }

        public final int addAndGet(int delta) {
            int next;
            int current;
            while (!this.compareAndSet(current = this.get(), next = current + delta)) {
            }
            return next;
        }

        public java.lang.String toString() {
            return java.lang.Integer.toString(this.get());
        }

        @Override
        public int intValue() {
            return this.get();
        }

        @Override
        public long longValue() {
            return this.get();
        }

        @Override
        public float floatValue() {
            return this.get();
        }

        @Override
        public double doubleValue() {
            return this.get();
        }
    }
}

