/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.table.FieldDef;

public class ArithUnaryOpIter
extends PlanIter {
    private final FunctionLib.FuncCode theCode;
    private final PlanIter theArg;

    public ArithUnaryOpIter(Expr e, int resultReg, FunctionLib.FuncCode code, PlanIter argIter) {
        super(e, resultReg);
        this.theCode = code;
        assert (this.theCode == FunctionLib.FuncCode.OP_ARITH_UNARY);
        this.theArg = argIter;
    }

    public ArithUnaryOpIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short ordinal = ArithUnaryOpIter.readOrdinal(in, FunctionLib.FuncCode.values().length);
        this.theCode = FunctionLib.FuncCode.values()[ordinal];
        this.theArg = ArithUnaryOpIter.deserializeIter(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.theCode.ordinal());
        ArithUnaryOpIter.serializeIter(this.theArg, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.ARITH_UNARY_OP;
    }

    @Override
    FunctionLib.FuncCode getFuncCode() {
        return this.theCode;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        this.theArg.open(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        PlanIter argIter = this.theArg;
        boolean opNext = argIter.next(rcb);
        if (!opNext) {
            state.done();
            return false;
        }
        FieldValueImpl argValue = rcb.getRegVal(argIter.getResultReg());
        assert (argValue != null);
        FieldValueImpl res = argValue.isNull() ? NullValueImpl.getInstance() : ArithUnaryOpIter.getNegativeOfValue(argValue, argIter.getLocation());
        rcb.setRegVal(this.theResultReg, res);
        state.done();
        return true;
    }

    public static FieldValueImpl getNegativeOfValue(FieldValueImpl argValue, QueryException.Location location) {
        FieldValueImpl res;
        FieldDef.Type argType = argValue.getType();
        switch (argType) {
            case INTEGER: {
                int iRes = -argValue.getInt();
                res = FieldDefImpl.integerDef.createInteger(iRes);
                break;
            }
            case LONG: {
                long lRes = -argValue.getLong();
                res = FieldDefImpl.longDef.createLong(lRes);
                break;
            }
            case FLOAT: {
                float fRes = -argValue.getFloat();
                res = FieldDefImpl.floatDef.createFloat(fRes);
                break;
            }
            case DOUBLE: {
                double dRes = -argValue.getDouble();
                res = FieldDefImpl.doubleDef.createDouble(dRes);
                break;
            }
            case NUMBER: {
                BigDecimal nRes = argValue.getDecimal().negate();
                res = FieldDefImpl.numberDef.createNumber(nRes);
                break;
            }
            default: {
                throw new QueryException("Operand in unary arithmetic operation has illegal type\nOperand type : " + argValue.getDefinition().getDDLString(), location);
            }
        }
        return res;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theArg.reset(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theArg.close(rcb);
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append('-');
        sb.append(",\n");
        this.theArg.display(sb, formatter);
    }
}

