/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.TestProblemException;

public class SybaseTransactionIsolationListener
extends SessionEventAdapter {
    HashMap<Connection, Integer> connections = new HashMap();
    public static int requiredVersion = 15;

    public static boolean isDatabaseVersionSupported(ServerSession serverSession) {
        int version;
        DatabaseAccessor accessor = (DatabaseAccessor)serverSession.allocateReadConnection();
        try {
            String strVersion = accessor.getConnectionMetaData().getDatabaseProductVersion();
            int iStart = strVersion.indexOf("/") + 1;
            int iEnd = strVersion.indexOf(".");
            String strIntVersion = strVersion.substring(iStart, iEnd);
            version = Integer.parseInt(strIntVersion);
        }
        catch (SQLException ex) {
            throw new TestProblemException("failed to obtain database version number", ex);
        }
        return version >= requiredVersion;
    }

    public void postAcquireConnection(SessionEvent event) {
        Connection conn = ((DatabaseAccessor)event.getResult()).getConnection();
        Statement stmt1 = null;
        Statement stmt2 = null;
        ResultSet result = null;
        try {
            stmt1 = conn.createStatement();
            result = stmt1.executeQuery("select @@isolation");
            result.next();
            Integer isolationLevel = new Integer(result.getInt(1));
            if (isolationLevel > 0) {
                stmt2 = conn.createStatement();
                stmt2.execute("set transaction isolation level 0");
                stmt2.close();
                this.connections.put(conn, isolationLevel);
            }
        }
        catch (SQLException sqlException) {
            throw new TestProblemException("postAcquireConnection failed. ", sqlException);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt1 != null) {
                try {
                    stmt1.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt2 != null) {
                try {
                    stmt2.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void preReleaseConnection(SessionEvent event) {
        Connection conn = ((DatabaseAccessor)event.getResult()).getConnection();
        Statement stmt = null;
        try {
            Integer isolationLevel = this.connections.remove(conn);
            if (isolationLevel != null) {
                stmt = conn.createStatement();
                stmt.execute("set transaction isolation level " + isolationLevel);
                stmt.close();
            }
        }
        catch (SQLException sqlException) {
            throw new TestProblemException("preReleaseConnection failed. ", sqlException);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

