/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.employee;

import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicTypeBuilder;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.testing.tests.jpa.dynamic.DynamicEmployeeEntityComparator;
import org.junit.Assert;

public class DynamicEmployeeSystem {
    public static final String PACKAGE_PREFIX = DynamicEmployeeSystem.class.getPackage().getName();
    protected DynamicEntity[] employees = null;
    protected DynamicEntity[] projects = null;

    public DynamicEntity[] employees() {
        return this.employees;
    }

    public DynamicEntity[] projects() {
        return this.projects;
    }

    public void assertSame(List<DynamicEntity> dbEmps) {
        int index;
        Assert.assertEquals((String)"Incorrect quantity of employees", (long)this.employees.length, (long)dbEmps.size());
        Collections.sort(dbEmps, new DynamicEmployeeEntityComparator());
        ArrayList<DynamicEntity> sampleEmps = new ArrayList<DynamicEntity>();
        for (index = 0; index < this.employees.length; ++index) {
            sampleEmps.add(this.employees[index]);
        }
        Collections.sort(sampleEmps, new DynamicEmployeeEntityComparator());
        for (index = 0; index < this.employees.length; ++index) {
            DynamicEntity emp = (DynamicEntity)sampleEmps.get(index);
            DynamicEntity dbEmp = dbEmps.get(index);
            Assert.assertEquals((String)("First name does not match on employees[" + index + "]"), (Object)emp.get("firstName"), (Object)dbEmp.get("firstName"));
            Assert.assertEquals((String)("Last name does not match on employees[" + index + "]"), (Object)emp.get("lastName"), (Object)dbEmp.get("lastName"));
            Assert.assertEquals((String)("Salary does not match on employees[" + index + "]"), (Object)emp.get("salary"), (Object)dbEmp.get("salary"));
        }
    }

    public static DynamicEmployeeSystem buildProject(DynamicHelper dynamicHelper) {
        DynamicClassLoader dcl = dynamicHelper.getDynamicClassLoader();
        Class employeeClass = dcl.createDynamicClass(PACKAGE_PREFIX + ".Employee");
        Class addressClass = dcl.createDynamicClass(PACKAGE_PREFIX + ".Address");
        Class phoneClass = dcl.createDynamicClass(PACKAGE_PREFIX + ".PhoneNumber");
        Class periodClass = dcl.createDynamicClass(PACKAGE_PREFIX + ".EmploymentPeriod");
        Class projectClass = dcl.createDynamicClass(PACKAGE_PREFIX + ".Project");
        JPADynamicTypeBuilder employee = new JPADynamicTypeBuilder(employeeClass, null, new String[]{"D_EMPLOYEE", "D_SALARY"});
        JPADynamicTypeBuilder address = new JPADynamicTypeBuilder(addressClass, null, new String[]{"D_ADDRESS"});
        JPADynamicTypeBuilder phone = new JPADynamicTypeBuilder(phoneClass, null, new String[]{"D_PHONE"});
        JPADynamicTypeBuilder period = new JPADynamicTypeBuilder(periodClass, null, new String[0]);
        JPADynamicTypeBuilder project = new JPADynamicTypeBuilder(projectClass, null, new String[]{"D_PROJECT"});
        DynamicEmployeeSystem.configureAddress(address);
        DynamicEmployeeSystem.configureEmployee(employee, address, phone, period, project);
        DynamicEmployeeSystem.configurePhone(phone, employee);
        DynamicEmployeeSystem.configurePeriod(period);
        DynamicEmployeeSystem.configureProject(project, employee);
        employee.addManyToManyMapping("projects", project.getType(), "D_PROJ_EMP");
        dynamicHelper.addTypes(true, true, new DynamicType[]{employee.getType(), address.getType(), phone.getType(), period.getType(), project.getType()});
        return new DynamicEmployeeSystem();
    }

    private static void configurePhone(JPADynamicTypeBuilder phone, JPADynamicTypeBuilder employee) {
        phone.setPrimaryKeyFields(new String[]{"PHONE_TYPE", "EMP_ID"});
        phone.addDirectMapping("type", String.class, "PHONE_TYPE");
        phone.addDirectMapping("ownerId", Integer.TYPE, "EMP_ID").readOnly();
        phone.addDirectMapping("areaCode", String.class, "AREA_CODE");
        phone.addDirectMapping("number", String.class, "PNUMBER");
        phone.addOneToOneMapping("owner", employee.getType(), new String[]{"EMP_ID"});
    }

    private static void configureAddress(JPADynamicTypeBuilder address) {
        address.setPrimaryKeyFields(new String[]{"ADDR_ID"});
        address.addDirectMapping("id", Integer.TYPE, "ADDR_ID");
        address.addDirectMapping("street", String.class, "STREET");
        address.addDirectMapping("city", String.class, "CITY");
        address.addDirectMapping("province", String.class, "PROV");
        address.addDirectMapping("postalCode", String.class, "P_CODE");
        address.addDirectMapping("country", String.class, "COUNTRY");
        address.configureSequencing("ADDR_SEQ", "ADDR_ID");
    }

    private static void configureEmployee(JPADynamicTypeBuilder employee, JPADynamicTypeBuilder address, JPADynamicTypeBuilder phone, JPADynamicTypeBuilder period, JPADynamicTypeBuilder project) {
        employee.setPrimaryKeyFields(new String[]{"EMP_ID"});
        employee.addDirectMapping("id", Integer.TYPE, "D_EMPLOYEE.EMP_ID");
        employee.addDirectMapping("firstName", String.class, "D_EMPLOYEE.F_NAME");
        employee.addDirectMapping("lastName", String.class, "D_EMPLOYEE.L_NAME");
        employee.addDirectMapping("gender", String.class, "D_EMPLOYEE.GENDER");
        employee.addDirectMapping("salary", Integer.TYPE, "D_SALARY.SALARY");
        OneToOneMapping addressMapping = employee.addOneToOneMapping("address", address.getType(), new String[]{"ADDR_ID"});
        addressMapping.setCascadeAll(true);
        addressMapping.setIsPrivateOwned(true);
        employee.addOneToOneMapping("manager", employee.getType(), new String[]{"MANAGER_ID"});
        OneToManyMapping phoneMapping = employee.addOneToManyMapping("phoneNumbers", phone.getType(), new String[]{"EMP_ID"});
        phoneMapping.setCascadeAll(true);
        phoneMapping.setIsPrivateOwned(true);
        employee.addAggregateObjectMapping("period", period.getType(), true);
        employee.addOneToManyMapping("managedEmployees", employee.getType(), new String[]{"MANAGER_ID"});
        employee.configureSequencing("EMP_SEQ", "EMP_ID");
    }

    private static void configurePeriod(JPADynamicTypeBuilder period) {
        period.addDirectMapping("startDate", Date.class, "START_DATE");
        period.addDirectMapping("endDate", Date.class, "END_DATE");
    }

    private static void configureProject(JPADynamicTypeBuilder project, JPADynamicTypeBuilder employee) {
        project.setPrimaryKeyFields(new String[]{"PROJ_ID"});
        project.addDirectMapping("id", Integer.TYPE, "PROJ_ID");
        project.addDirectMapping("name", String.class, "NAME");
        project.addDirectMapping("description", String.class, "DESCRIP");
        project.configureSequencing("PROJ_SEQ", "PROJ_ID");
    }

    public void populate(JPADynamicHelper dynamicHelper, EntityManager em) {
        int index;
        DynamicEntity[] employees = new DynamicEntity[]{this.basicEmployeeExample1(dynamicHelper), this.basicEmployeeExample2(dynamicHelper), this.basicEmployeeExample3(dynamicHelper), this.basicEmployeeExample4(dynamicHelper), this.basicEmployeeExample5(dynamicHelper), this.basicEmployeeExample6(dynamicHelper), this.basicEmployeeExample7(dynamicHelper), this.basicEmployeeExample8(dynamicHelper), this.basicEmployeeExample9(dynamicHelper), this.basicEmployeeExample10(dynamicHelper), this.basicEmployeeExample11(dynamicHelper), this.basicEmployeeExample12(dynamicHelper)};
        this.employees = employees;
        DynamicEntity[] projects = new DynamicEntity[]{this.basicProjectExample1(dynamicHelper), this.basicProjectExample2(dynamicHelper), this.basicProjectExample3(dynamicHelper), this.basicProjectExample4(dynamicHelper), this.basicProjectExample5(dynamicHelper), this.basicProjectExample6(dynamicHelper), this.basicProjectExample7(dynamicHelper), this.basicProjectExample8(dynamicHelper), this.basicProjectExample9(dynamicHelper), this.basicProjectExample10(dynamicHelper)};
        this.projects = projects;
        this.addManagedEmployees(dynamicHelper, employees, 0, new int[]{2, 3, 4});
        this.addManagedEmployees(dynamicHelper, employees, 1, new int[]{5, 0});
        this.addManagedEmployees(dynamicHelper, employees, 2, new int[0]);
        this.addManagedEmployees(dynamicHelper, employees, 3, new int[0]);
        this.addManagedEmployees(dynamicHelper, employees, 4, new int[0]);
        this.addManagedEmployees(dynamicHelper, employees, 5, new int[0]);
        this.addManagedEmployees(dynamicHelper, employees, 6, new int[0]);
        this.addManagedEmployees(dynamicHelper, employees, 7, new int[0]);
        this.addManagedEmployees(dynamicHelper, employees, 8, new int[0]);
        this.addManagedEmployees(dynamicHelper, employees, 9, new int[]{7, 8, 10, 11});
        this.addManagedEmployees(dynamicHelper, employees, 10, new int[]{6});
        this.addManagedEmployees(dynamicHelper, employees, 11, new int[]{1});
        this.addProjects(dynamicHelper, employees, projects, 0, new int[]{0, 1, 2});
        this.addProjects(dynamicHelper, employees, projects, 1, new int[]{3, 4, 0});
        this.addProjects(dynamicHelper, employees, projects, 2, new int[]{3});
        this.addProjects(dynamicHelper, employees, projects, 4, new int[]{3, 1});
        this.addProjects(dynamicHelper, employees, projects, 5, new int[0]);
        this.addProjects(dynamicHelper, employees, projects, 6, new int[0]);
        em.getTransaction().begin();
        for (index = 0; index < this.employees.length; ++index) {
            em.persist((Object)this.employees[index]);
        }
        for (index = 0; index < this.projects.length; ++index) {
            em.persist((Object)this.projects[index]);
        }
        em.getTransaction().commit();
        em.close();
    }

    protected DynamicEntity basicEmployeeExample1(JPADynamicHelper dynamicHelper) {
        DynamicEntity employee = this.newInstance(dynamicHelper, "Employee");
        employee.set("firstName", (Object)"Bob");
        employee.set("lastName", (Object)"Smith");
        employee.set("gender", (Object)"Male");
        employee.set("salary", (Object)35000);
        this.setPeriod(dynamicHelper, employee, new Date(1993, 0, 1), new Date(1996, 0, 1));
        DynamicEntity address = this.newInstance(dynamicHelper, "Address");
        address.set("city", (Object)"Toronto");
        address.set("postalCode", (Object)"L5J2B5");
        address.set("province", (Object)"ONT");
        address.set("street", (Object)"1450 Acme Cr., Suite 4");
        address.set("country", (Object)"Canada");
        employee.set("address", (Object)address);
        this.addPhoneNumber(dynamicHelper, employee, "Work", "613", "5558812");
        return employee;
    }

    protected DynamicEntity basicEmployeeExample2(JPADynamicHelper dynamicHelper) {
        DynamicEntity employee = this.newInstance(dynamicHelper, "Employee");
        employee.set("firstName", (Object)"John");
        employee.set("lastName", (Object)"Way");
        employee.set("gender", (Object)"Male");
        employee.set("salary", (Object)53000);
        this.setPeriod(dynamicHelper, employee, new Date(1991, 10, 11), null);
        DynamicEntity address = this.newInstance(dynamicHelper, "Address");
        address.set("city", (Object)"Ottawa");
        address.set("postalCode", (Object)"K5J2B5");
        address.set("province", (Object)"ONT");
        address.set("street", (Object)"12 Merivale Rd., Suite 5");
        address.set("country", (Object)"Canada");
        employee.set("address", (Object)address);
        this.addPhoneNumber(dynamicHelper, employee, "Work", "613", "5558812");
        this.addPhoneNumber(dynamicHelper, employee, "ISDN", "905", "5553691");
        return employee;
    }

    protected DynamicEntity basicEmployeeExample3(JPADynamicHelper dynamicHelper) {
        DynamicEntity employee = this.newInstance(dynamicHelper, "Employee");
        employee.set("firstName", (Object)"Charles");
        employee.set("lastName", (Object)"Chanley");
        employee.set("gender", (Object)"Male");
        employee.set("salary", (Object)43000);
        this.setPeriod(dynamicHelper, employee, new Date(1995, 0, 1), new Date(2001, 11, 31));
        DynamicEntity address = this.newInstance(dynamicHelper, "Address");
        address.set("city", (Object)"Montreal");
        address.set("postalCode", (Object)"Q2S5Z5");
        address.set("province", (Object)"QUE");
        address.set("street", (Object)"1 Canadien Place");
        address.set("country", (Object)"Canada");
        employee.set("address", (Object)address);
        this.addPhoneNumber(dynamicHelper, employee, "Pager", "976", "5556666");
        this.addPhoneNumber(dynamicHelper, employee, "ISDN", "905", "5553691");
        return employee;
    }

    protected DynamicEntity basicEmployeeExample4(JPADynamicHelper dynamicHelper) {
        DynamicEntity employee = this.newInstance(dynamicHelper, "Employee");
        employee.set("firstName", (Object)"Emanual");
        employee.set("lastName", (Object)"Smith");
        employee.set("gender", (Object)"Male");
        employee.set("salary", (Object)49631);
        this.setPeriod(dynamicHelper, employee, new Date(2001, 11, 31), new Date(1995, 0, 1));
        DynamicEntity address = this.newInstance(dynamicHelper, "Address");
        address.set("city", (Object)"Vancouver");
        address.set("postalCode", (Object)"N5J2N5");
        address.set("province", (Object)"BC");
        address.set("street", (Object)"20 Mountain Blvd., Floor 53, Suite 6");
        address.set("country", (Object)"Canada");
        employee.set("address", (Object)address);
        this.addPhoneNumber(dynamicHelper, employee, "Work Fax", "613", "5555943");
        this.addPhoneNumber(dynamicHelper, employee, "Cellular", "416", "5551111");
        this.addPhoneNumber(dynamicHelper, employee, "Pager", "976", "5556666");
        this.addPhoneNumber(dynamicHelper, employee, "ISDN", "905", "5553691");
        return employee;
    }

    protected DynamicEntity basicEmployeeExample5(JPADynamicHelper dynamicHelper) {
        DynamicEntity employee = this.newInstance(dynamicHelper, "Employee");
        employee.set("firstName", (Object)"Sarah");
        employee.set("lastName", (Object)"Way");
        employee.set("gender", (Object)"Female");
        employee.set("salary", (Object)87000);
        this.setPeriod(dynamicHelper, employee, new Date(2001, 6, 31), new Date(1995, 4, 1));
        DynamicEntity address = this.newInstance(dynamicHelper, "Address");
        address.set("city", (Object)"Prince Rupert");
        address.set("postalCode", (Object)"K3K5D5");
        address.set("province", (Object)"BC");
        address.set("street", (Object)"3254 Parkway Place");
        address.set("country", (Object)"Canada");
        employee.set("address", (Object)address);
        this.addPhoneNumber(dynamicHelper, employee, "Work", "613", "5558812");
        this.addPhoneNumber(dynamicHelper, employee, "ISDN", "905", "5553691");
        this.addPhoneNumber(dynamicHelper, employee, "Home", "613", "5551234");
        return employee;
    }

    protected DynamicEntity basicEmployeeExample6(JPADynamicHelper dynamicHelper) {
        DynamicEntity employee = this.newInstance(dynamicHelper, "Employee");
        employee.set("firstName", (Object)"Marcus");
        employee.set("lastName", (Object)"Saunders");
        employee.set("gender", (Object)"Male");
        employee.set("salary", (Object)54300);
        this.setPeriod(dynamicHelper, employee, new Date(2001, 11, 31), new Date(1995, 0, 12));
        DynamicEntity address = this.newInstance(dynamicHelper, "Address");
        address.set("city", (Object)"Perth");
        address.set("postalCode", (Object)"Y3Q2N9");
        address.set("province", (Object)"ONT");
        address.set("street", (Object)"234 Caledonia Lane");
        address.set("country", (Object)"Canada");
        employee.set("address", (Object)address);
        this.addPhoneNumber(dynamicHelper, employee, "ISDN", "905", "5553691");
        this.addPhoneNumber(dynamicHelper, employee, "Work", "613", "5558812");
        return employee;
    }

    protected DynamicEntity basicEmployeeExample7(JPADynamicHelper dynamicHelper) {
        DynamicEntity employee = this.newInstance(dynamicHelper, "Employee");
        employee.set("firstName", (Object)"Nancy");
        employee.set("lastName", (Object)"White");
        employee.set("gender", (Object)"Female");
        employee.set("salary", (Object)31000);
        this.setPeriod(dynamicHelper, employee, new Date(1996, 0, 1), new Date(1993, 0, 1));
        DynamicEntity address = this.newInstance(dynamicHelper, "Address");
        address.set("city", (Object)"Metcalfe");
        address.set("postalCode", (Object)"Y4F7V6");
        address.set("province", (Object)"ONT");
        address.set("street", (Object)"2 Anderson Rd.");
        address.set("country", (Object)"Canada");
        employee.set("address", (Object)address);
        this.addPhoneNumber(dynamicHelper, employee, "Home", "613", "5551234");
        return employee;
    }

    protected DynamicEntity basicEmployeeExample8(JPADynamicHelper dynamicHelper) {
        DynamicEntity employee = this.newInstance(dynamicHelper, "Employee");
        employee.set("firstName", (Object)"Fred");
        employee.set("lastName", (Object)"Jones");
        employee.set("gender", (Object)"Male");
        employee.set("salary", (Object)500000);
        this.setPeriod(dynamicHelper, employee, new Date(2001, 11, 31), new Date(1995, 0, 1));
        DynamicEntity address = this.newInstance(dynamicHelper, "Address");
        address.set("city", (Object)"Victoria");
        address.set("postalCode", (Object)"Z5J2N5");
        address.set("province", (Object)"BC");
        address.set("street", (Object)"382 Hyde Park Blvd.");
        address.set("country", (Object)"Canada");
        employee.set("address", (Object)address);
        this.addPhoneNumber(dynamicHelper, employee, "Cellular", "416", "5551111");
        this.addPhoneNumber(dynamicHelper, employee, "ISDN", "905", "5553691");
        return employee;
    }

    protected DynamicEntity basicEmployeeExample9(JPADynamicHelper dynamicHelper) {
        DynamicEntity employee = this.newInstance(dynamicHelper, "Employee");
        employee.set("firstName", (Object)"Betty");
        employee.set("lastName", (Object)"Jones");
        employee.set("gender", (Object)"Female");
        employee.set("salary", (Object)500001);
        this.setPeriod(dynamicHelper, employee, new Date(2001, 11, 31), new Date(1995, 0, 1));
        DynamicEntity address = this.newInstance(dynamicHelper, "Address");
        address.set("city", (Object)"Smith Falls");
        address.set("postalCode", (Object)"C6C6C6");
        address.set("province", (Object)"ONT");
        address.set("street", (Object)"89 Chocolate Drive");
        address.set("country", (Object)"Canada");
        employee.set("address", (Object)address);
        this.addPhoneNumber(dynamicHelper, employee, "Work", "613", "5558812");
        this.addPhoneNumber(dynamicHelper, employee, "ISDN", "905", "5553691");
        return employee;
    }

    protected DynamicEntity basicEmployeeExample10(JPADynamicHelper dynamicHelper) {
        DynamicEntity employee = this.newInstance(dynamicHelper, "Employee");
        employee.set("firstName", (Object)"Jill");
        employee.set("lastName", (Object)"May");
        employee.set("gender", (Object)"Female");
        this.setPeriod(dynamicHelper, employee, new Date(1991, 10, 111), null);
        DynamicEntity address = this.newInstance(dynamicHelper, "Address");
        address.set("city", (Object)"Calgary");
        address.set("postalCode", (Object)"J5J2B5");
        address.set("province", (Object)"AB");
        address.set("street", (Object)"1111 Mooseland Rd.");
        address.set("country", (Object)"Canada");
        employee.set("address", (Object)address);
        employee.set("salary", (Object)56232);
        this.addPhoneNumber(dynamicHelper, employee, "Work", "613", "5558812");
        this.addPhoneNumber(dynamicHelper, employee, "Work Fax", "613", "5555943");
        return employee;
    }

    protected DynamicEntity basicEmployeeExample11(JPADynamicHelper dynamicHelper) {
        DynamicEntity employee = this.newInstance(dynamicHelper, "Employee");
        employee.set("firstName", (Object)"Sarah-Lou");
        employee.set("lastName", (Object)"Smitty");
        employee.set("gender", (Object)"Female");
        this.setPeriod(dynamicHelper, employee, new Date(1993, 0, 1), new Date(1996, 0, 1));
        DynamicEntity address = this.newInstance(dynamicHelper, "Address");
        address.set("city", (Object)"Arnprior");
        address.set("postalCode", (Object)"W1A2B5");
        address.set("province", (Object)"ONT");
        address.set("street", (Object)"1 Hawthorne Drive");
        address.set("country", (Object)"Canada");
        employee.set("address", (Object)address);
        employee.set("salary", (Object)75000);
        this.addPhoneNumber(dynamicHelper, employee, "Work Fax", "613", "5555943");
        this.addPhoneNumber(dynamicHelper, employee, "Home", "613", "5551234");
        this.addPhoneNumber(dynamicHelper, employee, "Cellular", "416", "5551111");
        return employee;
    }

    protected DynamicEntity basicEmployeeExample12(JPADynamicHelper dynamicHelper) {
        DynamicEntity employee = this.newInstance(dynamicHelper, "Employee");
        employee.set("firstName", (Object)"Jim-Bob");
        employee.set("lastName", (Object)"Jefferson");
        employee.set("gender", (Object)"Male");
        this.setPeriod(dynamicHelper, employee, new Date(1995, 0, 12), new Date(2001, 11, 31));
        DynamicEntity address = this.newInstance(dynamicHelper, "Address");
        address.set("city", (Object)"Yellowknife");
        address.set("postalCode", (Object)"Y5J2N5");
        address.set("province", (Object)"YK");
        address.set("street", (Object)"1112 Gold Rush Rd.");
        address.set("country", (Object)"Canada");
        employee.set("address", (Object)address);
        employee.set("salary", (Object)50000);
        this.addPhoneNumber(dynamicHelper, employee, "Home", "613", "5551234");
        this.addPhoneNumber(dynamicHelper, employee, "Cellular", "416", "5551111");
        return employee;
    }

    protected DynamicEntity basicProjectExample1(JPADynamicHelper dynamicHelper) {
        DynamicEntity project = this.newInstance(dynamicHelper, "Project");
        project.set("name", (Object)"Enterprise");
        project.set("description", (Object)"A enterprise wide application to report on the corporations database through TopLink.");
        return project;
    }

    protected DynamicEntity basicProjectExample2(JPADynamicHelper dynamicHelper) {
        DynamicEntity project = this.newInstance(dynamicHelper, "Project");
        project.set("name", (Object)"Sales Reporter");
        project.set("description", (Object)"A reporting application using JDK to report on the corporations database through TopLink.");
        return project;
    }

    protected DynamicEntity basicProjectExample3(JPADynamicHelper dynamicHelper) {
        DynamicEntity project = this.newInstance(dynamicHelper, "Project");
        project.set("name", (Object)"TOP-Employee Manager");
        project.set("description", (Object)"A management application to report on the corporations database through TopLink.");
        return project;
    }

    protected DynamicEntity basicProjectExample4(JPADynamicHelper dynamicHelper) {
        DynamicEntity project = this.newInstance(dynamicHelper, "Project");
        project.set("name", (Object)"Problem Reporter");
        project.set("description", (Object)"A PRS application to report on the corporations database through TopLink.");
        return project;
    }

    protected DynamicEntity basicProjectExample5(JPADynamicHelper dynamicHelper) {
        DynamicEntity project = this.newInstance(dynamicHelper, "Project");
        project.set("name", (Object)"Feather Reporter");
        project.set("description", (Object)"An extremely lightweight application to report on the corporations database through TopLink.");
        return project;
    }

    protected DynamicEntity basicProjectExample6(JPADynamicHelper dynamicHelper) {
        DynamicEntity project = this.newInstance(dynamicHelper, "Project");
        project.set("name", (Object)"Makework");
        project.set("description", (Object)"A makework project.");
        return project;
    }

    protected DynamicEntity basicProjectExample7(JPADynamicHelper dynamicHelper) {
        DynamicEntity project = this.newInstance(dynamicHelper, "Project");
        project.set("name", (Object)"Marketing Query Tool");
        project.set("description", (Object)"A tool to help marketing query various things.");
        return project;
    }

    protected DynamicEntity basicProjectExample8(JPADynamicHelper dynamicHelper) {
        DynamicEntity project = this.newInstance(dynamicHelper, "Project");
        project.set("name", (Object)"Shipping Query Tool");
        project.set("description", (Object)"A tool to help shipping query various things.");
        return project;
    }

    protected DynamicEntity basicProjectExample9(JPADynamicHelper dynamicHelper) {
        DynamicEntity project = this.newInstance(dynamicHelper, "Project");
        project.set("name", (Object)"Accounting Query Tool");
        project.set("description", (Object)"A tool to help accounting query various things.");
        return project;
    }

    protected DynamicEntity basicProjectExample10(JPADynamicHelper dynamicHelper) {
        DynamicEntity project = this.newInstance(dynamicHelper, "Project");
        project.set("name", (Object)"Staff Query Tool");
        project.set("description", (Object)"A tool to help staff query various things.");
        return project;
    }

    protected DynamicEntity addPhoneNumber(JPADynamicHelper dynamicHelper, DynamicEntity employee, String type, String areaCode, String number) {
        DynamicEntity phone = this.newInstance(dynamicHelper, "PhoneNumber");
        phone.set("type", (Object)type);
        phone.set("areaCode", (Object)areaCode);
        phone.set("number", (Object)number);
        phone.set("owner", (Object)employee);
        ((Collection)employee.get("phoneNumbers")).add(phone);
        return phone;
    }

    protected void setPeriod(JPADynamicHelper dynamicHelper, DynamicEntity employee, Date startDate, Date endDate) {
        DynamicEntity period = this.newInstance(dynamicHelper, "EmploymentPeriod");
        period.set("startDate", (Object)startDate);
        period.set("endDate", (Object)endDate);
        employee.set("period", (Object)period);
    }

    protected void addManagedEmployees(JPADynamicHelper dynamicHelper, DynamicEntity[] employees, int managerIndex, int[] employeeIndeces) {
        DynamicEntity manager = employees[managerIndex];
        if (((Collection)manager.get("managedEmployees")).isEmpty()) {
            for (int index = 0; index < employeeIndeces.length; ++index) {
                ((Collection)manager.get("managedEmployees")).add(employees[employeeIndeces[index]]);
            }
        }
    }

    protected void addProjects(JPADynamicHelper dynamicHelper, DynamicEntity[] employees, DynamicEntity[] projects, int empIndex, int[] projIndeces) {
        DynamicEntity employee = employees[empIndex];
        for (int index = 0; index < projIndeces.length; ++index) {
            ((Collection)employee.get("projects")).add(projects[projIndeces[index]]);
        }
    }

    protected DynamicEntity newInstance(JPADynamicHelper dynamicHelper, String entityAlias) {
        return dynamicHelper.newDynamicEntity(entityAlias);
    }
}

