/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.relationships;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.Query;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.relationships.Customer;
import org.eclipse.persistence.testing.models.jpa.relationships.Order;
import org.eclipse.persistence.testing.models.jpa.relationships.RelationshipsTableManager;

public class EMQueryJUnitTestSuite
extends JUnitTestCase {
    protected Integer nonExistingCustomerId = new Integer(999999);

    public EMQueryJUnitTestSuite() {
    }

    public EMQueryJUnitTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("EMQueryJUnitTestSuite");
        suite.addTest((Test)new EMQueryJUnitTestSuite("testSetup"));
        suite.addTest((Test)new EMQueryJUnitTestSuite("testgetReference"));
        suite.addTest((Test)new EMQueryJUnitTestSuite("testcreateNativeQuery"));
        suite.addTest((Test)new EMQueryJUnitTestSuite("testcreateNativeQueryWithSelectSQL"));
        suite.addTest((Test)new EMQueryJUnitTestSuite("testNativeNamedQuery"));
        suite.addTest((Test)new EMQueryJUnitTestSuite("testSetParameterUsingNull"));
        suite.addTest((Test)new EMQueryJUnitTestSuite("testExcludingUnneccesaryJoin"));
        suite.addTest((Test)new EMQueryJUnitTestSuite("testRemoveUnneccesaryDistinctFromJoin"));
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        new RelationshipsTableManager().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
    }

    public void testgetReference() throws Exception {
        Customer customer = null;
        Exception exception = null;
        try {
            customer = (Customer)this.createEntityManager().getReference(Customer.class, (Object)this.nonExistingCustomerId);
            customer.getCity();
        }
        catch (Exception e) {
            exception = e;
        }
        EMQueryJUnitTestSuite.assertTrue((String)"getReference() did not throw an instance of EntityNotFoundException", (boolean)(exception instanceof EntityNotFoundException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testcreateNativeQuery() throws Exception {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Query query1 = em.createNativeQuery("Select * FROM CMP3_CUSTOMER");
            Query query2 = em.createNativeQuery("INSERT INTO CMP3_CUSTOMER (CUST_ID, NAME, CITY, CUST_VERSION) VALUES (1111, NULL, NULL, 1)");
            Query query3 = em.createNativeQuery("DELETE FROM CMP3_CUSTOMER WHERE (CUST_ID=1111)");
            List c1 = query1.getResultList();
            if (c1 != null && c1.size() > 0) {
                EMQueryJUnitTestSuite.assertTrue((String)"getResultList returned null ", (c1 != null ? 1 : 0) != 0);
            }
            query2.executeUpdate();
            List c2 = query1.getResultList();
            EMQueryJUnitTestSuite.assertTrue((String)"getResultList returned null ", (c2 != null ? 1 : 0) != 0);
            query3.executeUpdate();
            List c3 = query1.getResultList();
            EMQueryJUnitTestSuite.assertTrue((String)"getResultList returned null ", (c3 != null ? 1 : 0) != 0);
            EMQueryJUnitTestSuite.assertTrue((String)"Native Select query gave unexpected result after Native Insert query ", (c2.size() == c1.size() + 1 ? 1 : 0) != 0);
            EMQueryJUnitTestSuite.assertTrue((String)"Native Select query gave unexpected result after Native Delete query ", (c3.size() == c1.size() ? 1 : 0) != 0);
        }
        finally {
            try {
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testcreateNativeQueryWithSelectSQL() throws Exception {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Query query1 = em.createNativeQuery("Select * FROM CMP3_CUSTOMER");
            List c1 = query1.getResultList();
            EMQueryJUnitTestSuite.assertTrue((String)"getResultList returned null ", (c1 != null ? 1 : 0) != 0);
            int result = 0;
            try {
                result = query1.executeUpdate();
            }
            catch (RuntimeException ex) {
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
                em = this.createEntityManager();
                this.beginTransaction(em);
                query1 = em.createNativeQuery("Select * FROM CMP3_CUSTOMER");
            }
            Query query2 = em.createNativeQuery("INSERT INTO CMP3_CUSTOMER (CUST_ID, NAME, CITY, CUST_VERSION) VALUES (1111, NULL, NULL, 1)");
            Query query3 = em.createNativeQuery("DELETE FROM CMP3_CUSTOMER WHERE (CUST_ID=1111)");
            query2.executeUpdate();
            List c2 = query1.getResultList();
            EMQueryJUnitTestSuite.assertTrue((String)"getResultList returned null ", (c2 != null ? 1 : 0) != 0);
            query3.executeUpdate();
            List c3 = query1.getResultList();
            EMQueryJUnitTestSuite.assertTrue((String)"getResultList returned null ", (c3 != null ? 1 : 0) != 0);
            EMQueryJUnitTestSuite.assertTrue((String)("Native Select query run with executeUpdate modified " + result + " rows "), (result == 0 ? 1 : 0) != 0);
            EMQueryJUnitTestSuite.assertTrue((String)"Native Select query gave unexpected result after Native Insert query ", (c2.size() == c1.size() + 1 ? 1 : 0) != 0);
            EMQueryJUnitTestSuite.assertTrue((String)"Native Select query gave unexpected result after Native Delete query ", (c3.size() == c1.size() ? 1 : 0) != 0);
        }
        finally {
            try {
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNativeNamedQuery() throws Exception {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Query query1 = em.createNamedQuery("findAllSQLCustomers");
            Query query2 = em.createNamedQuery("insertCustomer1111SQL");
            Query query3 = em.createNamedQuery("deleteCustomer1111SQL");
            List c1 = query1.getResultList();
            EMQueryJUnitTestSuite.assertTrue((String)"getResultList returned null ", (c1 != null ? 1 : 0) != 0);
            query2.executeUpdate();
            List c2 = query1.getResultList();
            EMQueryJUnitTestSuite.assertTrue((String)"getResultList returned null ", (c2 != null ? 1 : 0) != 0);
            query3.executeUpdate();
            List c3 = query1.getResultList();
            EMQueryJUnitTestSuite.assertTrue((String)"getResultList returned null ", (c3 != null ? 1 : 0) != 0);
            EMQueryJUnitTestSuite.assertTrue((String)"Named Native Select query gave unexpected result after Named Native Insert query ", (c2.size() == c1.size() + 1 ? 1 : 0) != 0);
            EMQueryJUnitTestSuite.assertTrue((String)"Named Native Select query gave unexpected result after Named Native Delete query ", (c3.size() == c1.size() ? 1 : 0) != 0);
        }
        finally {
            try {
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
            }
            catch (Exception exception) {}
        }
    }

    public void testSetParameterUsingNull() throws Exception {
        try {
            this.createEntityManager().createQuery("Select Distinct Object(c) from Customer c where c.name = :cName").setParameter("cName", null).getResultList();
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExcludingUnneccesaryJoin() throws Exception {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Order o = new Order();
            Order o2 = new Order();
            em.persist((Object)o);
            em.persist((Object)o2);
            List results = em.createQuery("Select Distinct Object(a) From OrderBean a where a.item Is Null OR a.item <> a.item").getResultList();
            EMQueryJUnitTestSuite.assertTrue((String)"Incorrect results returned when testing equal does not produce an unnecessary join ", (results.size() == 2 ? 1 : 0) != 0);
        }
        finally {
            try {
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveUnneccesaryDistinctFromJoin() throws Exception {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Customer c = new Customer();
            Order o = new Order();
            o.setShippingAddress("somerandomaddress");
            o.setCustomer(c);
            Order o2 = new Order();
            o2.setShippingAddress("somerandomaddress");
            o2.setCustomer(c);
            c.getOrders().add(o);
            c.getOrders().add(o2);
            em.persist((Object)c);
            em.flush();
            List results1 = em.createQuery("Select Object(a) From Customer a JOIN a.orders o where o.shippingAddress = 'somerandomaddress'").getResultList();
            List results2 = em.createQuery("Select Distinct a From Customer a JOIN a.orders o where o.shippingAddress = 'somerandomaddress'").getResultList();
            EMQueryJUnitTestSuite.assertTrue((String)"Unexpected results returned from query without distinct clause", (results1.size() == results2.size() + 1 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
        }
    }
}

