/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.validation;

import jakarta.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;

public class QueryParameterValidationTestSuite
extends JUnitTestCase {
    public QueryParameterValidationTestSuite() {
    }

    public QueryParameterValidationTestSuite(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.clearCache();
    }

    public void testParameterNameValidation() {
        Query query = this.createEntityManager().createQuery("Select e from Employee e where e.lastName like :name ");
        try {
            query.setParameter("l", (Object)"%ay");
            query.getResultList();
        }
        catch (IllegalArgumentException ex) {
            QueryParameterValidationTestSuite.assertTrue((String)"Failed to throw expected IllegalArgumentException, when incorrect parameter name is used", (boolean)ex.getMessage().contains("using a name"));
            return;
        }
        QueryParameterValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException, when incorrect parameter name is used");
    }

    public void testParameterPositionValidation() {
        Query query = this.createEntityManager().createQuery("Select e from Employee e where e.firstName like ?1 ");
        try {
            query.setParameter(2, (Object)"%ay");
            query.getResultList();
        }
        catch (IllegalArgumentException ex) {
            QueryParameterValidationTestSuite.assertTrue((String)"Failed to throw expected IllegalArgumentException, when incorrect parameter name is used", (boolean)ex.getMessage().contains("parameter at position"));
            return;
        }
        QueryParameterValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException, when incorrect parameter position is used");
    }

    public void testParameterPositionValidation2() {
        Query query = this.createEntityManager().createQuery("Select e from Employee e where e.firstName = ?1 AND e.lastName = ?3 ");
        try {
            query.setParameter(1, (Object)"foo");
            query.setParameter(2, (Object)"");
            query.setParameter(3, (Object)"bar");
            query.getResultList();
        }
        catch (IllegalArgumentException ex) {
            QueryParameterValidationTestSuite.assertTrue((String)"Failed to throw expected IllegalArgumentException, when incorrect parameter name is used", (boolean)ex.getMessage().contains("parameter at position"));
            return;
        }
        QueryParameterValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException, when incorrect parameter position is used");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(QueryParameterValidationTestSuite.class);
        suite.setName("QueryParameterValidationTestSuite");
        return suite;
    }
}

