/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer.refresh;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sphinx.emf.explorer.IModelCommonContentProvider;
import org.eclipse.sphinx.emf.explorer.refresh.AbstractRefreshStrategy;

public class ModelResourceRefreshStrategy
extends AbstractRefreshStrategy<Resource>
implements Runnable {
    private static final int MAX_INDIVIDUAL_MODEL_RESOURCE_REFRESHES = 20;

    public ModelResourceRefreshStrategy(IModelCommonContentProvider contentProvider, boolean preserveTreeViewerState) {
        super(contentProvider, preserveTreeViewerState);
    }

    @Override
    protected boolean shouldPerformSelectiveRefresh() {
        return this.getTreeElementsToRefresh().size() < 20;
    }

    @Override
    protected void performSelectiveRefresh(StructuredViewer viewer) {
        for (Resource modelResource : this.getTreeElementsToRefresh()) {
            IResource workspaceResource = this.contentProvider.getWorkspaceResource(modelResource);
            if (workspaceResource == null || !workspaceResource.isAccessible() || !this.contentProvider.isTriggerPoint(workspaceResource) && modelResource.isLoaded()) continue;
            viewer.refresh((Object)workspaceResource, true);
        }
    }
}

