/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.fields;

import org.eclipse.sphinx.platform.ui.fields.BasicField;
import org.eclipse.sphinx.platform.ui.internal.util.LayoutUtil;
import org.eclipse.sphinx.platform.ui.widgets.IWidgetFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SelectionButtonField
extends BasicField {
    private Button fButton;
    private boolean fIsSelected = false;
    private BasicField[] fAttachedDialogFields = null;
    private int fButtonStyle;
    private String fButtonToolTip;

    public SelectionButtonField(int buttonStyle) {
        this(null, buttonStyle);
    }

    public SelectionButtonField(IWidgetFactory widgetFactory, int buttonStyle) {
        super(widgetFactory);
        this.fButtonStyle = buttonStyle;
    }

    public void attachDialogField(BasicField basicField) {
        this.attachDialogFields(new BasicField[]{basicField});
    }

    public void attachDialogFields(BasicField[] dialogFields) {
        this.fAttachedDialogFields = dialogFields;
        BasicField[] basicFieldArray = dialogFields;
        int n = dialogFields.length;
        int n2 = 0;
        while (n2 < n) {
            BasicField element = basicFieldArray[n2];
            element.setEnabled(this.fIsSelected);
            ++n2;
        }
    }

    public boolean isAttached(BasicField editor) {
        if (this.fAttachedDialogFields != null) {
            BasicField[] basicFieldArray = this.fAttachedDialogFields;
            int n = this.fAttachedDialogFields.length;
            int n2 = 0;
            while (n2 < n) {
                BasicField element = basicFieldArray[n2];
                if (element == editor) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected Control[] doFillIntoGrid(Composite parent, int nColumns) {
        Button button = this.getSelectionButton(parent);
        if (this.fUseFormLayout) {
            button.setLayoutData((Object)LayoutUtil.tableWrapDataForButton(button, nColumns));
        } else {
            button.setLayoutData((Object)LayoutUtil.gridDataForButton(button, nColumns));
        }
        return new Control[]{button};
    }

    protected int getNumberOfControls() {
        return 1;
    }

    public Button getSelectionButton(Composite group) {
        if (this.fButton == null) {
            this.assertCompositeNotNull(group);
            this.fButton = new Button(group, this.fButtonStyle);
            this.fButton.setFont(group.getFont());
            this.fButton.setText(this.fLabelText);
            this.fButton.setToolTipText(this.fButtonToolTip);
            this.fButton.setEnabled(this.isEnabled());
            this.fButton.setSelection(this.fIsSelected);
            this.fButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    SelectionButtonField.this.doWidgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    SelectionButtonField.this.doWidgetSelected(e);
                }
            });
        }
        return this.fButton;
    }

    public Control getButtonControl() {
        Button control = null;
        if (this.isOkToUse((Control)this.fButton)) {
            control = this.fButton;
        }
        return control;
    }

    private void doWidgetSelected(SelectionEvent e) {
        if (this.isOkToUse((Control)this.fButton)) {
            this.changeValue(this.fButton.getSelection());
        }
    }

    private void changeValue(boolean newState) {
        if (this.fIsSelected != newState) {
            this.fIsSelected = newState;
            if (this.fAttachedDialogFields != null) {
                boolean focusSet = false;
                BasicField[] basicFieldArray = this.fAttachedDialogFields;
                int n = this.fAttachedDialogFields.length;
                int n2 = 0;
                while (n2 < n) {
                    BasicField element = basicFieldArray[n2];
                    element.setEnabled(this.fIsSelected);
                    if (this.fIsSelected && !focusSet) {
                        focusSet = element.setFocus();
                    }
                    ++n2;
                }
            }
            this.dialogFieldChanged();
        } else if (this.fButtonStyle == 8) {
            this.dialogFieldChanged();
        }
    }

    public void setLabelText(String labeltext) {
        this.fLabelText = labeltext;
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setText(labeltext);
        }
    }

    public void setToolTipText(String toolTip) {
        this.fButtonToolTip = toolTip;
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setToolTipText(toolTip);
        }
    }

    public boolean isSelected() {
        return this.fIsSelected;
    }

    private void setButtonSelection(boolean selected) {
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setSelection(selected);
        }
    }

    public void setSelection(boolean selected) {
        this.changeValue(selected);
        this.setButtonSelection(selected);
    }

    public void setSelectionWithoutEvent(boolean selected) {
        this.fIsSelected = selected;
        this.setButtonSelection(selected);
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setEnabled(this.isEnabled());
        }
    }

    public void dispose() {
        super.dispose();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.dispose();
        }
        if (this.fAttachedDialogFields != null) {
            BasicField[] basicFieldArray = this.fAttachedDialogFields;
            int n = this.fAttachedDialogFields.length;
            int n2 = 0;
            while (n2 < n) {
                BasicField element = basicFieldArray[n2];
                element.dispose();
                ++n2;
            }
        }
    }

    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setSelection(this.fIsSelected);
        }
    }
}

