/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.internal.Tracing;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sphinx.emf.ui.internal.Activator;
import org.eclipse.sphinx.emf.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.ui.internal.views.ReferencesHierarchyTransferDropAdapter;
import org.eclipse.sphinx.emf.ui.internal.views.ToggleReferencesModeAction;
import org.eclipse.sphinx.emf.util.EObjectUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.platform.util.DirectedGraph;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public class ReferencesView
extends ViewPart {
    private static final String STORE_MODE = "MODE";
    public static final int REFERENCED_OBJECTS_MODE = 0;
    public static final int REFERENCING_OBJECTS_MODE = 1;
    private static final int PAGE_EMPTY = 0;
    private static final int PAGE_VIEWER = 1;
    private static final Object EMPTY_ROOT = new Object();
    private Object viewInput;
    private int currentMode;
    private Label noRefsHierarchyShownLabel;
    private TreeViewer viewer;
    private ILabelProvider labelProvider;
    private IContentProvider contentProvider;
    private IDialogSettings dialogSettings;
    private ToggleReferencesModeAction[] toggleReferencesModeActions;
    protected Map<TransactionalEditingDomain, IContentProvider> modelCrossReferenceContentProviders = new WeakHashMap<TransactionalEditingDomain, IContentProvider>();
    protected Map<TransactionalEditingDomain, ILabelProvider> modelLabelProviders = new WeakHashMap<TransactionalEditingDomain, ILabelProvider>();
    private Action doubleClickAction;
    private PageBook pageBook;
    private SashForm refsHierarchyInfosSplitter;
    private DirectedGraph<EObject> graph;

    public ReferencesView() {
        this.dialogSettings = Activator.getDefault().getDialogSettings();
        this.graph = new DirectedGraph(false, false);
    }

    public void createPartControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.refsHierarchyInfosSplitter = new SashForm((Composite)this.pageBook, 0);
        this.viewer = new TreeViewer((Composite)this.refsHierarchyInfosSplitter, 770);
        this.contentProvider = this.createModelCrossReferenceContentProvider();
        if (this.contentProvider != null) {
            this.viewer.setContentProvider(this.contentProvider);
        }
        if (this.labelProvider != null) {
            this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        this.noRefsHierarchyShownLabel = new Label((Composite)this.pageBook, 16576);
        this.noRefsHierarchyShownLabel.setText(Messages.label_ReferencesHierarchyEmpty);
        this.showPage(0);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.initMode();
    }

    private void showPage(int page) {
        Label control;
        boolean isEmpty = page == 0;
        Object object = control = isEmpty ? this.noRefsHierarchyShownLabel : this.refsHierarchyInfosSplitter;
        if (isEmpty) {
            this.setContentDescription("");
            this.setTitleToolTip(this.getPartName());
            this.getViewSite().getActionBars().getStatusLineManager().setMessage("");
            this.viewer.setInput(EMPTY_ROOT);
        }
        this.pageBook.showPage((Control)control);
    }

    protected TreeViewer getViewer() {
        return this.viewer;
    }

    public void setViewInput(Object viewInput) {
        this.viewInput = viewInput;
        this.labelProvider = this.getModelLabelProvider(viewInput);
        if (this.labelProvider != null) {
            this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        this.viewer.setInput(viewInput);
        this.updateView();
    }

    protected boolean isRecursive(Object element) {
        Set outgoingEdgesOfElement = this.graph.outgoingEdgesOf((Object)((EObject)element));
        Set incomingEdgesOfElement = this.graph.incomingEdgesOf((Object)((EObject)element));
        return !outgoingEdgesOfElement.isEmpty() && incomingEdgesOfElement.size() > 1;
    }

    protected IContentProvider createModelCrossReferenceContentProvider() {
        return new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public boolean hasChildren(Object element) {
                return !ReferencesView.this.isRecursive(element) && this.getChildren(element).length > 0;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof EObject) {
                    final EObject parentEObject = (EObject)parentElement;
                    ReferencesView.this.graph.addVertex((Object)parentEObject);
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)parentEObject);
                    if (editingDomain != null) {
                        try {
                            return (Object[])TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, (RunnableWithResult)new RunnableWithResult.Impl<Object[]>(){

                                public void run() {
                                    Collection<EObject> eCrossReferences = this.getECrossReferences(parentEObject);
                                    this.addEdges(parentEObject, eCrossReferences);
                                    this.setResult(eCrossReferences.toArray(new EObject[eCrossReferences.size()]));
                                }
                            });
                        }
                        catch (InterruptedException ex) {
                            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                        }
                    } else {
                        Collection<EObject> eCrossReferences = this.getECrossReferences(parentEObject);
                        this.addEdges(parentEObject, eCrossReferences);
                        return eCrossReferences.toArray(new EObject[eCrossReferences.size()]);
                    }
                }
                return new Object[0];
            }

            protected void addEdges(EObject parentEObject, Collection<EObject> eCrossReferences) {
                for (EObject crossRef : eCrossReferences) {
                    ReferencesView.this.graph.addVertex((Object)crossRef);
                    ReferencesView.this.graph.addEdge((Object)parentEObject, (Object)crossRef);
                }
            }

            protected Collection<EObject> getECrossReferences(EObject eObject) {
                if (ReferencesView.this.currentMode == 1) {
                    ArrayList<EObject> eInverseCrossReferences = new ArrayList<EObject>();
                    Collection inverseReferences = EObjectUtil.getInverseReferences((EObject)eObject, (boolean)true);
                    for (EStructuralFeature.Setting inverseReference : inverseReferences) {
                        eInverseCrossReferences.add(inverseReference.getEObject());
                    }
                    return eInverseCrossReferences;
                }
                return eObject.eCrossReferences();
            }

            public Object getParent(Object element) {
                return null;
            }

            public void dispose() {
            }
        };
    }

    protected ILabelProvider getModelLabelProvider(Object element) {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)element);
        if (editingDomain != null) {
            ILabelProvider modelLabelProvider = this.modelLabelProviders.get(editingDomain);
            if (modelLabelProvider == null) {
                modelLabelProvider = this.createModelLabelProvider(editingDomain);
                this.modelLabelProviders.put(editingDomain, modelLabelProvider);
            }
            return modelLabelProvider;
        }
        if (element instanceof EObject && ((EObject)element).eIsProxy()) {
            return new AdapterFactoryLabelProvider(this.getAdapterFactory(editingDomain));
        }
        return null;
    }

    protected ILabelProvider createModelLabelProvider(final TransactionalEditingDomain editingDomain) {
        Assert.isNotNull((Object)editingDomain);
        AdapterFactory adapterFactory = this.getAdapterFactory(editingDomain);
        return new DecorationAwareTransactionalAdapterFactoryLabelProvider(this, editingDomain, adapterFactory){

            protected <T> T run(RunnableWithResult<? extends T> run) {
                try {
                    return (T)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, run);
                }
                catch (Exception e) {
                    Tracing.catching(TransactionalAdapterFactoryLabelProvider.class, (String)"run", (Throwable)e);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
        };
    }

    protected AdapterFactory getAdapterFactory(TransactionalEditingDomain editingDomain) {
        if (editingDomain != null) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ReferencesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        ToggleReferencesModeAction[] toggleReferencesModeActionArray = this.toggleReferencesModeActions;
        int n = this.toggleReferencesModeActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleReferencesModeAction toggleReferencesModeAction = toggleReferencesModeActionArray[n2];
            manager.add((IAction)toggleReferencesModeAction);
            if (toggleReferencesModeAction != this.toggleReferencesModeActions[this.toggleReferencesModeActions.length - 1]) {
                manager.add((IContributionItem)new Separator());
            }
            ++n2;
        }
    }

    private void fillContextMenu(IMenuManager manager) {
        ToggleReferencesModeAction[] toggleReferencesModeActionArray = this.toggleReferencesModeActions;
        int n = this.toggleReferencesModeActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleReferencesModeAction toggleAction = toggleReferencesModeActionArray[n2];
            manager.add((IAction)toggleAction);
            ++n2;
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        ToggleReferencesModeAction[] toggleReferencesModeActionArray = this.toggleReferencesModeActions;
        int n = this.toggleReferencesModeActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleReferencesModeAction toggleAction = toggleReferencesModeActionArray[n2];
            manager.add((IAction)toggleAction);
            ++n2;
        }
        manager.add((IContributionItem)new Separator());
    }

    private void makeActions() {
        this.toggleReferencesModeActions = new ToggleReferencesModeAction[]{new ToggleReferencesModeAction(this, 0), new ToggleReferencesModeAction(this, 1)};
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = ReferencesView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ReferencesView.this.showMessage("Double-click detected on " + obj.toString());
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ReferencesView.this.doubleClickAction.run();
            }
        });
    }

    private void initDragAndDrop() {
        this.addDropAdapters((StructuredViewer)this.viewer);
        DropTarget dropTarget = new DropTarget((Control)this.pageBook, 23);
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        dropTarget.addDropListener((DropTargetListener)new ReferencesHierarchyTransferDropAdapter(this, (Viewer)this.viewer));
    }

    private void addDropAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        int ops = 23;
        DelegatingDropAdapter delegatingDropAdapter = new DelegatingDropAdapter();
        delegatingDropAdapter.addDropTargetListener((TransferDropTargetListener)new ReferencesHierarchyTransferDropAdapter(this, (Viewer)viewer));
        viewer.addDropSupport(ops, transfers, (DropTargetListener)delegatingDropAdapter);
    }

    private void initMode() {
        int mode;
        try {
            mode = this.dialogSettings.getInt(STORE_MODE);
            if (mode < 0 || mode > 1) {
                mode = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            mode = 0;
        }
        this.currentMode = -1;
        this.setMode(mode);
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Sample View", (String)message);
    }

    public void setFocus() {
        this.pageBook.setFocus();
    }

    public void setMode(int mode) {
        if (this.currentMode != mode) {
            ToggleReferencesModeAction[] toggleReferencesModeActionArray = this.toggleReferencesModeActions;
            int n = this.toggleReferencesModeActions.length;
            int n2 = 0;
            while (n2 < n) {
                ToggleReferencesModeAction toggleReferencesModeAction;
                toggleReferencesModeAction.setChecked(mode == (toggleReferencesModeAction = toggleReferencesModeActionArray[n2]).getMode());
                ++n2;
            }
            this.currentMode = mode;
            this.dialogSettings.put(STORE_MODE, mode);
            this.updateView();
        }
    }

    private void updateView() {
        if (this.viewInput != null && this.viewInput != EMPTY_ROOT) {
            this.showPage(1);
            this.viewer.setInput(this.viewInput);
            this.viewer.refresh();
        } else {
            this.showPage(0);
        }
    }

    private static final class DecoratedComposedImage
    extends ComposedImage {
        private DecoratedComposedImage(Collection<?> images) {
            super(images);
        }

        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            ArrayList<ComposedImage.Point> result = new ArrayList<ComposedImage.Point>();
            result.add(new ComposedImage.Point());
            ComposedImage.Point overlay = new ComposedImage.Point();
            overlay.y = 7;
            result.add(overlay);
            return result;
        }
    }

    protected class DecorationAwareTransactionalAdapterFactoryLabelProvider
    extends TransactionalAdapterFactoryLabelProvider
    implements ILabelDecorator {
        private final ImageDescriptor RECURSIVE;

        public DecorationAwareTransactionalAdapterFactoryLabelProvider(TransactionalEditingDomain domain, AdapterFactory adapterFactory) {
            super(domain, adapterFactory);
            this.RECURSIVE = Activator.getPlugin().getImageDescriptor("full/over16/recursive_ref.gif");
        }

        public Image getImage(Object object) {
            Image image = super.getImage(object);
            return this.decorateImage(image, object);
        }

        public Image decorateImage(Image image, Object element) {
            if (image != null && element instanceof EObject && ReferencesView.this.isRecursive(element)) {
                ArrayList<Image> images = new ArrayList<Image>();
                images.add(image);
                images.add(this.RECURSIVE.createImage());
                DecoratedComposedImage composedImage = new DecoratedComposedImage(images);
                return ExtendedImageRegistry.INSTANCE.getImage((Object)composedImage);
            }
            return image;
        }

        public String decorateText(String text, Object element) {
            return null;
        }
    }
}

