/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sphinx.platform.ui.internal.Activator;
import org.eclipse.sphinx.platform.ui.wizards.pages.AbstractWizardPage;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public abstract class AbstractWizard
extends Wizard
implements IWizard {
    protected AbstractWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public final boolean performFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof AbstractWizardPage) {
                try {
                    ((AbstractWizardPage)page).finish();
                }
                catch (Exception ex) {
                    PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)ex);
                }
            }
            ++n2;
        }
        return this.performExit(this.getFinishRunnable());
    }

    public final boolean performCancel() {
        return this.performExit(this.getCancelRunnable());
    }

    private boolean performExit(IRunnableWithProgress operation) {
        try {
            this.getContainer().run(false, true, operation);
        }
        catch (Exception e) {
            PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)e);
        }
        return true;
    }

    private final IRunnableWithProgress getFinishRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        AbstractWizard.this.doPerformFinish(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    private final IRunnableWithProgress getCancelRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        AbstractWizard.this.doPerformCancel(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    protected abstract void doPerformFinish(IProgressMonitor var1) throws CoreException;

    protected abstract void doPerformCancel(IProgressMonitor var1) throws CoreException;
}

