/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.PrintWriter;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.net.CodePointNameTable;
import org.apache.derby.client.net.NetConnection;

public class NetLogWriter
extends LogWriter {
    static final int TYPE_TRACE_RECEIVE = 2;
    static final int TYPE_TRACE_SEND = 1;
    private static final char[] asciiChar__ = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    private static final String colPosHeader__ = "       0 1 2 3 4 5 6 7   8 9 A B C D E F   0123456789ABCDEF  0123456789ABCDEF";
    private static final char[] ebcdicChar__ = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '<', '(', '+', '|', '&', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '$', '*', ')', ';', '.', '-', '/', '.', '.', '.', '.', '.', '.', '.', '.', '|', ',', '%', '_', '>', '?', '.', '.', '.', '.', '.', '.', '.', '.', '.', '`', ':', '#', '@', '\'', '=', '\"', '.', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '.', '.', '.', '.', '.', '.', '.', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '.', '.', '.', '.', '.', '.', '.', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '.', '.', '.', '.', '.', '.', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '.', '.', '.', '.', '.', '.', '\\', '.', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '.', '.', '.', '.', '.', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', '.', '.', '.', '.', '.'};
    private static final char[] hexDigit__ = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String receiveHeader__ = "       RECEIVE BUFFER:                     (ASCII)           (EBCDIC)";
    private static final String sendHeader__ = "       SEND BUFFER:                        (ASCII)           (EBCDIC)";
    private static final char spaceChar__ = ' ';
    private static final char zeroChar__ = '0';
    private static CodePointNameTable codePointNameTable__ = null;

    public NetLogWriter(PrintWriter printWriter, int n) {
        super(printWriter, n);
        if (codePointNameTable__ == null) {
            this.initCodePointTable();
        }
    }

    private synchronized void initCodePointTable() {
        if (codePointNameTable__ == null) {
            codePointNameTable__ = new CodePointNameTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void traceConnectsExit(ClientConnection clientConnection) {
        NetConnection netConnection = (NetConnection)clientConnection;
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            super.traceConnectsExit(netConnection);
            this.dncnetprint("  PROTOCOL manager levels: { ");
            this.printWriter_.print("SQLAM=" + netConnection.getSQLAM() + ", ");
            this.printWriter_.print("AGENT=" + netConnection.getAGENT() + ", ");
            this.printWriter_.print("CMNTCPIP=" + netConnection.getCMNTCPIP() + ", ");
            this.printWriter_.print("RDB=" + netConnection.getRDB() + ", ");
            this.printWriter_.print("SECMGR=" + netConnection.getSECMGR() + ", ");
            this.printWriter_.print("XAMGR=" + netConnection.getXAMGR() + ", ");
            this.printWriter_.print("SYNCPTMGR=" + netConnection.getSYNCPTMGR() + ", ");
            this.printWriter_.print("RSYNCMGR=" + netConnection.getRSYNCMGR());
            this.printWriter_.println(" }");
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void traceConnectsResetExit(ClientConnection clientConnection) {
        NetConnection netConnection = (NetConnection)clientConnection;
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            super.traceConnectsResetExit(netConnection);
            this.dncnetprint("  PROTOCOL manager levels: { ");
            this.printWriter_.print("SQLAM=" + netConnection.getSQLAM() + ", ");
            this.printWriter_.print("AGENT=" + netConnection.getAGENT() + ", ");
            this.printWriter_.print("CMNTCPIP=" + netConnection.getCMNTCPIP() + ", ");
            this.printWriter_.print("RDB=" + netConnection.getRDB() + ", ");
            this.printWriter_.print("SECMGR=" + netConnection.getSECMGR() + ", ");
            this.printWriter_.print("XAMGR=" + netConnection.getXAMGR() + ", ");
            this.printWriter_.print("SYNCPTMGR=" + netConnection.getSYNCPTMGR() + ", ");
            this.printWriter_.print("RSYNCMGR=" + netConnection.getRSYNCMGR());
            this.printWriter_.println(" }");
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void traceProtocolFlow(byte[] byArray, int n, int n2, int n3, String string, String string2, int n4) {
        if (!this.loggingEnabled(64)) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.tracepoint("[net]", n4, string, string2);
            int n5 = n2;
            boolean bl = true;
            while (n5 >= 2) {
                int n6;
                int n7;
                n2 = ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
                if (n2 < 10 || n2 > n5) {
                    n2 = n5;
                }
                n5 -= n2;
                if (n2 == 0) continue;
                String string3 = null;
                if (n2 >= 10 && (string3 = codePointNameTable__.lookup(n7 = NetLogWriter.getCodePoint(byArray, n + 8))) == null) {
                    n2 += n5;
                    n5 = 0;
                }
                if (!bl) {
                    this.dncnetprintln("");
                }
                if (string3 == null) {
                    this.dncnetprintln(NetLogWriter.getHeader(n3));
                } else {
                    this.printHeaderWithCodePointName(string3, n3);
                }
                if (bl) {
                    this.dncnetprintln(colPosHeader__);
                    bl = false;
                }
                char[] cArray = new char[77];
                int n8 = 7;
                int n9 = 43;
                int n10 = 61;
                cArray[0] = 48;
                cArray[1] = 48;
                cArray[2] = 48;
                cArray[3] = 48;
                int n11 = 16;
                for (n6 = 4; n6 < 77; ++n6) {
                    cArray[n6] = 32;
                }
                n6 = 0;
                do {
                    int n12 = byArray[n] < 0 ? byArray[n] + 256 : byArray[n];
                    ++n;
                    ++n6;
                    int n13 = n8;
                    n8 = (short)(n8 + 1);
                    cArray[n13] = hexDigit__[n12 >>> 4 & 0xF];
                    int n14 = n8;
                    n8 = (short)(n8 + 1);
                    cArray[n14] = hexDigit__[n12 & 0xF];
                    int n15 = n9;
                    n9 = (short)(n9 + 1);
                    cArray[n15] = asciiChar__[n12];
                    int n16 = n10;
                    n10 = (short)(n10 + 1);
                    cArray[n16] = ebcdicChar__[n12];
                    if (n6 % 8 != 0) continue;
                    if (n6 % 16 == 0) {
                        this.dncnetprintln(cArray);
                        if (n6 == n2) continue;
                        if (n2 - n6 < 16) {
                            for (int i = 0; i < cArray.length; ++i) {
                                cArray[i] = 32;
                            }
                        }
                        n8 = 0;
                        n9 = 43;
                        n10 = 61;
                        if (n11 == 0x100000) {
                            n11 = 0;
                        }
                        int n17 = n8;
                        n8 = (short)(n8 + 1);
                        cArray[n17] = hexDigit__[n11 >>> 12 & 0xF];
                        int n18 = n8;
                        n8 = (short)(n8 + 1);
                        cArray[n18] = hexDigit__[n11 >>> 8 & 0xF];
                        int n19 = n8;
                        n8 = (short)(n8 + 1);
                        cArray[n19] = hexDigit__[n11 >>> 4 & 0xF];
                        int n20 = n8;
                        n8 = (short)(n8 + 1);
                        cArray[n20] = hexDigit__[n11 & 0xF];
                        n8 = (short)(n8 + 3);
                        n11 += 16;
                        continue;
                    }
                    n8 = (short)(n8 + 2);
                } while (n6 < n2);
                if (n2 % 16 == 0) continue;
                this.dncnetprintln(cArray);
            }
            this.dncnetprintln("");
        }
    }

    private static int getCodePoint(byte[] byArray, int n) {
        return ((byArray[n++] & 0xFF) << 8) + (byArray[n] & 0xFF);
    }

    private static String getHeader(int n) {
        switch (n) {
            case 1: {
                return sendHeader__;
            }
            case 2: {
                return receiveHeader__;
            }
        }
        return null;
    }

    private static int getStartPosition(int n) {
        switch (n) {
            case 1: {
                return 20;
            }
            case 2: {
                return 23;
            }
        }
        return 0;
    }

    private void printHeaderWithCodePointName(String string, int n) {
        char[] cArray = NetLogWriter.getHeader(n).toCharArray();
        int n2 = string.length() < 17 ? string.length() : 16;
        int n3 = NetLogWriter.getStartPosition(n);
        for (int i = 0; i < n2; ++i) {
            cArray[n3++] = string.charAt(i);
        }
        this.dncnetprintln(cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncnetprint(String string) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.print("[derby] " + string);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncnetprintln(String string) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.println("[derby] " + string);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncnetprintln(char[] cArray) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.print("[derby] ");
            this.printWriter_.println(cArray);
            this.printWriter_.flush();
        }
    }
}

