/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.docmlet.tex.core.model.TexNameAccess;
import org.eclipse.statet.docmlet.tex.core.source.LtxHeuristicTokenScanner;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.CompletionProposalWithOverwrite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class TexLabelCompletionProposal
extends CompletionProposalWithOverwrite
implements ICompletionProposalExtension6 {
    protected final TexNameAccess access;
    protected StyledString displayString;
    private final int relevance;
    private int cursorPosition = -1;
    private ApplyData applyData;

    protected TexLabelCompletionProposal(AssistInvocationContext context, int startOffset, TexNameAccess access, int relevance) {
        super(context, startOffset);
        this.access = access;
        this.relevance = relevance;
    }

    protected String getPluginId() {
        return "org.eclipse.statet.docmlet.tex.ui";
    }

    public int getRelevance() {
        return this.relevance;
    }

    public String getSortingString() {
        return this.access.getSegmentName();
    }

    public String getDisplayString() {
        return this.getStyledDisplayString().getString();
    }

    public Image getImage() {
        return null;
    }

    public StyledString getStyledDisplayString() {
        if (this.displayString == null) {
            StyledString s;
            this.displayString = s = new StyledString(this.access.getDisplayName());
        }
        return this.displayString;
    }

    protected final ApplyData getApplyData() {
        if (this.applyData == null) {
            this.applyData = new ApplyData(this.getInvocationContext());
        }
        return this.applyData;
    }

    protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) throws BadLocationException {
        int end = Math.max(caretOffset, selection.x + selection.y);
        if (overwrite) {
            ApplyData data = this.getApplyData();
            IDocument document = data.getDocument();
            --end;
            while (++end < document.getLength()) {
                char c = document.getChar(end);
                if (c <= ' ' || c == '\\' || c == '{' || c == '}' || c == '%' || Character.isWhitespace(c)) break;
            }
        }
        return end - replacementOffset;
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            int start = this.getReplacementOffset();
            String prefix = document.get(start, offset - start);
            return prefix.regionMatches(true, 0, this.access.getDisplayName(), 0, prefix.length());
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public boolean isAutoInsertable() {
        return true;
    }

    protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
        ApplyData data = this.getApplyData();
        IDocument document = data.getDocument();
        StringBuilder replacement = new StringBuilder(this.access.getDisplayName());
        int cursor = replacement.length();
        document.replace(replacementOffset, replacementLength, replacement.toString());
        this.setCursorPosition(replacementOffset + cursor);
    }

    protected void setCursorPosition(int offset) {
        this.cursorPosition = offset;
    }

    public Point getSelection(IDocument document) {
        if (this.cursorPosition >= 0) {
            return new Point(this.cursorPosition, 0);
        }
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    static final class ApplyData {
        private final AssistInvocationContext context;
        private final SourceViewer viewer;
        private final IDocument document;
        private LtxHeuristicTokenScanner scanner;

        ApplyData(AssistInvocationContext context) {
            this.context = context;
            this.viewer = context.getSourceViewer();
            this.document = this.viewer.getDocument();
        }

        public SourceViewer getViewer() {
            return this.viewer;
        }

        public IDocument getDocument() {
            return this.document;
        }

        public LtxHeuristicTokenScanner getScanner() {
            if (this.scanner == null) {
                this.scanner = LtxHeuristicTokenScanner.create((IDocContentSections)this.context.getEditor().getDocumentContentInfo());
            }
            return this.scanner;
        }
    }
}

