/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.util;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.util.ToolInfoGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class ToolDialog
extends TitleAreaDialog {
    private final String dialogTitle;
    private final Image dialogImage;
    private final ToolProcess tool;
    private final int toolInfoFlags;

    public ToolDialog(ToolProcess tool, Shell parentShell, Image dialogImage, String dialogTitle) {
        this(tool, parentShell, dialogImage, dialogTitle, 0);
    }

    public ToolDialog(ToolProcess tool, Shell parentShell, Image dialogImage, String dialogTitle, int toolInfoFlags) {
        super(parentShell);
        this.dialogImage = dialogImage;
        this.dialogTitle = dialogTitle;
        this.tool = tool;
        this.toolInfoFlags = toolInfoFlags;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.dialogImage != null) {
            shell.setImage(this.dialogImage);
        }
        if (this.dialogTitle != null) {
            shell.setText(this.dialogTitle);
        }
    }

    protected ToolProcess getTool() {
        return this.tool;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getDialogSettings();
    }

    protected IDialogSettings getDialogSettings() {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newDialogGrid((int)1));
        Control content = this.createDialogContent(composite);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addToolInfo(composite);
        return dialogArea;
    }

    protected abstract Control createDialogContent(Composite var1);

    protected void addToolInfo(Composite parent) {
        LayoutUtils.addSmallFiller((Composite)parent, (boolean)false);
        ToolInfoGroup info = new ToolInfoGroup(parent, this.toolInfoFlags, this.tool);
        info.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
    }
}

