/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;

public class RUtil {
    public static final Pattern BACKSLASH_PATTERN = Pattern.compile("\\\\");
    public static final String BACKSLASH_REPLACEMENT = "\\\\\\\\";
    public static final Pattern LINE_SEPARATOR_PATTERN = Pattern.compile("\\r[\\n]?|\\n");

    public static String escapeForDQuote(String s) {
        int idx = 0;
        block6: while (idx < s.length()) {
            char c = s.charAt(idx);
            switch (c) {
                case '\"': 
                case '\\': {
                    break block6;
                }
                default: {
                    ++idx;
                }
            }
        }
        if (idx == s.length()) {
            return s;
        }
        StringBuilder result = new StringBuilder(s.length() + 1);
        result.append(s, 0, idx);
        while (idx < s.length()) {
            char c = s.charAt(idx);
            switch (c) {
                case '\"': 
                case '\\': {
                    result.append('\\');
                    result.append(c);
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++idx;
        }
        return result.toString();
    }

    public static String escapeBackslash(String s) {
        if (s.indexOf(92) < 0) {
            return s;
        }
        StringBuilder result = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i++);
            switch (c) {
                case '\\': {
                    result.append("\\\\");
                    break;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String escapeCompletely(String s) {
        StringBuilder result = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i++);
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    result.append('\\');
                    result.append(c);
                    break;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String unescapeCompletely(String s) {
        StringBuilder result = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                if (i >= s.length()) break;
                char e = s.charAt(i++);
                switch (e) {
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    default: {
                        result.append(e);
                        break;
                    }
                }
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String formatVarName(String name) {
        return String.valueOf('\'') + name + '\'';
    }

    public static String formatVarNames(Collection<String> names) {
        return RUtil.formatVarNames(names, "", ", ");
    }

    public static String formatVarNames(Collection<String> names, String prefix, String separator) {
        int size = names.size();
        if (names.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(size * (10 + prefix.length() + separator.length()));
        Iterator<String> iter = names.iterator();
        if (prefix.isEmpty()) {
            sb.append('\'');
            sb.append(iter.next());
            sb.append('\'');
            while (iter.hasNext()) {
                sb.append(separator);
                sb.append('\'');
                sb.append(iter.next());
                sb.append('\'');
            }
        } else {
            sb.append(prefix);
            sb.append('\'');
            sb.append(iter.next());
            sb.append('\'');
            while (iter.hasNext()) {
                sb.append(separator);
                sb.append(prefix);
                sb.append('\'');
                sb.append(iter.next());
                sb.append('\'');
            }
        }
        return sb.toString();
    }
}

