/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.jface;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.statet.ecommons.databinding.jface.AbstractSWTObservableValue;
import org.eclipse.statet.ecommons.ui.components.IIntValueListener;
import org.eclipse.statet.ecommons.ui.components.IIntValueWidget;
import org.eclipse.statet.ecommons.ui.components.IntValueEvent;
import org.eclipse.swt.widgets.Widget;

public class IntValueObservable
extends AbstractSWTObservableValue
implements IIntValueListener {
    private final IIntValueWidget fWidget;
    private final int fValueIdx;

    public IntValueObservable(IIntValueWidget widget, int idx) {
        this(Realm.getDefault(), widget, idx);
    }

    public IntValueObservable(Realm realm, IIntValueWidget widget, int idx) {
        super(realm, (Widget)widget.getControl());
        this.fWidget = widget;
        this.fValueIdx = idx;
        this.fWidget.addValueListener(this);
    }

    public Object getValueType() {
        return Integer.TYPE;
    }

    protected void doSetValue(Object value) {
        int oldValue;
        int newValue = (Integer)value;
        if (newValue != (oldValue = this.fWidget.getValue(this.fValueIdx))) {
            this.fWidget.setValue(this.fValueIdx, newValue);
            this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)newValue));
        }
    }

    protected Object doGetValue() {
        return this.fWidget.getValue(this.fValueIdx);
    }

    @Override
    public void valueAboutToChange(IntValueEvent event) {
    }

    @Override
    public void valueChanged(IntValueEvent event) {
        this.setValue(event.newValue);
    }
}

