/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.preferences.ui.OverlayStorePreference;

public class OverlayPreferenceStore
implements IPreferenceStore {
    private final IPreferenceStore fParent;
    private final IPreferenceStore fStore;
    private OverlayStorePreference[] fPreferenceKeys;
    private PropertyListener fPropertyListener;
    private boolean fLoaded;

    public OverlayPreferenceStore(IPreferenceStore parent, OverlayStorePreference[] PreferenceKeys) {
        this.fParent = parent;
        this.fPreferenceKeys = PreferenceKeys;
        this.fStore = new PreferenceStore();
    }

    private OverlayStorePreference findPreferenceKey(String key) {
        int i = 0;
        while (i < this.fPreferenceKeys.length) {
            if (this.fPreferenceKeys[i].fKey.equals(key)) {
                return this.fPreferenceKeys[i];
            }
            ++i;
        }
        return null;
    }

    private boolean covers(String key) {
        return this.findPreferenceKey(key) != null;
    }

    private void propagateProperty(IPreferenceStore orgin, OverlayStorePreference key, IPreferenceStore target) {
        if (orgin.isDefault(key.fKey)) {
            if (!target.isDefault(key.fKey)) {
                target.setToDefault(key.fKey);
            }
            return;
        }
        OverlayStorePreference.Type type = key.fType;
        switch (type) {
            case BOOLEAN: {
                boolean originValue = orgin.getBoolean(key.fKey);
                boolean targetValue = target.getBoolean(key.fKey);
                if (targetValue == originValue) break;
                target.setValue(key.fKey, originValue);
                break;
            }
            case DOUBLE: {
                double originValue = orgin.getDouble(key.fKey);
                double targetValue = target.getDouble(key.fKey);
                if (targetValue == originValue) break;
                target.setValue(key.fKey, originValue);
                break;
            }
            case FLOAT: {
                float originValue = orgin.getFloat(key.fKey);
                float targetValue = target.getFloat(key.fKey);
                if (targetValue == originValue) break;
                target.setValue(key.fKey, originValue);
                break;
            }
            case INT: {
                int originValue = orgin.getInt(key.fKey);
                int targetValue = target.getInt(key.fKey);
                if (targetValue == originValue) break;
                target.setValue(key.fKey, originValue);
                break;
            }
            case LONG: {
                long originValue = orgin.getLong(key.fKey);
                long targetValue = target.getLong(key.fKey);
                if (targetValue == originValue) break;
                target.setValue(key.fKey, originValue);
                break;
            }
            case STRING: {
                String originValue = orgin.getString(key.fKey);
                String targetValue = target.getString(key.fKey);
                if (targetValue == null || originValue == null || targetValue.equals(originValue)) break;
                target.setValue(key.fKey, originValue);
            }
        }
    }

    public void propagate() {
        int i = 0;
        while (i < this.fPreferenceKeys.length) {
            this.propagateProperty(this.fStore, this.fPreferenceKeys[i], this.fParent);
            ++i;
        }
    }

    private void loadProperty(IPreferenceStore orgin, OverlayStorePreference key, IPreferenceStore target, boolean forceInitialization) {
        OverlayStorePreference.Type type = key.fType;
        switch (type) {
            case BOOLEAN: {
                if (forceInitialization) {
                    target.setValue(key.fKey, true);
                }
                target.setValue(key.fKey, orgin.getBoolean(key.fKey));
                target.setDefault(key.fKey, orgin.getDefaultBoolean(key.fKey));
                break;
            }
            case DOUBLE: {
                if (forceInitialization) {
                    target.setValue(key.fKey, 1.0);
                }
                target.setValue(key.fKey, orgin.getDouble(key.fKey));
                target.setDefault(key.fKey, orgin.getDefaultDouble(key.fKey));
                break;
            }
            case FLOAT: {
                if (forceInitialization) {
                    target.setValue(key.fKey, 1.0f);
                }
                target.setValue(key.fKey, orgin.getFloat(key.fKey));
                target.setDefault(key.fKey, orgin.getDefaultFloat(key.fKey));
                break;
            }
            case INT: {
                if (forceInitialization) {
                    target.setValue(key.fKey, 1);
                }
                target.setValue(key.fKey, orgin.getInt(key.fKey));
                target.setDefault(key.fKey, orgin.getDefaultInt(key.fKey));
                break;
            }
            case LONG: {
                if (forceInitialization) {
                    target.setValue(key.fKey, 1L);
                }
                target.setValue(key.fKey, orgin.getLong(key.fKey));
                target.setDefault(key.fKey, orgin.getDefaultLong(key.fKey));
                break;
            }
            case STRING: {
                if (forceInitialization) {
                    target.setValue(key.fKey, "1");
                }
                target.setValue(key.fKey, orgin.getString(key.fKey));
                target.setDefault(key.fKey, orgin.getDefaultString(key.fKey));
            }
        }
    }

    public void load() {
        int i = 0;
        while (i < this.fPreferenceKeys.length) {
            this.loadProperty(this.fParent, this.fPreferenceKeys[i], this.fStore, true);
            ++i;
        }
        this.fLoaded = true;
    }

    public void loadDefaults() {
        int i = 0;
        while (i < this.fPreferenceKeys.length) {
            this.setToDefault(this.fPreferenceKeys[i].fKey);
            ++i;
        }
    }

    public void start() {
        if (this.fPropertyListener == null) {
            this.fPropertyListener = new PropertyListener();
            this.fParent.addPropertyChangeListener((IPropertyChangeListener)this.fPropertyListener);
        }
    }

    public void stop() {
        if (this.fPropertyListener != null) {
            this.fParent.removePropertyChangeListener((IPropertyChangeListener)this.fPropertyListener);
            this.fPropertyListener = null;
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fStore.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fStore.removePropertyChangeListener(listener);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.fStore.firePropertyChangeEvent(name, oldValue, newValue);
    }

    public boolean contains(String name) {
        return this.fStore.contains(name);
    }

    public boolean getBoolean(String name) {
        return this.fStore.getBoolean(name);
    }

    public boolean getDefaultBoolean(String name) {
        return this.fStore.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.fStore.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.fStore.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.fStore.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.fStore.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.fStore.getDefaultString(name);
    }

    public double getDouble(String name) {
        return this.fStore.getDouble(name);
    }

    public float getFloat(String name) {
        return this.fStore.getFloat(name);
    }

    public int getInt(String name) {
        return this.fStore.getInt(name);
    }

    public long getLong(String name) {
        return this.fStore.getLong(name);
    }

    public String getString(String name) {
        return this.fStore.getString(name);
    }

    public boolean isDefault(String name) {
        return this.fStore.isDefault(name);
    }

    public boolean needsSaving() {
        return this.fStore.needsSaving();
    }

    public void putValue(String name, String value) {
        if (this.covers(name)) {
            this.fStore.putValue(name, value);
        }
    }

    public void setDefault(String name, double value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    public void setDefault(String name, float value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    public void setDefault(String name, int value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    public void setDefault(String name, long value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    public void setDefault(String name, String value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    public void setDefault(String name, boolean value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    public void setToDefault(String name) {
        this.fStore.setToDefault(name);
    }

    public void setValue(String name, double value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    public void setValue(String name, float value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    public void setValue(String name, int value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    public void setValue(String name, long value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    public void setValue(String name, String value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    public void setValue(String name, boolean value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    public void addKeys(OverlayStorePreference[] keys) {
        assert (!this.fLoaded);
        assert (keys != null);
        int PreferenceKeysLength = this.fPreferenceKeys.length;
        OverlayStorePreference[] result = new OverlayStorePreference[keys.length + PreferenceKeysLength];
        int i = 0;
        int length = PreferenceKeysLength;
        while (i < length) {
            result[i] = this.fPreferenceKeys[i];
            ++i;
        }
        i = 0;
        length = keys.length;
        while (i < length) {
            result[PreferenceKeysLength + i] = keys[i];
            ++i;
        }
        this.fPreferenceKeys = result;
        if (this.fLoaded) {
            this.load();
        }
    }

    private class PropertyListener
    implements IPropertyChangeListener {
        private PropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            OverlayStorePreference key = OverlayPreferenceStore.this.findPreferenceKey(event.getProperty());
            if (key != null) {
                OverlayPreferenceStore.this.propagateProperty(OverlayPreferenceStore.this.fParent, key, OverlayPreferenceStore.this.fStore);
            }
        }
    }
}

