/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.internal.r.core.RProjectNature;
import org.eclipse.statet.internal.r.core.sourcemodel.RModelEventJob;
import org.eclipse.statet.internal.r.core.sourcemodel.RModelIndex;
import org.eclipse.statet.internal.r.core.sourcemodel.RReconciler;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.impl.AbstractModelManager;
import org.eclipse.statet.ltk.model.core.impl.SourceUnitModelContainer;
import org.eclipse.statet.r.core.RProject;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRModelInfo;
import org.eclipse.statet.r.core.model.IRModelManager;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RChunkElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RSuModelContainer;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;

public class RModelManager
extends AbstractModelManager
implements IRModelManager {
    private final RReconciler reconciler = new RReconciler(this);
    private final RModelEventJob eventJob = new RModelEventJob(this);
    private final RModelIndex index = new RModelIndex(this);

    public RModelManager() {
        super("R");
        this.getContextItem(LTK.PERSISTENCE_CONTEXT, true);
        this.getContextItem(LTK.EDITOR_CONTEXT, true);
    }

    public void dispose() {
        this.eventJob.dispose();
        this.index.dispose();
    }

    public RModelEventJob getEventJob() {
        return this.eventJob;
    }

    public RModelIndex getIndex() {
        return this.index;
    }

    protected AbstractModelManager.ContextItem doCreateContextItem(WorkingContext context) {
        return new RContextItem(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDependentUnit(ISourceUnit copy) {
        RContextItem contextItem;
        assert (!copy.getModelTypeId().equals("R") || copy.getElementType() == 531);
        RContextItem rContextItem = contextItem = (RContextItem)this.getContextItem(copy.getWorkingContext(), true);
        synchronized (rContextItem) {
            String key = String.valueOf(copy.getId()) + '+' + copy.getModelTypeId();
            contextItem.worksheets.put(key, copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterDependentUnit(ISourceUnit copy) {
        RContextItem contextItem;
        RContextItem rContextItem = contextItem = (RContextItem)this.getContextItem(copy.getWorkingContext(), true);
        synchronized (rContextItem) {
            contextItem.worksheets.remove(String.valueOf(copy.getId()) + '+' + copy.getModelTypeId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISourceUnit getWorksheetCopy(String type, String id, WorkingContext context) {
        RContextItem contextItem = (RContextItem)this.getContextItem(context, false);
        if (contextItem != null) {
            RContextItem rContextItem = contextItem;
            synchronized (rContextItem) {
                return contextItem.worksheets.get(String.valueOf(id) + '+' + type);
            }
        }
        return null;
    }

    public void reconcile(SourceUnitModelContainer<?, ?> adapter, int level, IProgressMonitor monitor) {
        if (adapter instanceof RSuModelContainer) {
            this.reconciler.reconcile((RSuModelContainer)adapter, level, monitor);
        }
    }

    @Override
    public IRModelInfo reconcile(IRSourceUnit sourceUnit, ISourceUnitModelInfo modelInfo, List<? extends RChunkElement> chunks, List<? extends SourceComponent> inlineNodes, int level, IProgressMonitor monitor) {
        if (sourceUnit == null) {
            throw new NullPointerException("sourceUnit");
        }
        return this.reconciler.reconcile(sourceUnit, modelInfo, chunks, inlineNodes, level, monitor);
    }

    @Override
    public IRFrame getProjectFrame(RProject rProject) throws CoreException {
        return this.index.getProjectFrame(rProject);
    }

    @Override
    public Set<String> getPkgNames() {
        return this.index.getPkgNames();
    }

    @Override
    public IRFrame getPkgProjectFrame(String pkgName) throws CoreException {
        IProject project;
        RProjectNature rProject;
        if (pkgName == null) {
            throw new NullPointerException("pkgName");
        }
        String projectName = this.index.getPkgProject(pkgName);
        if (projectName != null && (rProject = RProjectNature.getRProject(project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName))) != null) {
            return this.getProjectFrame(rProject);
        }
        return null;
    }

    @Override
    public List<ISourceUnit> findReferencingSourceUnits(RProject rProject, RElementName name, IProgressMonitor monitor) throws CoreException {
        return this.index.findReferencingSourceUnits(rProject, name, monitor);
    }

    private static class RContextItem
    extends AbstractModelManager.ContextItem {
        public final HashMap<String, ISourceUnit> worksheets = new HashMap();

        public RContextItem(WorkingContext context) {
            super(context);
        }
    }
}

