/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.impl.AbstractAstNode;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Expression;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;

public abstract class RAstNode
extends AbstractAstNode
implements AstNode {
    static final RAstNode[] NO_CHILDREN = new RAstNode[0];
    RAstNode rParent;
    int startOffset;
    int endOffset;
    int status;

    protected RAstNode() {
        this.status = 0;
    }

    protected RAstNode(int status) {
        this.status = status;
    }

    public abstract NodeType getNodeType();

    public abstract RTerminal getOperator(int var1);

    public final int getStatusCode() {
        return this.status;
    }

    public final RAstNode getRParent() {
        return this.rParent;
    }

    public AstNode getParent() {
        return this.rParent;
    }

    public final RAstNode getRRoot() {
        RAstNode p;
        RAstNode candidate = this;
        while ((p = candidate.rParent) != null) {
            candidate = p;
        }
        return candidate;
    }

    public abstract boolean hasChildren();

    public abstract int getChildCount();

    public abstract RAstNode getChild(int var1);

    public abstract RAstNode[] getChildren();

    public abstract int getChildIndex(AstNode var1);

    public int getStartOffset() {
        return this.startOffset;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    public final int getLength() {
        return this.endOffset - this.startOffset;
    }

    int getEqualsIndex(RAstNode element) {
        RAstNode[] children = this.getChildren();
        int index = 0;
        RAstNode[] rAstNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            RAstNode child = rAstNodeArray[n2];
            if (child == element) {
                return index;
            }
            if (child.equalsSingle(element)) {
                ++index;
            }
            ++n2;
        }
        return -1;
    }

    public abstract void acceptInR(RAstVisitor var1) throws InvocationTargetException;

    public abstract void acceptInRChildren(RAstVisitor var1) throws InvocationTargetException;

    protected final void acceptChildren(RAstVisitor visitor, List<? extends RAstNode> children) throws InvocationTargetException {
        for (RAstNode rAstNode : children) {
            rAstNode.acceptInR(visitor);
        }
    }

    protected final void acceptChildrenExpr(RAstVisitor visitor, List<Expression> children) throws InvocationTargetException {
        for (Expression expr : children) {
            expr.node.acceptInR(visitor);
        }
    }

    abstract Expression getExpr(RAstNode var1);

    abstract Expression getLeftExpr();

    abstract Expression getRightExpr();

    public final boolean equalsIgnoreAst(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RAstNode) || !this.equalsSingle((RAstNode)((Object)obj))) {
            return false;
        }
        RAstNode me = this;
        RAstNode other = (RAstNode)((Object)obj);
        while (me != other) {
            if (me.rParent == null || other.rParent == null) {
                return me.rParent == null && other.rParent == null;
            }
            if (!me.rParent.equalsSingle(other.rParent) || me.rParent.getEqualsIndex(me) != other.rParent.getEqualsIndex(other)) {
                return false;
            }
            me = me.rParent;
            other = other.rParent;
        }
        return true;
    }

    abstract boolean equalsSingle(RAstNode var1);

    public boolean equalsValue(RAstNode element) {
        if (this.getNodeType() != element.getNodeType()) {
            return false;
        }
        int count = this.getChildCount();
        if (count != element.getChildCount()) {
            return false;
        }
        int i = 0;
        while (i < count) {
            if (!this.getChild(i).equalsValue(element.getChild(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void appendPathElement(StringBuilder s) {
        s.append('$');
        s.append(this.getNodeType().ordinal());
    }

    public int hashCodeIgnoreAst() {
        StringBuilder path = new StringBuilder();
        if (this.rParent != null) {
            if (this.rParent.rParent != null) {
                path.append(this.rParent.rParent.getNodeType().ordinal());
            }
            path.append('$');
            path.append(this.rParent.getNodeType().ordinal());
        }
        this.appendPathElement(path);
        return path.toString().hashCode();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getNodeType().label);
        return s.toString();
    }

    abstract int getMissingExprStatus(Expression var1);

    abstract void updateEndOffset();

    static interface Assoc {
        public static final byte TERM = 1;
        public static final byte CONTAINER = 2;
        public static final byte NOSTD = 3;
        public static final byte LEFTSTD = 4;
        public static final byte RIGHTSTD = 5;
    }
}

