/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.ecommons.text.ICharPairMatcher;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;

public class MultiContentSectionCharPairMatcher
implements ICharPairMatcher {
    private static final Object NULL = new Object();
    private final IDocContentSections sections;
    private final Map<String, Object> handlers = new IdentityHashMap<String, Object>(8);
    private ICharPairMatcher activeMatcher;

    public MultiContentSectionCharPairMatcher(IDocContentSections sections) {
        if (sections == null) {
            throw new NullPointerException("sections");
        }
        this.sections = sections;
    }

    public MultiContentSectionCharPairMatcher(IDocContentSections sections, String sectionType1, ICharPairMatcher matcher1) {
        this(sections, sectionType1, matcher1, null, null);
    }

    public MultiContentSectionCharPairMatcher(IDocContentSections sections, String sectionType1, ICharPairMatcher matcher1, String sectionType2, ICharPairMatcher matcher2) {
        this(sections);
        if (sectionType1 != null) {
            this.registerHandler(sectionType1, matcher1);
        }
        if (sectionType2 != null) {
            this.registerHandler(sectionType2, matcher2);
        }
    }

    protected IDocContentSections getSections() {
        return this.sections;
    }

    public void dispose() {
        for (Object handler : this.handlers.values()) {
            if (handler == NULL) continue;
            ((ICharPairMatcher)handler).dispose();
        }
        this.handlers.clear();
    }

    public void registerHandler(String sectionType, ICharPairMatcher matcher) {
        if (sectionType == null) {
            throw new NullPointerException("sectionType");
        }
        this.handlers.put(sectionType, matcher);
    }

    protected final ICharPairMatcher getHandler(String sectionType) {
        if (sectionType == "") {
            return null;
        }
        Object handler = this.handlers.get(sectionType);
        if (handler == null) {
            handler = NULL;
            try {
                ICharPairMatcher newHandler = this.createHandler(sectionType);
                if (newHandler != null) {
                    handler = newHandler;
                }
            }
            finally {
                this.handlers.put(sectionType, handler);
            }
        }
        return handler != NULL ? (ICharPairMatcher)handler : null;
    }

    protected ICharPairMatcher createHandler(String sectionType) {
        return null;
    }

    public void clear() {
        if (this.activeMatcher != null) {
            this.activeMatcher.clear();
            this.activeMatcher = null;
        }
    }

    @Override
    public IRegion match(IDocument document, int offset) {
        ICharPairMatcher previousMatcher = this.activeMatcher;
        this.activeMatcher = this.getHandler(this.sections.getType(document, offset));
        if (previousMatcher != null && previousMatcher != this.activeMatcher) {
            previousMatcher.clear();
        }
        if (this.activeMatcher != null) {
            return this.activeMatcher.match(document, offset);
        }
        return null;
    }

    @Override
    public IRegion match(IDocument document, int offset, boolean auto) {
        ICharPairMatcher previousMatcher = this.activeMatcher;
        this.activeMatcher = this.getHandler(this.sections.getType(document, offset));
        if (previousMatcher != null && previousMatcher != this.activeMatcher) {
            previousMatcher.clear();
        }
        if (this.activeMatcher != null) {
            return this.activeMatcher.match(document, offset, auto);
        }
        return null;
    }

    public int getAnchor() {
        if (this.activeMatcher != null) {
            return this.activeMatcher.getAnchor();
        }
        return -1;
    }
}

