/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.core.util;

import org.eclipse.statet.internal.ltk.core.GitConfigInfo;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class UserInfo {
    private static UserInfo gAuthorInfo;
    private final String name;
    private final String email;
    private final int source;

    static {
        int source = 1;
        String name = UserInfo.checkName(System.getProperty("author.name"));
        String email = UserInfo.checkEmail(System.getProperty("author.email"));
        if (name == null || email == null) {
            source = 2;
            try {
                UserInfo info = GitConfigInfo.load();
                if (name == null) {
                    name = UserInfo.checkName(info.getName());
                }
                if (email == null) {
                    email = UserInfo.checkEmail(info.getEmail());
                }
            }
            catch (Throwable e) {
                name = UserInfo.checkName(System.getenv("GIT_AUTHOR_NAME"));
                email = UserInfo.checkEmail(System.getenv("GIT_AUTHOR_EMAIL"));
            }
        }
        if (name == null || email == null) {
            source = 3;
            if (name == null) {
                name = System.getProperty("user.name", "");
            }
            if (email == null) {
                email = String.valueOf(name.toLowerCase().replace(' ', '.')) + '@';
            }
        }
        gAuthorInfo = new UserInfo(name, email, source);
    }

    private static final @Nullable String checkName(@Nullable String s) {
        if (s != null && (s = s.trim()).length() >= 2) {
            return s;
        }
        return null;
    }

    private static final @Nullable String checkEmail(@Nullable String s) {
        if (s != null && (s = s.trim()).length() >= 2 && s.indexOf(64) > 0) {
            return s;
        }
        return null;
    }

    public static UserInfo getAuthorInfo() {
        return gAuthorInfo;
    }

    public UserInfo(String name, String email, int source) {
        this.name = name;
        this.email = email;
        this.source = source;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public int getSource() {
        return this.source;
    }
}

