/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.string;

import org.eclipse.statet.jcommons.string.CharArrayString;
import org.eclipse.statet.jcommons.string.StringFactory;

public class InternStringCache
implements StringFactory {
    private static final int HASHSET_SIZE = 1024;
    private static final int HASHSET_MASK = 1023;
    private static final int CHARTABLE_SIZE = 127;
    private static final String[] CHARTABLE = new String[127];
    private final String[] values = new String[1024];
    private final int maxCachedLength;

    static {
        char i = '\u0000';
        while (i < '\u007f') {
            InternStringCache.CHARTABLE[i] = String.valueOf(i).intern();
            i = (char)(i + '\u0001');
        }
    }

    public InternStringCache(int maxCachedLength) {
        this.maxCachedLength = maxCachedLength;
    }

    @Override
    public String get(CharArrayString s) {
        switch (s.length()) {
            case 0: {
                return "";
            }
            case 1: {
                return this.getChar(s.charAt(0));
            }
        }
        if (s.length() > this.maxCachedLength) {
            return s.toString();
        }
        return this.getDefault(s);
    }

    @Override
    public String get(CharSequence s) {
        switch (s.length()) {
            case 0: {
                return "";
            }
            case 1: {
                return this.getChar(s.charAt(0));
            }
        }
        if (s.length() > this.maxCachedLength) {
            return s.toString();
        }
        return this.getDefault(s);
    }

    @Override
    public String get(String s, boolean isCompact) {
        switch (s.length()) {
            case 0: {
                return "";
            }
            case 1: {
                return this.getChar(s.charAt(0), s);
            }
        }
        if (s.length() > this.maxCachedLength) {
            return isCompact ? s : new String(s);
        }
        return this.getDefault(s);
    }

    private String getChar(char c) {
        if (c >= '\u0000' && c < '\u007f') {
            return CHARTABLE[c];
        }
        int i1 = c - 127 & 0x3FF;
        String s1 = this.values[i1];
        if (s1 != null && s1.length() == 1 && s1.charAt(0) == c) {
            return s1;
        }
        this.values[i1] = String.valueOf(c).intern();
        return this.values[i1];
    }

    private String getChar(char c, String s) {
        if (c >= '\u0000' && c < '\u007f') {
            return CHARTABLE[c];
        }
        int i1 = c - 127 & 0x3FF;
        String s1 = this.values[i1];
        if (s1 != null && s1.length() == 1 && s1.charAt(0) == c) {
            return s1;
        }
        this.values[i1] = s.intern();
        return this.values[i1];
    }

    private int computeHash(CharSequence s) {
        int hashCode = 0;
        int length = s.length();
        int index = 0;
        while (length-- != 0) {
            hashCode = 31 * hashCode + s.charAt(index++);
        }
        return hashCode;
    }

    private String getDefault(CharArrayString s) {
        int hashCode = s.hashCode();
        int i1 = hashCode & 0x3FF;
        String s1 = this.values[i1];
        if (s1 != null && s.contentEquals(s1)) {
            return s1;
        }
        this.values[i1] = s.toString().intern();
        return this.values[i1];
    }

    private String getDefault(CharSequence s) {
        int hashCode = this.computeHash(s);
        int i1 = hashCode & 0x3FF;
        String s1 = this.values[i1];
        if (s1 != null && s1.hashCode() == hashCode && s1.contentEquals(s)) {
            return s1;
        }
        this.values[i1] = s.toString().intern();
        return this.values[i1];
    }

    private String getDefault(String s) {
        int hashCode = s.hashCode();
        int i1 = hashCode & 0x3FF;
        String s1 = this.values[i1];
        if (s1 != null && s1.hashCode() == hashCode && s1.equals(s)) {
            return s1;
        }
        this.values[i1] = s.intern();
        return this.values[i1];
    }
}

