/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.servi.node;

import java.util.List;
import org.eclipse.statet.internal.rj.servi.LocalNodeFactory;
import org.eclipse.statet.internal.rj.servi.LocalNodeManager;
import org.eclipse.statet.internal.rj.servi.PoolManager;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.rmi.RMIRegistry;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.server.util.RJContext;
import org.eclipse.statet.rj.servi.node.RServiNodeFactory;
import org.eclipse.statet.rj.servi.node.RServiNodeManager;
import org.eclipse.statet.rj.servi.pool.RServiPoolManager;

@NonNullByDefault
public class RServiImpl {
    private static final ImList<String> LIB_IDS = ImCollections.newList((Object[])new String[]{"org.eclipse.statet.rj.servi", "org.eclipse.statet.rj.server", "org.eclipse.statet.rj.data", "org.eclipse.statet.jcommons.util"});

    public static RServiNodeFactory createLocalNodeFactory(String poolId, RJContext context) throws RjInvalidConfigurationException {
        ImList<String> libIds = LIB_IDS;
        context.searchRJLibs(libIds);
        return new LocalNodeFactory(poolId, context, (List<String>)libIds);
    }

    public static RServiPoolManager createPool(String poolId, RMIRegistry registry) {
        return new PoolManager(poolId, registry);
    }

    public static RServiNodeManager createNodeManager(String id, RMIRegistry registry, RServiNodeFactory factory) {
        if (factory instanceof LocalNodeFactory) {
            return new LocalNodeManager(id, registry, (LocalNodeFactory)factory);
        }
        throw new UnsupportedOperationException(factory.getClass().getName());
    }
}

