/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.ui.sourceediting;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.statet.docmlet.tex.core.ITexCoreAccess;
import org.eclipse.statet.docmlet.tex.core.TexCore;
import org.eclipse.statet.docmlet.tex.core.source.ITexDocumentConstants;
import org.eclipse.statet.docmlet.tex.core.source.LtxBracketPairMatcher;
import org.eclipse.statet.docmlet.tex.core.source.LtxDocumentContentInfo;
import org.eclipse.statet.docmlet.tex.core.source.LtxHeuristicTokenScanner;
import org.eclipse.statet.docmlet.tex.ui.sourceediting.LtxQuickAssistProcessor;
import org.eclipse.statet.docmlet.tex.ui.sourceediting.TexEditingSettings;
import org.eclipse.statet.docmlet.tex.ui.text.LtxDefaultTextStyleScanner;
import org.eclipse.statet.docmlet.tex.ui.text.LtxDoubleClickStrategy;
import org.eclipse.statet.docmlet.tex.ui.text.LtxMathTextStyleScanner;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.text.ICharPairMatcher;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;
import org.eclipse.statet.ecommons.text.ui.presentation.SingleTokenScanner;
import org.eclipse.statet.ecommons.text.ui.settings.TextStyleManager;
import org.eclipse.statet.internal.docmlet.tex.ui.TexUIPlugin;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.LtxAutoEditStrategy;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.LtxContentAssistProcessor;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.LtxQuickOutlineInformationProvider;
import org.eclipse.statet.ltk.ui.LTKUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.EcoReconciler2;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceUnitReconcilingStrategy;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;

public class LtxSourceViewerConfiguration
extends SourceEditorViewerConfiguration {
    private static final String[] CONTENT_TYPES = (String[])ITexDocumentConstants.LTX_CONTENT_TYPES.toArray((Object[])new String[ITexDocumentConstants.LTX_CONTENT_TYPES.size()]);
    protected ITextDoubleClickStrategy doubleClickStrategy;
    private LtxAutoEditStrategy autoEditStrategy;
    private ITexCoreAccess coreAccess;

    public LtxSourceViewerConfiguration(int flags) {
        this((IDocContentSections)LtxDocumentContentInfo.INSTANCE, flags, null, null, null, null);
    }

    public LtxSourceViewerConfiguration(IDocContentSections documentContentInfo, int flags, ISourceEditor editor, ITexCoreAccess access, IPreferenceStore preferenceStore, TextStyleManager textStyles) {
        super(documentContentInfo, flags, editor);
        this.setCoreAccess(access);
        this.setup(preferenceStore != null ? preferenceStore : TexUIPlugin.getInstance().getEditorPreferenceStore(), LTKUIPreferences.getEditorDecorationPreferences(), TexEditingSettings.getAssistPreferences());
        this.setTextStyles(textStyles);
    }

    protected void setCoreAccess(ITexCoreAccess access) {
        this.coreAccess = access != null ? access : TexCore.getWorkbenchAccess();
    }

    protected void initTextStyles() {
        this.setTextStyles(TexUIPlugin.getInstance().getLtxTextStyles());
    }

    protected void initScanners() {
        TextStyleManager textStyles = this.getTextStyles();
        this.addScanner("Ltx.Default", new LtxDefaultTextStyleScanner(textStyles));
        this.addScanner("Ltx.Math", new LtxMathTextStyleScanner(textStyles));
        this.addScanner("Ltx.Comment", (ITokenScanner)new SingleTokenScanner(textStyles, "tex_ts_Comment"));
        this.addScanner("Ltx.MathComment", (ITokenScanner)new SingleTokenScanner(textStyles, "tex_ts_Comment"));
        this.addScanner("Ltx.Verbatim", (ITokenScanner)new SingleTokenScanner(textStyles, "tex_ts_Verbatim"));
    }

    public List<ISourceEditorAddon> getAddOns() {
        List addons = super.getAddOns();
        if (this.autoEditStrategy != null) {
            addons.add(this.autoEditStrategy);
        }
        return addons;
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        super.handleSettingsChanged(groupIds, options);
        if (this.autoEditStrategy != null) {
            this.autoEditStrategy.getSettings().handleSettingsChanged(groupIds, options);
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return CONTENT_TYPES;
    }

    public ICharPairMatcher createPairMatcher() {
        return new LtxBracketPairMatcher(LtxHeuristicTokenScanner.create((IDocContentSections)this.getDocumentContentInfo()));
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new LtxDoubleClickStrategy(LtxHeuristicTokenScanner.create((IDocContentSections)this.getDocumentContentInfo()));
        }
        return this.doubleClickStrategy;
    }

    protected IIndentSettings getIndentSettings() {
        return this.coreAccess.getTexCodeStyle();
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"%", ""};
    }

    public boolean isSmartInsertSupported() {
        return true;
    }

    public boolean isSmartInsertByDefault() {
        return (Boolean)PreferenceUtils.getInstancePrefs().getPreferenceValue(TexEditingSettings.SMARTINSERT_BYDEFAULT_ENABLED_PREF);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.getSourceEditor() == null) {
            return super.getAutoEditStrategies(sourceViewer, contentType);
        }
        if (this.autoEditStrategy == null) {
            this.autoEditStrategy = this.createTexAutoEditStrategy();
        }
        return new IAutoEditStrategy[]{this.autoEditStrategy};
    }

    protected LtxAutoEditStrategy createTexAutoEditStrategy() {
        return new LtxAutoEditStrategy(this.coreAccess, this.getSourceEditor());
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        ISourceEditor editor = this.getSourceEditor();
        if (!(editor instanceof SourceEditor1)) {
            return null;
        }
        EcoReconciler2 reconciler = new EcoReconciler2(editor);
        reconciler.setDelay(500);
        reconciler.addReconcilingStrategy((IReconcilingStrategy)new SourceUnitReconcilingStrategy());
        return reconciler;
    }

    public void initContentAssist(ContentAssist assistant) {
        ContentAssistComputerRegistry registry = TexUIPlugin.getInstance().getLtxEditorContentAssistRegistry();
        LtxContentAssistProcessor processor = new LtxContentAssistProcessor(assistant, "Ltx.Default", registry, this.getSourceEditor());
        processor.setCompletionProposalAutoActivationCharacters(new char[]{'\\'});
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "Ltx.Default");
        processor = new LtxContentAssistProcessor(assistant, "Ltx.Math", registry, this.getSourceEditor());
        processor.setCompletionProposalAutoActivationCharacters(new char[]{'\\'});
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "Ltx.Math");
        processor = new LtxContentAssistProcessor(assistant, "Ltx.Comment", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "Ltx.Comment");
        processor = new LtxContentAssistProcessor(assistant, "Ltx.MathComment", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "Ltx.MathComment");
        processor = new LtxContentAssistProcessor(assistant, "Ltx.Verbatim", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "Ltx.Verbatim");
    }

    protected IQuickAssistProcessor createQuickAssistProcessor() {
        ISourceEditor editor = this.getSourceEditor();
        if (editor != null) {
            return new LtxQuickAssistProcessor(editor);
        }
        return null;
    }

    protected void collectHyperlinkDetectorTargets(Map<String, IAdaptable> targets, ISourceViewer sourceViewer) {
        targets.put("org.eclipse.statet.docmlet.editorHyperlinks.TexEditorTarget", (IAdaptable)this.getSourceEditor());
    }

    protected IInformationProvider getQuickInformationProvider(ISourceViewer sourceViewer, int operation) {
        ISourceEditor editor = this.getSourceEditor();
        if (editor == null) {
            return null;
        }
        switch (operation) {
            case 51: {
                return new LtxQuickOutlineInformationProvider(editor, operation);
            }
        }
        return null;
    }
}

