/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.persistence;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.persistence.DisplayPersistenceDialogCommand;
import org.eclipse.statet.ecommons.waltable.persistence.IStateChangedListener;
import org.eclipse.statet.ecommons.waltable.persistence.gui.PersistenceDialog;

public class DisplayPersistenceDialogCommandHandler
extends AbstractLayerCommandHandler<DisplayPersistenceDialogCommand> {
    private Properties properties;
    private final List<IStateChangedListener> stateChangeListeners = new ArrayList<IStateChangedListener>();

    public DisplayPersistenceDialogCommandHandler() {
        this(new Properties(), null);
    }

    public DisplayPersistenceDialogCommandHandler(NatTable natTable) {
        this(new Properties(), natTable);
    }

    public DisplayPersistenceDialogCommandHandler(Properties properties) {
        this(properties, null);
    }

    public DisplayPersistenceDialogCommandHandler(Properties properties, NatTable natTable) {
        if (properties == null) {
            throw new IllegalArgumentException("properties can not be null!");
        }
        this.properties = properties;
        if (natTable != null) {
            natTable.saveState("", this.properties);
            this.properties.setProperty("PersistenceDialog.activeViewConfiguration", "");
        }
    }

    @Override
    protected boolean doCommand(DisplayPersistenceDialogCommand command) {
        PersistenceDialog dialog = new PersistenceDialog(command.getNatTable().getShell(), command.getNatTable(), this.properties);
        dialog.addAllStateChangeListener(this.stateChangeListeners);
        dialog.open();
        return true;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties can not be null!");
        }
        this.properties = properties;
    }

    public void addStateChangeListener(IStateChangedListener listener) {
        this.stateChangeListeners.add(listener);
    }

    public void removeStateChangeListener(IStateChangedListener listener) {
        this.stateChangeListeners.remove(listener);
    }

    @Override
    public Class<DisplayPersistenceDialogCommand> getCommandClass() {
        return DisplayPersistenceDialogCommand.class;
    }
}

