/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.resize;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.ecommons.waltable.command.AbstractDimPositionsCommand;
import org.eclipse.statet.ecommons.waltable.command.LayerCommandUtil;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.coordinate.RowPositionCoordinate;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;

public class MultiRowResizeCommand
extends AbstractDimPositionsCommand {
    private int commonRowHeight = -1;
    protected Map<RowPositionCoordinate, Integer> rowPositionToHeight = new HashMap<RowPositionCoordinate, Integer>();

    public MultiRowResizeCommand(ILayer layer, Collection<LRange> rowPositions, int commonRowHeight) {
        super(layer.getDim(Orientation.VERTICAL), rowPositions);
        this.commonRowHeight = commonRowHeight;
    }

    public MultiRowResizeCommand(ILayer layer, long[] rowPositions, int[] rowHeights) {
        super(layer.getDim(Orientation.VERTICAL), new LRangeList(rowPositions));
        int i = 0;
        while (i < rowPositions.length) {
            this.rowPositionToHeight.put(new RowPositionCoordinate(layer, rowPositions[i]), rowHeights[i]);
            ++i;
        }
    }

    protected MultiRowResizeCommand(MultiRowResizeCommand command) {
        super(command);
        this.commonRowHeight = command.commonRowHeight;
        this.rowPositionToHeight = new HashMap<RowPositionCoordinate, Integer>(command.rowPositionToHeight);
    }

    @Override
    public MultiRowResizeCommand cloneCommand() {
        return new MultiRowResizeCommand(this);
    }

    public long getCommonRowHeight() {
        return this.commonRowHeight;
    }

    public int getRowHeight(long rowPosition) {
        for (RowPositionCoordinate rowPositionCoordinate : this.rowPositionToHeight.keySet()) {
            if (rowPositionCoordinate.getRowPosition() != rowPosition) continue;
            return this.rowPositionToHeight.get(rowPositionCoordinate);
        }
        return this.commonRowHeight;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        if (super.convertToTargetLayer(targetLayer)) {
            HashMap<RowPositionCoordinate, Integer> targetRowPositionToHeight = new HashMap<RowPositionCoordinate, Integer>();
            for (RowPositionCoordinate rowPositionCoordinate : this.rowPositionToHeight.keySet()) {
                RowPositionCoordinate targetRowPositionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(rowPositionCoordinate, targetLayer);
                if (targetRowPositionCoordinate == null) continue;
                targetRowPositionToHeight.put(targetRowPositionCoordinate, this.rowPositionToHeight.get(rowPositionCoordinate));
            }
            this.rowPositionToHeight = targetRowPositionToHeight;
            return true;
        }
        return false;
    }
}

