/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.refactoring.core;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.statet.internal.ltk.refactoring.core.Messages;

public class DynamicValidationChange
extends CompositeChange
implements IResourceChangeListener {
    private static final long LIFE_TIME = 1800000000000L;
    private RefactoringStatus validationState = null;
    private long timeStamp;

    public DynamicValidationChange(Change change) {
        super(change.getName());
        this.add(change);
        this.markAsSynthetic();
    }

    public DynamicValidationChange(String name) {
        super(name);
        this.markAsSynthetic();
    }

    public DynamicValidationChange(String name, Change[] changes) {
        super(name, changes);
        this.markAsSynthetic();
    }

    public void initializeValidationData(IProgressMonitor pm) {
        super.initializeValidationData(pm);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.timeStamp = System.nanoTime();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (this.validationState == null) {
            return super.isValid(pm);
        }
        return this.validationState;
    }

    protected Change createUndoChange(Change[] childUndos) {
        DynamicValidationChange result = new DynamicValidationChange(this.getName());
        int i = 0;
        while (i < childUndos.length) {
            result.add(childUndos[i]);
            ++i;
        }
        return result;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (System.nanoTime() - this.timeStamp < 1800000000000L) {
            return;
        }
        this.validationState = RefactoringStatus.createFatalErrorStatus((String)Messages.DynamicValidationState_WorkspaceChanged_message);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        Change[] children = this.clear();
        int i = 0;
        while (i < children.length) {
            final Change change = children[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    change.dispose();
                }

                public void handleException(Throwable exception) {
                }
            });
            ++i;
        }
    }
}

