/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.util.Iterator;
import java.util.List;
import org.eclipse.statet.internal.r.core.sourcemodel.IRoxygenAnalyzeContext;
import org.eclipse.statet.internal.r.core.sourcemodel.RSourceElementByElementAccess;
import org.eclipse.statet.internal.r.core.sourcemodel.RoxygenTagType;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.r.core.model.IRLangSourceElement;
import org.eclipse.statet.r.core.model.IRModelInfo;
import org.eclipse.statet.r.core.model.RDocuLink;
import org.eclipse.statet.r.core.rsource.ast.DocuComment;
import org.eclipse.statet.r.core.rsource.ast.DocuTag;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;

public class RoxygenAnalyzer
implements IModelElement.Filter {
    private IRoxygenAnalyzeContext context;
    private List<RAstNode> comments;
    private Iterator<RAstNode> commentsIterator;
    private DocuComment nextComment;
    private int nextCommentRefOffset;

    public void updateModel(IRoxygenAnalyzeContext context) {
        this.context = context;
        IRModelInfo model = context.getModelInfo();
        this.comments = ((SourceComponent)model.getAst().getRoot()).getComments();
        if (this.comments == null || this.comments.isEmpty()) {
            return;
        }
        this.commentsIterator = this.comments.iterator();
        if (!this.nextDocuComment()) {
            return;
        }
        IRLangSourceElement sourceElement = model.getSourceElement();
        if (sourceElement instanceof IRLangSourceElement) {
            this.include(sourceElement);
        }
        if (this.nextComment != null) {
            this.checkElement(null);
        }
    }

    private boolean nextDocuComment() {
        while (this.commentsIterator.hasNext()) {
            RAstNode next = this.commentsIterator.next();
            if (next.getNodeType() != NodeType.DOCU_AGGREGATION) continue;
            this.nextComment = (DocuComment)next;
            this.nextCommentRefOffset = this.nextComment.getSubsequentNodeOffset();
            if (this.nextCommentRefOffset != Integer.MIN_VALUE) {
                return true;
            }
            this.checkElement(null);
        }
        this.nextComment = null;
        this.nextCommentRefOffset = Integer.MAX_VALUE;
        return false;
    }

    public boolean include(IModelElement element) {
        IRLangSourceElement rElement = (IRLangSourceElement)element;
        if (this.nextComment == null) {
            return true;
        }
        int offset = rElement.getSourceRange().getStartOffset();
        while (this.nextCommentRefOffset < offset) {
            this.checkElement(null);
            this.nextDocuComment();
        }
        if (this.nextCommentRefOffset == offset && rElement instanceof RSourceElementByElementAccess.DocuCommentableElement) {
            RDocuLink link = new RDocuLink(rElement, this.nextComment);
            this.nextComment.addAttachment(link);
            ((RSourceElementByElementAccess.DocuCommentableElement)rElement).setDocu(this.nextComment);
            this.checkElement(rElement);
            this.nextDocuComment();
        }
        if (this.nextCommentRefOffset < offset + rElement.getSourceRange().getLength()) {
            return rElement.hasSourceChildren(this);
        }
        return false;
    }

    private void checkElement(IRLangSourceElement element) {
        List<DocuTag> tags = this.nextComment.getTags();
        for (DocuTag tag : tags) {
            RoxygenTagType tagType = RoxygenTagType.TYPES.get(tag.getText());
            if (tagType == null) continue;
            tagType.analyze(this.context, tag, element);
        }
    }
}

