/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core;

import java.util.Objects;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.IRCoreAccess;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.renv.IREnvManager;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.http.RHelpHttpService;
import org.eclipse.statet.rj.renv.core.REnv;

@NonNullByDefault
public class RCore {
    public static final String BUNDLE_ID = "org.eclipse.statet.r.core";
    public static final String R_CONTENT_ID = "org.eclipse.statet.r.contentTypes.R";
    public static final IContentType R_CONTENT_TYPE;
    public static final String RD_CONTENT_ID = "org.eclipse.statet.r.contentTypes.Rd";
    public static final IContentType RD_CONTENT_TYPE;
    public static final String RPKG_DESCRIPTION_CONTENT_ID = "org.eclipse.statet.r.contentTypes.RPkgDescription";
    public static final IContentType RPKG_DESCRIPTION_CONTENT_TYPE;
    public static final String RPKG_NAMESPACE_CONTENT_ID = "org.eclipse.statet.r.contentTypes.RPkgNamespace";
    public static final IContentType RPKG_NAMESPACE_CONTENT_TYPE;
    public static final String DEFAULT_WORKBENCH_ENV_ID = "default-workbench";
    public static final String DEFAULT_RHELP_BROWSE_URL = "erhelp:/browse/default-workbench/";
    public static final IRCoreAccess WORKBENCH_ACCESS;

    static {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        R_CONTENT_TYPE = Objects.requireNonNull(contentTypeManager.getContentType(R_CONTENT_ID));
        RD_CONTENT_TYPE = Objects.requireNonNull(contentTypeManager.getContentType(RD_CONTENT_ID));
        RPKG_DESCRIPTION_CONTENT_TYPE = Objects.requireNonNull(contentTypeManager.getContentType(RPKG_DESCRIPTION_CONTENT_ID));
        RPKG_NAMESPACE_CONTENT_TYPE = Objects.requireNonNull(contentTypeManager.getContentType(RPKG_NAMESPACE_CONTENT_ID));
        WORKBENCH_ACCESS = RCorePlugin.getInstance().getWorkspaceRCoreAccess();
    }

    public static IRCoreAccess getWorkbenchAccess() {
        return WORKBENCH_ACCESS;
    }

    public static IRCoreAccess getDefaultsAccess() {
        return RCorePlugin.getInstance().getDefaultsRCoreAccess();
    }

    public static IREnvManager getREnvManager() {
        return RCorePlugin.getInstance().getREnvManager();
    }

    public static @Nullable IRPkgManager getRPkgManager(REnv env) {
        return RCorePlugin.getInstance().getREnvPkgManager().getManager(env);
    }

    public static RHelpManager getRHelpManager() {
        return RCorePlugin.getInstance().getRHelpManager();
    }

    public static RHelpHttpService getRHelpHttpService() {
        return RCorePlugin.getInstance().getRHelpHttpService();
    }
}

