/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.refactoring;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.statet.ecommons.ui.components.CellEditorWizardStatusUpdater;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.r.ui.RIdentifierCellValidator;
import org.eclipse.statet.internal.r.ui.refactoring.Messages;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRFrameInSource;
import org.eclipse.statet.r.core.refactoring.RenameInRegionRefactoring;
import org.eclipse.statet.r.ui.RLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class RenameInRegionWizard
extends RefactoringWizard {
    public RenameInRegionWizard(RenameInRegionRefactoring ref) {
        super((Refactoring)ref, 100);
        this.setDefaultPageTitle(Messages.RenameInRegion_Wizard_title);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new RenameInRegionInputPage());
    }

    private static class RenameInRegionInputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "RenameInRegion.InputPage";
        private static final ViewerFilter[] FILTER_RESOLVED = new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                RenameInRegionRefactoring.Variable variable;
                if (element instanceof RenameInRegionRefactoring.Variable && (variable = (RenameInRegionRefactoring.Variable)element).getParent() instanceof IRFrameInSource) {
                    IRFrameInSource frame = (IRFrameInSource)variable.getParent();
                    return frame.isResolved(variable.getName());
                }
                return true;
            }
        }};
        private static final ViewerFilter[] FILTER_OFF = new ViewerFilter[0];
        private TreeViewer variablesViewer;

        public RenameInRegionInputPage() {
            super(PAGE_NAME);
        }

        protected RenameInRegionRefactoring getRefactoring() {
            return (RenameInRegionRefactoring)super.getRefactoring();
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
            this.setControl((Control)composite);
            composite.setFont(JFaceResources.getDialogFont());
            this.initializeDialogUnits((Control)composite);
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            label.setText(Messages.RenameInRegion_Wizard_header);
            label.setFont(JFaceResources.getBannerFont());
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            Control table = this.createVariablesTable(composite);
            table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            Dialog.applyDialogFont((Control)composite);
            this.variablesViewer.setFilters(FILTER_RESOLVED);
            this.variablesViewer.setInput((Object)this.getRefactoring().getVariables());
        }

        private Control createVariablesTable(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
            Composite above = new Composite(composite, 0);
            above.setLayoutData((Object)new GridData(4, 1024, true, false, 2, 1));
            above.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
            Label label = new Label(above, 0);
            label.setLayoutData((Object)new GridData(4, 1024, true, false));
            label.setText("Enter new variable name(s):");
            label.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 128) {
                        e.doit = false;
                        variablesViewer.getControl().setFocus();
                    }
                }
            });
            final Button showAll = new Button(above, 32);
            showAll.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
            showAll.setText("Show &all identifiers");
            showAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (showAll.getSelection()) {
                        variablesViewer.setFilters(FILTER_OFF);
                    } else {
                        variablesViewer.setFilters(FILTER_RESOLVED);
                    }
                }
            });
            ViewerUtils.TreeComposite table = new ViewerUtils.TreeComposite(composite, 67588);
            table.tree.setHeaderVisible(true);
            table.tree.setLinesVisible(true);
            GridData gd = new GridData(4, 4, true, true, 2, 1);
            gd.heightHint = LayoutUtils.hintHeight((Tree)table.tree, (int)12);
            table.setLayoutData((Object)gd);
            table.viewer.setAutoExpandLevel(2);
            this.variablesViewer = table.viewer;
            TreeViewerColumn column = new TreeViewerColumn(table.viewer, 0);
            column.getColumn().setText("Scope / Variable");
            table.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
            column.setLabelProvider(new CellLabelProvider(){
                private final RLabelProvider fFrameLabelProvider = new RLabelProvider();

                public void update(ViewerCell cell) {
                    cell.setBackground(null);
                    Object element = cell.getElement();
                    if (element instanceof IRFrame) {
                        cell.setFont(null);
                        IRFrame frame = (IRFrame)element;
                        List modelElements = frame.getModelElements();
                        cell.setImage(null);
                        if (modelElements.size() > 0) {
                            this.fFrameLabelProvider.update(cell, (IModelElement)modelElements.get(0));
                            cell.setText(String.valueOf(cell.getText()) + "    ");
                            return;
                        }
                        cell.setText(String.valueOf(frame.getFrameId()) + "    ");
                        cell.setStyleRanges(null);
                        return;
                    }
                    if (element instanceof RenameInRegionRefactoring.Variable) {
                        cell.setFont(null);
                        RenameInRegionRefactoring.Variable variable = (RenameInRegionRefactoring.Variable)element;
                        String name = variable.getName();
                        cell.setImage(null);
                        cell.setText(String.valueOf(name) + "    ");
                        cell.setStyleRanges(null);
                        return;
                    }
                    cell.setImage(null);
                    cell.setText("");
                    cell.setStyleRanges(null);
                }
            });
            column = new TreeViewerColumn(table.viewer, 0);
            column.getColumn().setText("New Name");
            table.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
            column.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    Object element = cell.getElement();
                    if (element instanceof RenameInRegionRefactoring.Variable) {
                        cell.setFont(JFaceResources.getTextFont());
                        RenameInRegionRefactoring.Variable variable = (RenameInRegionRefactoring.Variable)element;
                        String name = variable.getNewName();
                        if (name != null) {
                            cell.setBackground(Display.getCurrent().getSystemColor(7));
                            cell.setText(name);
                            cell.setStyleRanges(null);
                        } else {
                            cell.setBackground(null);
                            cell.setText(variable.getName());
                            cell.setStyleRanges(null);
                        }
                        return;
                    }
                    cell.setBackground(null);
                    cell.setText("");
                    cell.setStyleRanges(null);
                }
            });
            NameEditing editing = new NameEditing((ColumnViewer)table.viewer);
            new CellEditorWizardStatusUpdater((CellEditor)editing.cellEditor, (WizardPage)this);
            column.setEditingSupport((EditingSupport)editing);
            column = new TreeViewerColumn(table.viewer, 0);
            column.getColumn().setText("");
            table.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(this.convertWidthInCharsToPixels(5)));
            column.getColumn().setToolTipText("Occurrences Count");
            column.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    cell.setBackground(null);
                    cell.setFont(null);
                    Object element = cell.getElement();
                    if (element instanceof RenameInRegionRefactoring.Variable) {
                        RenameInRegionRefactoring.Variable variable = (RenameInRegionRefactoring.Variable)element;
                        cell.setText(Integer.toString(variable.getOccurrencesCount()));
                        cell.setStyleRanges(null);
                        return;
                    }
                    cell.setText("");
                    cell.setStyleRanges(null);
                }
            });
            ViewerUtils.installDefaultEditBehaviour((TreeViewer)table.viewer);
            table.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){
                private Map<IRFrame, Map<String, RenameInRegionRefactoring.Variable>> fVariables;

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    this.fVariables = (Map)newInput;
                }

                public Object[] getElements(Object inputElement) {
                    return this.fVariables.keySet().toArray();
                }

                public Object getParent(Object element) {
                    if (element instanceof RenameInRegionRefactoring.Variable) {
                        return ((RenameInRegionRefactoring.Variable)element).getParent();
                    }
                    return null;
                }

                public boolean hasChildren(Object element) {
                    if (element instanceof IRFrame) {
                        return true;
                    }
                    if (element instanceof RenameInRegionRefactoring.Variable) {
                        return !((RenameInRegionRefactoring.Variable)element).getSubVariables().isEmpty();
                    }
                    return false;
                }

                public Object[] getChildren(Object parentElement) {
                    if (parentElement instanceof IRFrame) {
                        return this.fVariables.get(parentElement).values().toArray();
                    }
                    if (parentElement instanceof RenameInRegionRefactoring.Variable) {
                        return ((RenameInRegionRefactoring.Variable)parentElement).getSubVariables().values().toArray();
                    }
                    return null;
                }

                public void dispose() {
                }
            });
            ViewerUtils.addDoubleClickExpansion((TreeViewer)table.viewer);
            return composite;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.variablesViewer.getControl().setFocus();
        }

        private static class NameEditing
        extends EditingSupport {
            private final TextCellEditor cellEditor;

            public NameEditing(ColumnViewer viewer) {
                super(viewer);
                this.cellEditor = new TextCellEditor((Composite)viewer.getControl());
                this.cellEditor.getControl().setFont(JFaceResources.getTextFont());
                this.cellEditor.setValidator((ICellEditorValidator)new RIdentifierCellValidator());
            }

            protected boolean canEdit(Object element) {
                return element instanceof RenameInRegionRefactoring.Variable;
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof RenameInRegionRefactoring.Variable) {
                    return this.cellEditor;
                }
                return null;
            }

            protected Object getValue(Object element) {
                if (element instanceof RenameInRegionRefactoring.Variable) {
                    RenameInRegionRefactoring.Variable variable = (RenameInRegionRefactoring.Variable)element;
                    String name = variable.getNewName();
                    if (name != null) {
                        return name;
                    }
                    return variable.getName();
                }
                return null;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof RenameInRegionRefactoring.Variable) {
                    RenameInRegionRefactoring.Variable variable = (RenameInRegionRefactoring.Variable)element;
                    variable.setNewName((String)value);
                    this.getViewer().update(element, null);
                }
            }
        }
    }
}

