/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.templates.TemplateMessages;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.wizards.Messages;
import org.eclipse.statet.internal.r.ui.wizards.NewRProjectWizardPage;
import org.eclipse.statet.internal.r.ui.wizards.RPkgProjectWizardPage;
import org.eclipse.statet.internal.r.ui.wizards.RPkgTemplateContextType;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.ui.templates.CodeGenerationTemplateContext;
import org.eclipse.statet.ltk.ui.templates.TemplateUtils;
import org.eclipse.statet.ltk.ui.wizards.LTKWizardsMessages;
import org.eclipse.statet.ltk.ui.wizards.NewElementWizard;
import org.eclipse.statet.r.core.RBuildpaths;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RProjects;
import org.eclipse.statet.r.core.RResourceUnit;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;

public class NewRPkgProjectWizard
extends NewElementWizard {
    private NewRProjectWizardPage firstPage;
    private RPkgProjectWizardPage rPkgPage;
    private WizardNewProjectReferencePage referencePage;
    private NewElementWizard.NewProject newRProject;
    private NewElementWizard.NewContainer newRPkgRoot;
    private NewDescriptionFile newDescriptionFile;
    private NewNamespaceFile newNamespaceFile;

    public NewRPkgProjectWizard() {
        this.setDialogSettings(DialogUtils.getDialogSettings((AbstractUIPlugin)RUIPlugin.getInstance(), (String)"NewElementWizard"));
        this.setDefaultPageImageDescriptor(RUI.getImageDescriptor("org.eclipse.statet.r.ui/image/wizban/new.rpkg_project"));
        this.setWindowTitle(Messages.NewRPkgProjectWizard_title);
    }

    public void addPages() {
        super.addPages();
        this.firstPage = new NewRProjectWizardPage(this.getSelection(), Messages.NewRPkgProjectWizardPage_title);
        this.addPage((IWizardPage)this.firstPage);
        this.rPkgPage = new RPkgProjectWizardPage(this.firstPage);
        this.addPage((IWizardPage)this.rPkgPage);
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            this.referencePage = new WizardNewProjectReferencePage("BasicProjectReferencePage");
            this.referencePage.setTitle(LTKWizardsMessages.NewProjectReferencePage_title);
            this.referencePage.setDescription(LTKWizardsMessages.NewProjectReferencePage_description);
            this.addPage((IWizardPage)this.referencePage);
        }
    }

    public boolean performFinish() {
        IProject project = this.firstPage.getProjectHandle();
        String pkgName = this.rPkgPage.getPkgName();
        final IPath pkgRoot = this.rPkgPage.getPkgFolderPath();
        IPath pkgRootFullPath = project.getFullPath().append(pkgRoot);
        this.newRProject = new NewElementWizard.NewProject(this, project, this.firstPage.useDefaults() ? null : this.firstPage.getLocationPath(), this.referencePage != null ? this.referencePage.getReferencedProjects() : null, this.firstPage.getSelectedWorkingSets()){

            protected void doConfigProject(IProject project, IProgressMonitor monitor) throws CoreException {
                RProjects.setupRPkgProject((IProject)this.getResource(), (IPath)pkgRoot, (IProgressMonitor)monitor);
            }
        };
        this.newRPkgRoot = new NewElementWizard.NewContainer(pkgRootFullPath);
        this.newDescriptionFile = new NewDescriptionFile(pkgRootFullPath, pkgName, this.rPkgPage.getPkgAuthor(), this.rPkgPage.getPkgMaintainer());
        this.newNamespaceFile = new NewNamespaceFile(pkgRootFullPath, pkgName);
        boolean result = super.performFinish();
        if (result) {
            this.rPkgPage.saveSettings();
            this.updatePerspective();
            this.selectAndReveal((IResource)this.newDescriptionFile.getResource());
            this.openResource(this.newDescriptionFile);
        }
        return result;
    }

    protected void performOperations(IProgressMonitor monitor) throws InterruptedException, CoreException, InvocationTargetException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create new R package project...", (int)17);
        this.newRProject.createProject((IProgressMonitor)m.newChild(10));
        this.newRPkgRoot.createContainer((IProgressMonitor)m.newChild(2));
        if (!this.newDescriptionFile.getResource().exists()) {
            this.newDescriptionFile.createFile((IProgressMonitor)m.newChild(2));
        }
        if (!this.newNamespaceFile.getResource().exists()) {
            this.newNamespaceFile.createFile((IProgressMonitor)m.newChild(1));
        }
        this.newRPkgRoot.createSubFolder(RBuildpaths.PKG_R_FOLDER_PATH, (IProgressMonitor)m.newChild(1));
        this.newRPkgRoot.createSubFolder(RBuildpaths.PKG_MAN_FOLDER_PATH, (IProgressMonitor)m.newChild(1));
    }

    private static class NewDescriptionFile
    extends NewElementWizard.NewFile {
        private final String pkgName;
        private final String pkgAuthor;
        private final String pkgMaintainer;

        public NewDescriptionFile(IPath containerPath, String pkgName, String pkgAuthor, String pkgMaintainer) {
            super(containerPath, "DESCRIPTION", RCore.RPKG_DESCRIPTION_CONTENT_TYPE);
            this.pkgName = pkgName;
            this.pkgAuthor = pkgAuthor;
            this.pkgMaintainer = pkgMaintainer;
        }

        protected String getInitialFileContent(IFile newFileHandle, SubMonitor m) {
            String lineDelimiter = TextUtil.getLineDelimiter((IProject)newFileHandle.getProject());
            RResourceUnit su = RResourceUnit.createTempUnit((IFile)newFileHandle, (String)"RPkgDescription");
            try {
                TemplateUtils.EvaluatedTemplate data = this.evaluateTemplate((ISourceUnit)su, lineDelimiter);
                if (data != null) {
                    this.initialSelection = data.getRegionToSelect();
                    String string = data.getContent();
                    return string;
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, "An error occured when applying template to new package description file.", (Throwable)e));
            }
            finally {
                if (su != null) {
                    su.disconnect((IProgressMonitor)m);
                }
            }
            return null;
        }

        private TemplateUtils.EvaluatedTemplate evaluateTemplate(ISourceUnit su, String lineDelimiter) throws CoreException {
            TemplateBuffer buffer;
            block4: {
                Template template = RUIPlugin.getInstance().getRPkgCodeGenerationTemplateStore().findTemplate("RPkg_NewDescriptionFile");
                if (template == null) {
                    return null;
                }
                CodeGenerationTemplateContext context = new CodeGenerationTemplateContext((TemplateContextType)new RPkgTemplateContextType("RPkg_NewDescriptionFile"), su, lineDelimiter);
                context.setVariable("r_pkg_name", this.pkgName);
                context.setVariable("r_pkg_author", this.pkgAuthor);
                context.setVariable("r_pkg_maintainer", this.pkgMaintainer);
                try {
                    buffer = context.evaluate(template);
                    if (buffer != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)TemplateMessages.TemplateEvaluation_error_description, (Object)template.getDescription()), (Throwable)e));
                }
            }
            return new TemplateUtils.EvaluatedTemplate(buffer, lineDelimiter);
        }
    }

    private static class NewNamespaceFile
    extends NewElementWizard.NewFile {
        private final String pkgName;

        public NewNamespaceFile(IPath containerPath, String pkgName) {
            super(containerPath, "NAMESPACE", RCore.RPKG_NAMESPACE_CONTENT_TYPE);
            this.pkgName = pkgName;
        }

        protected String getInitialFileContent(IFile newFileHandle, SubMonitor m) {
            String lineDelimiter = TextUtil.getLineDelimiter((IProject)newFileHandle.getProject());
            RResourceUnit su = RResourceUnit.createTempUnit((IFile)newFileHandle, (String)"RPkgDescription");
            try {
                TemplateUtils.EvaluatedTemplate data = this.evaluateTemplate((ISourceUnit)su, lineDelimiter);
                if (data != null) {
                    this.initialSelection = data.getRegionToSelect();
                    String string = data.getContent();
                    return string;
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, "An error occured when applying template to new package description file.", (Throwable)e));
            }
            finally {
                if (su != null) {
                    su.disconnect((IProgressMonitor)m);
                }
            }
            return null;
        }

        private TemplateUtils.EvaluatedTemplate evaluateTemplate(ISourceUnit su, String lineDelimiter) throws CoreException {
            TemplateBuffer buffer;
            block4: {
                Template template = RUIPlugin.getInstance().getRPkgCodeGenerationTemplateStore().findTemplate("RPkg_NewNamespaceFile");
                if (template == null) {
                    return null;
                }
                CodeGenerationTemplateContext context = new CodeGenerationTemplateContext((TemplateContextType)new RPkgTemplateContextType("RPkg_NewNamespaceFile"), su, lineDelimiter);
                context.setVariable("r_pkg_name", this.pkgName);
                try {
                    buffer = context.evaluate(template);
                    if (buffer != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)TemplateMessages.TemplateEvaluation_error_description, (Object)template.getDescription()), (Throwable)e));
                }
            }
            return new TemplateUtils.EvaluatedTemplate(buffer, lineDelimiter);
        }
    }
}

