/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.internal.r.ui.editors.DefaultRFoldingPreferences;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.ltk.ui.sourceediting.folding.AbstractFoldingPosition;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingAnnotation;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingProvider;
import org.eclipse.statet.ltk.ui.sourceediting.folding.NodeFoldingProvider;
import org.eclipse.statet.ltk.ui.sourceediting.folding.SimpleFoldingPosition;
import org.eclipse.statet.r.core.rsource.ast.Block;
import org.eclipse.statet.r.core.rsource.ast.CForLoop;
import org.eclipse.statet.r.core.rsource.ast.CIfElse;
import org.eclipse.statet.r.core.rsource.ast.CRepeatLoop;
import org.eclipse.statet.r.core.rsource.ast.CWhileLoop;
import org.eclipse.statet.r.core.rsource.ast.DocuComment;
import org.eclipse.statet.r.core.rsource.ast.FDef;
import org.eclipse.statet.r.core.rsource.ast.GenericVisitor;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;
import org.eclipse.statet.r.ui.editors.REditorOptions;

public class RDefaultFoldingProvider
implements FoldingProvider,
NodeFoldingProvider {
    public static final String TYPE_RCODE = "org.eclipse.statet.r.folding.RCode";
    public static final String TYPE_ROXYGEN = "org.eclipse.statet.r.folding.Roxygen";
    private FoldingConfiguration fConfig;

    public boolean checkConfig(Set<String> groupIds) {
        if (groupIds == null || groupIds.contains("r.editor/folding/default") || groupIds.contains("r/r.editor/folding.shared")) {
            FoldingConfiguration config = new FoldingConfiguration();
            PreferenceAccess prefs = PreferenceUtils.getInstancePrefs();
            config.enableOtherBlocks = (Boolean)prefs.getPreferenceValue((Preference)DefaultRFoldingPreferences.PREF_OTHERBLOCKS_ENABLED);
            config.minLines = (Integer)prefs.getPreferenceValue((Preference)DefaultRFoldingPreferences.PREF_MINLINES_NUM);
            if (config.minLines < 2) {
                config.minLines = 2;
            }
            config.enableRoxygen = (Boolean)prefs.getPreferenceValue((Preference)DefaultRFoldingPreferences.PREF_ROXYGEN_ENABLED);
            config.minRoxygenLines = (Integer)prefs.getPreferenceValue((Preference)DefaultRFoldingPreferences.PREF_ROXYGEN_MINLINES_NUM);
            if (config.minRoxygenLines < 2) {
                config.minLines = 2;
            }
            config.collapseInitiallyRoxygen = (Boolean)prefs.getPreferenceValue((Preference)DefaultRFoldingPreferences.PREF_ROXYGEN_COLLAPSE_INITIALLY_ENABLED);
            config.isRestoreStateEnabled = (Boolean)prefs.getPreferenceValue((Preference)REditorOptions.FOLDING_RESTORE_STATE_ENABLED_PREF);
            this.fConfig = config;
            return true;
        }
        return false;
    }

    public boolean isRestoreStateEnabled() {
        return this.fConfig.isRestoreStateEnabled;
    }

    public boolean requiresModel() {
        return false;
    }

    public void collectRegions(FoldingEditorAddon.FoldingStructureComputationContext ctx) throws InvocationTargetException {
        if (ctx.ast.getRoot() instanceof RAstNode) {
            ((RAstNode)ctx.ast.getRoot()).acceptInR((RAstVisitor)new ElementFinder(ctx, this.fConfig));
        }
    }

    public AstVisitor createVisitor(FoldingEditorAddon.FoldingStructureComputationContext ctx) {
        return new ElementFinder(ctx, this.fConfig);
    }

    private static class ElementFinder
    extends GenericVisitor
    implements AstVisitor {
        private final FoldingEditorAddon.FoldingStructureComputationContext context;
        private final FoldingConfiguration config;

        public ElementFinder(FoldingEditorAddon.FoldingStructureComputationContext ctx, FoldingConfiguration config) {
            this.context = ctx;
            this.config = config;
        }

        private void createRCodeRegion(int startOffset, int endOffset) throws InvocationTargetException {
            if (startOffset == Integer.MIN_VALUE || endOffset == Integer.MIN_VALUE) {
                return;
            }
            try {
                AbstractDocument doc = this.context.document;
                int startLine = doc.getLineOfOffset(startOffset);
                int stopLine = doc.getLineOfOffset(endOffset);
                IRegion stopLineInfo = doc.getLineInformation(stopLine);
                if (stopLineInfo.getOffset() + stopLineInfo.getLength() > endOffset) {
                    --stopLine;
                }
                if (stopLine - startLine + 1 >= this.config.minLines) {
                    int offset = doc.getLineOffset(startLine);
                    this.context.addFoldingRegion(new FoldingAnnotation(RDefaultFoldingProvider.TYPE_RCODE, false, (AbstractFoldingPosition)new SimpleFoldingPosition(offset, doc.getLineOffset(stopLine) + doc.getLineLength(stopLine) - offset)));
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        private void createRCodeContentRegion(FDef node, int startOffset, int endOffset) throws InvocationTargetException {
            if (startOffset == Integer.MIN_VALUE || endOffset == Integer.MIN_VALUE) {
                return;
            }
            try {
                AbstractDocument doc = this.context.document;
                int startLine = doc.getLineOfOffset(startOffset);
                int stopLine = doc.getLineOfOffset(endOffset);
                IRegion stopLineInfo = doc.getLineInformation(stopLine);
                if (stopLineInfo.getOffset() + stopLineInfo.getLength() > endOffset) {
                    --stopLine;
                }
                if (stopLine - (startLine + 1) >= 0) {
                    int offset = doc.getLineOffset(startLine);
                    this.context.addFoldingRegion(new FoldingAnnotation(RDefaultFoldingProvider.TYPE_RCODE, false, (AbstractFoldingPosition)new SimpleFoldingPosition(offset, doc.getLineOffset(stopLine) + doc.getLineLength(stopLine) - offset)));
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        private void createRoxygenRegion(int startOffset, int endOffset) throws InvocationTargetException {
            if (startOffset == Integer.MIN_VALUE || endOffset == Integer.MIN_VALUE) {
                return;
            }
            try {
                AbstractDocument doc = this.context.document;
                int startLine = doc.getLineOfOffset(startOffset);
                int stopLine = doc.getLineOfOffset(endOffset);
                if (stopLine - startLine + 1 >= this.config.minRoxygenLines) {
                    int offset = doc.getLineOffset(startLine);
                    this.context.addFoldingRegion(new FoldingAnnotation(RDefaultFoldingProvider.TYPE_ROXYGEN, this.context.isInitial && this.config.collapseInitiallyRoxygen, (AbstractFoldingPosition)new SimpleFoldingPosition(offset, doc.getLineOffset(stopLine) + doc.getLineLength(stopLine) - offset)));
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        public void visit(AstNode node) throws InvocationTargetException {
            if (node instanceof RAstNode) {
                ((RAstNode)node).acceptInR((RAstVisitor)this);
            } else {
                int count = node.getChildCount();
                int i = 0;
                while (i < count) {
                    AstNode child = node.getChild(i);
                    if (child instanceof SourceComponent) {
                        this.visit((SourceComponent)child);
                    }
                    ++i;
                }
            }
        }

        public void visit(SourceComponent node) throws InvocationTargetException {
            node.acceptInRChildren((RAstVisitor)this);
            node.acceptInRComments((RAstVisitor)this);
        }

        public void visit(Block node) throws InvocationTargetException {
            if (this.config.enableOtherBlocks) {
                this.createRCodeRegion(node.getStartOffset(), node.getEndOffset());
            }
            node.acceptInRChildren((RAstVisitor)this);
        }

        public void visit(FDef node) throws InvocationTargetException {
            node.getArgsChild().acceptInR((RAstVisitor)this);
            RAstNode body = node.getContChild();
            if (body.getNodeType() == NodeType.BLOCK && node.getArgsCloseOffset() != Integer.MIN_VALUE) {
                this.createRCodeContentRegion(node, node.getArgsCloseOffset(), node.getEndOffset());
                body.acceptInRChildren((RAstVisitor)this);
            } else {
                body.acceptInR((RAstVisitor)this);
            }
        }

        public void visit(CIfElse node) throws InvocationTargetException {
            if (this.config.enableOtherBlocks) {
                node.getCondChild().acceptInR((RAstVisitor)this);
                RAstNode body = node.getThenChild();
                if (body.getNodeType() == NodeType.BLOCK) {
                    this.createRCodeRegion(node.getCondCloseOffset(), body.getEndOffset());
                    body.acceptInRChildren((RAstVisitor)this);
                } else {
                    body.acceptInR((RAstVisitor)this);
                }
                if (node.hasElse()) {
                    body = node.getElseChild();
                    if (body.getNodeType() == NodeType.BLOCK) {
                        this.createRCodeRegion(node.getElseOffset(), body.getEndOffset());
                        body.acceptInRChildren((RAstVisitor)this);
                    } else {
                        body.acceptInR((RAstVisitor)this);
                    }
                }
            } else {
                node.acceptInRChildren((RAstVisitor)this);
            }
        }

        public void visit(CForLoop node) throws InvocationTargetException {
            if (this.config.enableOtherBlocks) {
                node.getCondChild().acceptInR((RAstVisitor)this);
                RAstNode body = node.getContChild();
                if (body.getNodeType() == NodeType.BLOCK) {
                    this.createRCodeRegion(node.getCondCloseOffset(), body.getEndOffset());
                    body.acceptInRChildren((RAstVisitor)this);
                } else {
                    body.acceptInR((RAstVisitor)this);
                }
            } else {
                node.acceptInRChildren((RAstVisitor)this);
            }
        }

        public void visit(CWhileLoop node) throws InvocationTargetException {
            if (this.config.enableOtherBlocks) {
                node.getCondChild().acceptInR((RAstVisitor)this);
                RAstNode body = node.getContChild();
                if (body.getNodeType() == NodeType.BLOCK) {
                    this.createRCodeRegion(node.getCondCloseOffset(), body.getEndOffset());
                    body.acceptInRChildren((RAstVisitor)this);
                } else {
                    body.acceptInR((RAstVisitor)this);
                }
            } else {
                node.acceptInRChildren((RAstVisitor)this);
            }
        }

        public void visit(CRepeatLoop node) throws InvocationTargetException {
            if (this.config.enableOtherBlocks) {
                RAstNode body = node.getContChild();
                if (body.getNodeType() == NodeType.BLOCK) {
                    this.createRCodeRegion(node.getStartOffset(), body.getEndOffset());
                    body.acceptInRChildren((RAstVisitor)this);
                } else {
                    body.acceptInR((RAstVisitor)this);
                }
            } else {
                node.acceptInRChildren((RAstVisitor)this);
            }
        }

        public void visit(DocuComment node) throws InvocationTargetException {
            if (this.config.enableRoxygen) {
                this.createRoxygenRegion(node.getStartOffset(), node.getEndOffset());
            }
        }
    }

    protected static final class FoldingConfiguration {
        public boolean enableOtherBlocks;
        public int minLines;
        public boolean enableRoxygen;
        public int minRoxygenLines;
        public boolean collapseInitiallyRoxygen;
        public boolean isRestoreStateEnabled;

        protected FoldingConfiguration() {
        }
    }
}

