/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.text.r;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.statet.ecommons.text.IPartitionScannerConfigExt;
import org.eclipse.statet.ecommons.text.core.rules.BufferedDocumentScanner;
import org.eclipse.statet.internal.r.ui.RUIPlugin;

public class RFastPartitionScanner
implements IPartitionTokenScanner,
IPartitionScannerConfigExt {
    protected static final int S_DEFAULT = 0;
    protected static final int S_QUOTED_SYMBOL = 1;
    protected static final int S_INFIX_OPERATOR = 2;
    protected static final int S_STRING = 3;
    protected static final int S_COMMENT = 4;
    protected static final int S_ROXYGEN = 5;
    protected static final IToken T_DEFAULT = new Token(null);
    protected static final IToken T_QUOTED_SYMBOL = new Token((Object)"R.QuotedSymbol");
    protected static final IToken T_INFIX = new Token((Object)"R.Op.Infix");
    protected static final IToken T_STRING = new Token((Object)"R.String");
    protected static final IToken T_COMMENT = new Token((Object)"R.Comment");
    protected static final IToken T_ROXYGEN = new Token((Object)"R.Roxygen");
    protected static final int LAST_OTHER = 0;
    protected static final int LAST_BACKSLASH = 1;
    protected static final int LAST_NEWLINE = 2;
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);
    private IDocument fDocument;
    private final boolean fIsRoxygenEnabled;
    private IToken fToken;
    private int fTokenOffset;
    private int fTokenLength;
    private int fStartPartitionState = 0;
    private int fState;
    protected int fLast;
    private int fPrefixLength;
    private char fEndChar;
    private final IToken[] fTokens;

    public RFastPartitionScanner() {
        HashMap<Integer, IToken> list = new HashMap<Integer, IToken>();
        this.initTokens(list);
        int count = this.maxState(list.keySet()) + 1;
        this.fTokens = new IToken[count];
        int i = 0;
        while (i < count) {
            this.fTokens[i] = (IToken)list.get(i);
            ++i;
        }
        this.fIsRoxygenEnabled = true;
    }

    private int maxState(Set<Integer> states) {
        int max = 0;
        for (int state : states) {
            if (state <= max) continue;
            max = state;
        }
        return max;
    }

    protected void initTokens(Map<Integer, IToken> states) {
        states.put(0, T_DEFAULT);
        states.put(1, T_QUOTED_SYMBOL);
        states.put(2, T_INFIX);
        states.put(3, T_STRING);
        states.put(4, T_COMMENT);
        states.put(5, T_ROXYGEN);
    }

    public void setStartPartitionType(String contentType) {
        this.fStartPartitionState = this.getState(contentType);
    }

    public void setRange(IDocument document, int offset, int length) {
        this.setPartialRange(document, offset, length, null, -1);
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        if (partitionOffset < 0) {
            partitionOffset = offset;
        }
        this.fDocument = document;
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = partitionOffset;
        this.fTokenLength = 0;
        this.fPrefixLength = offset - partitionOffset;
        this.fLast = 0;
        if (offset > 0) {
            try {
                char c = document.getChar(offset - 1);
                switch (c) {
                    case '\n': 
                    case '\r': {
                        this.fLast = 2;
                    }
                }
            }
            catch (BadLocationException e) {
                RUIPlugin.logError(100, "Error occured when detect last char.", e);
            }
            this.fState = this.fPrefixLength == 0 ? 0 : this.getState(contentType);
        } else {
            this.fLast = 2;
            this.fState = this.fStartPartitionState;
        }
        if (this.fPrefixLength > 0) {
            switch (this.fState) {
                case 1: {
                    this.fEndChar = (char)96;
                    break;
                }
                case 3: {
                    try {
                        this.fEndChar = document.getChar(this.fTokenOffset);
                        break;
                    }
                    catch (BadLocationException e) {
                        RUIPlugin.logError(100, "Error occured when detecting start char.", e);
                    }
                }
            }
        }
    }

    public IToken nextToken() {
        this.fToken = null;
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fPrefixLength;
        while (this.fToken == null) {
            int c = this.fScanner.read();
            if (c == -1) {
                this.fPrefixLength = 0;
                if (this.fTokenLength > 0) {
                    this.handleEOF(this.fState);
                    this.fToken = this.fTokens[this.fState];
                    break;
                }
                this.fToken = Token.EOF;
                break;
            }
            ++this.fTokenLength;
            this.handleChar(this.fState, c);
        }
        return this.fToken;
    }

    protected void handleChar(int state, int c) {
        switch (state) {
            case 0: {
                this.fLast = 0;
                switch (c) {
                    case 10: 
                    case 13: {
                        this.fLast = 2;
                        return;
                    }
                    case 34: {
                        this.fEndChar = (char)34;
                        this.newState(3, 1);
                        return;
                    }
                    case 39: {
                        this.fEndChar = (char)39;
                        this.newState(3, 1);
                        return;
                    }
                    case 96: {
                        this.fEndChar = (char)96;
                        this.newState(1, 1);
                        return;
                    }
                    case 35: {
                        if (this.fIsRoxygenEnabled && this.readChar('\'')) {
                            this.newState(5, 2);
                            return;
                        }
                        this.newState(4, 1);
                        return;
                    }
                    case 37: {
                        this.newState(2, 1);
                        return;
                    }
                }
                return;
            }
            case 2: {
                if (c == 37) {
                    this.newState(0, 0);
                    return;
                }
                if (c == 13 || c == 10) {
                    this.fLast = 2;
                    this.newState(0, 1);
                    return;
                }
                return;
            }
            case 1: 
            case 3: {
                if (this.fLast == 1) {
                    this.fLast = 0;
                    return;
                }
                if (c == 92) {
                    this.fLast = 1;
                    return;
                }
                if (c == 13 || c == 10) {
                    this.fLast = 2;
                    return;
                }
                this.fLast = 0;
                if (c == this.fEndChar) {
                    this.newState(0, 0);
                    return;
                }
                return;
            }
            case 4: 
            case 5: {
                if (c == 13 || c == 10) {
                    this.fLast = 2;
                    this.newState(0, 1);
                    return;
                }
                return;
            }
        }
        this.handleExtState(state, c);
    }

    protected void handleEOF(int state) {
    }

    protected void handleExtState(int state, int c) {
        if (c == 13 || c == 10) {
            this.fLast = 2;
            return;
        }
    }

    protected final void newState(int newState, int prefixLength) {
        if (this.fTokenLength - prefixLength > 0) {
            this.fToken = this.fTokens[this.fState];
            this.fState = newState;
            this.fTokenLength -= prefixLength;
            this.fPrefixLength = prefixLength;
            return;
        }
        this.fState = newState;
        this.fTokenLength = prefixLength;
        this.fPrefixLength = 0;
    }

    protected final int getState(String contentType) {
        if (contentType == null) {
            return 0;
        }
        if (contentType == "R.Default") {
            return 0;
        }
        if (contentType == "R.String") {
            return 3;
        }
        if (contentType == "R.Comment") {
            return 4;
        }
        if (contentType == "R.Roxygen") {
            return 5;
        }
        if (contentType == "R.Op.Infix") {
            return 2;
        }
        if (contentType == "R.QuotedSymbol") {
            return 1;
        }
        return this.getExtState(contentType);
    }

    protected int getExtState(String contentType) {
        return 0;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    protected final boolean readChar(char c1) {
        int c = this.fScanner.read();
        if (c == c1) {
            ++this.fTokenLength;
            return true;
        }
        if (c >= 0) {
            this.fScanner.unread();
        }
        return false;
    }

    protected final IDocument getDocument() {
        return this.fDocument;
    }
}

