/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.tex.r;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.docmlet.tex.ui.sourceediting.TexEditingSettings;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.redocs.tex.r.ui.editors.LtxRweaveDocumentProvider;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.ltk.ui.LTKUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.templates.WaContributionContextTypeRegistry;
import org.eclipse.statet.ltk.ui.util.CombinedPreferenceStore;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class RedocsTexRPlugin
extends AbstractUIPlugin {
    private static final String NS = "org.eclipse.statet.redocs.tex.r";
    public static final String OBJ_LTXRWEAVE_IMAGE_ID = "org.eclipse.statet.redocs.tex.r/image/obj/LtxRweave";
    public static final String TOOL_NEW_LTXRWEAVE_IMAGE_ID = "org.eclipse.statet.redocs.tex.r/image/tool/New-LtxRweave";
    public static final String WIZBAN_NEW_LTXRWEAVE_FILE_IMAGE_ID = "org.eclipse.statet.redocs.tex.r/image/wizban/New-LtxRweaveFile";
    public static final String TEX_RWEAVE_EDITOR_NODE = "org.eclipse.statet.redocs.tex.r/rweavetex.editor/options";
    private static RedocsTexRPlugin instance;
    private boolean started;
    private List<Disposable> disposables;
    private LtxRweaveDocumentProvider docRDocumentProvider;
    private IPreferenceStore editorPreferenceStore;
    private ContextTypeRegistry codegenTemplateContextTypeRegistry;
    private TemplateStore codegenTemplatesStore;
    private ContextTypeRegistry docTemplateContextTypeRegistry;
    private TemplateStore docTemplatesStore;
    private ContentAssistComputerRegistry ltxRweaveEditorContentAssistRegistry;

    public static RedocsTexRPlugin getInstance() {
        return instance;
    }

    public static void log(IStatus status) {
        RedocsTexRPlugin plugin = RedocsTexRPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    @Deprecated
    public static void logError(int code, String message, Throwable e) {
        RedocsTexRPlugin.log((IStatus)new Status(4, NS, code, message, e));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.disposables = new ArrayList<Disposable>();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            if (this.codegenTemplatesStore != null) {
                this.codegenTemplatesStore.stopListeningForPreferenceChanges();
            }
            RedocsTexRPlugin redocsTexRPlugin = this;
            synchronized (redocsTexRPlugin) {
                this.started = false;
                this.editorPreferenceStore = null;
                this.codegenTemplateContextTypeRegistry = null;
                this.codegenTemplatesStore = null;
                this.docTemplateContextTypeRegistry = null;
                this.docTemplatesStore = null;
                this.ltxRweaveEditorContentAssistRegistry = null;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    RedocsTexRPlugin.log((IStatus)new Status(4, NS, "Error occured while disposing a module.", e));
                }
            }
            this.disposables = null;
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register(OBJ_LTXRWEAVE_IMAGE_ID, "obj_16", "ltx_rweave-file.png");
        util.register(TOOL_NEW_LTXRWEAVE_IMAGE_ID, "tool_16", "new-ltx_rweave-file.png");
        util.register(WIZBAN_NEW_LTXRWEAVE_FILE_IMAGE_ID, "wizban", "new-ltx_rweave-file.png");
    }

    public synchronized LtxRweaveDocumentProvider getDocRDocumentProvider() {
        if (this.docRDocumentProvider == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.docRDocumentProvider = new LtxRweaveDocumentProvider();
            this.disposables.add(this.docRDocumentProvider);
        }
        return this.docRDocumentProvider;
    }

    public synchronized ContextTypeRegistry getCodegenTemplateContextTypeRegistry() {
        if (this.codegenTemplateContextTypeRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.codegenTemplateContextTypeRegistry = new WaContributionContextTypeRegistry("org.eclipse.statet.redocs.templates.TexRweaveCodegen");
        }
        return this.codegenTemplateContextTypeRegistry;
    }

    public synchronized TemplateStore getCodegenTemplateStore() {
        if (this.codegenTemplatesStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.codegenTemplatesStore = new ContributionTemplateStore(this.getCodegenTemplateContextTypeRegistry(), this.getPreferenceStore(), "codegen/CodeTemplates_store");
            try {
                this.codegenTemplatesStore.load();
            }
            catch (IOException e) {
                RedocsTexRPlugin.log((IStatus)new Status(4, NS, 0, "An error occured when loading 'TeX+R code generation' template store.", (Throwable)e));
            }
        }
        return this.codegenTemplatesStore;
    }

    public synchronized ContextTypeRegistry getDocTemplateContextTypeRegistry() {
        if (this.docTemplateContextTypeRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.docTemplateContextTypeRegistry = new WaContributionContextTypeRegistry("org.eclipse.statet.redocs.templates.TexRweaveDoc");
        }
        return this.docTemplateContextTypeRegistry;
    }

    public synchronized TemplateStore getDocTemplateStore() {
        if (this.docTemplatesStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            ScopedPreferenceStore prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.statet.redocs.tex.r/codegen");
            this.docTemplatesStore = new ContributionTemplateStore(this.getDocTemplateContextTypeRegistry(), (IPreferenceStore)prefStore, "DocTemplates_store");
            try {
                this.docTemplatesStore.load();
            }
            catch (IOException e) {
                RedocsTexRPlugin.log((IStatus)new Status(4, NS, 0, "An error occured when loading 'Tex+R document' template store.", (Throwable)e));
            }
            if (!prefStore.contains("DocTemplates_store")) {
                this.migrateDocTemplateStore();
            }
        }
        return this.docTemplatesStore;
    }

    private void migrateDocTemplateStore() {
        ScopedPreferenceStore oldPrefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.statet.r.sweave");
        if (!oldPrefStore.isDefault("org.eclipse.statet.r.sweave.templates.sweavedoc")) {
            try {
                TemplatePersistenceData[] templateDatas;
                TemplateStore oldTemplateStore = new TemplateStore((IPreferenceStore)oldPrefStore, "org.eclipse.statet.r.sweave.templates.sweavedoc");
                oldTemplateStore.load();
                TemplatePersistenceData[] templatePersistenceDataArray = templateDatas = oldTemplateStore.getTemplateData(false);
                int n = templateDatas.length;
                int n2 = 0;
                while (n2 < n) {
                    Template template;
                    TemplatePersistenceData templateData = templatePersistenceDataArray[n2];
                    if (templateData.isEnabled() && (template = templateData.getTemplate()).getContextTypeId().equals("ltx-rweave_NewSweaveDoc") && template.getName().startsWith("ltx-rweave.NewDoc:")) {
                        String templateName = template.getName().substring(18);
                        Template newTemplate = new Template("LtxRweave.NewDoc:" + templateName, template.getDescription(), "Ltx+Rweave_NewDoc", template.getPattern(), false);
                        TemplatePersistenceData defaultData = this.docTemplatesStore.getTemplateData("org.eclipse.statet.redocs.templates.LtxRweave_" + templateName + "Doc");
                        if (defaultData != null) {
                            defaultData.setTemplate(newTemplate);
                        } else {
                            this.docTemplatesStore.add(new TemplatePersistenceData(newTemplate, true));
                        }
                    }
                    ++n2;
                }
                this.docTemplatesStore.save();
            }
            catch (Exception e) {
                RedocsTexRPlugin.log((IStatus)new Status(4, NS, 0, "An error occurred while migrating old 'Tex+R document' template store.", (Throwable)e));
            }
        }
    }

    public synchronized IPreferenceStore getEditorPreferenceStore() {
        if (this.editorPreferenceStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.editorPreferenceStore = CombinedPreferenceStore.createStore((IPreferenceStore[])new IPreferenceStore[]{this.getPreferenceStore(), TexEditingSettings.getPreferenceStore(), RUIPlugin.getInstance().getPreferenceStore(), LTKUIPreferences.getPreferenceStore(), EditorsUI.getPreferenceStore()});
        }
        return this.editorPreferenceStore;
    }

    public synchronized ContentAssistComputerRegistry getLtxRweaveEditorContentAssistRegistry() {
        if (this.ltxRweaveEditorContentAssistRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.ltxRweaveEditorContentAssistRegistry = new ContentAssistComputerRegistry("org.eclipse.statet.redocs.contentTypes.LtxRweave", TEX_RWEAVE_EDITOR_NODE);
            this.disposables.add((Disposable)this.ltxRweaveEditorContentAssistRegistry);
        }
        return this.ltxRweaveEditorContentAssistRegistry;
    }
}

