/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.ui.processing;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperation;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolConfig;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolJob;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolLaunchDelegate;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolProcess;
import org.eclipse.statet.docmlet.base.ui.processing.operations.CloseInDocViewerOperation;
import org.eclipse.statet.docmlet.base.ui.processing.operations.OpenUsingDocViewerOperation;
import org.eclipse.statet.docmlet.base.ui.processing.operations.OpenUsingEclipseOperation;
import org.eclipse.statet.docmlet.base.ui.processing.operations.RunExternalProgramOperation;
import org.eclipse.statet.internal.redocs.wikitext.r.ui.processing.Messages;
import org.eclipse.statet.internal.redocs.wikitext.r.ui.processing.WikitextRweaveConfig;
import org.eclipse.statet.internal.redocs.wikitext.r.ui.processing.YamlFormatDetector;
import org.eclipse.statet.redocs.r.ui.processing.RunRCmdToolOperation;
import org.eclipse.statet.redocs.r.ui.processing.RunRConsoleSnippetOperation;

public class WikitextRweaveLaunchDelegate
extends DocProcessingToolLaunchDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Config config = new Config();
        if (!config.initRun(configuration)) {
            return;
        }
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)"Configuring Document Processing...", (int)(20 + (config.preview.getRun() == 2 ? 30 : 0)));
        try {
            IFile inputFile;
            SubMonitor m1 = m.newChild(10);
            boolean weaveRequired = config.weave.isRun() || config.weave.isEnabled();
            boolean produceRequired = config.produce.isRun() || config.preview.isRun();
            boolean previewRequired = config.produce.isRun() || config.preview.isRun();
            m1.setWorkRemaining(3 + (weaveRequired ? 2 : 0) + (produceRequired ? 2 : 0) + (previewRequired ? 1 : 0));
            config.initSourceFile(configuration, m1.newChild(2));
            config.initWorkingDirectory(configuration, m1.newChild(1));
            if (weaveRequired) {
                inputFile = config.getSourceFile();
                config.weave.initIOFiles(inputFile, configuration, m1.newChild(2));
            }
            if (produceRequired) {
                inputFile = config.weave.isEnabled() ? config.weave.getOutputFile() : config.getSourceFile();
                config.produce.initIOFiles(inputFile, configuration, m1.newChild(2));
            }
            if (previewRequired) {
                inputFile = config.produce.getOutputFile();
                config.preview.initIOFiles(inputFile, configuration, m1.newChild(1));
            }
            if (m.isCanceled()) {
                return;
            }
            m1 = m.newChild(10);
            m1.setWorkRemaining((config.weave.isRun() ? 3 : 0) + (config.produce.isRun() ? 4 : 0) + (config.preview.isRun() ? 2 : 0));
            if (config.weave.isRun()) {
                config.weave.initOperation(configuration, m1.newChild(2));
                config.weave.initPost(configuration, m1.newChild(1));
            }
            if (config.produce.isRun()) {
                config.produce.initPre(configuration, m1.newChild(1));
                config.produce.initOperation(configuration, m1.newChild(2));
                config.produce.initPost(configuration, m1.newChild(1));
            }
            if (config.preview.isRun()) {
                config.preview.initOperation(configuration, m1.newChild(2));
            }
            if (m.isCanceled()) {
                return;
            }
            DocProcessingToolProcess toolProcess = new DocProcessingToolProcess(launch, (DocProcessingToolConfig)config);
            if (config.preview.getRun() == 2) {
                IStatus status = toolProcess.run((IProgressMonitor)m.newChild(30, 0));
                if (status.getSeverity() == 4) {
                    throw new CoreException(status);
                }
            } else {
                new DocProcessingToolJob(toolProcess).schedule();
            }
        }
        finally {
            m.done();
        }
    }

    static class Config
    extends DocProcessingToolConfig {
        public final DocProcessingToolConfig.StepConfig weave = new DocProcessingToolConfig.ProcessingStepConfig((DocProcessingToolConfig)this, "org.eclipse.statet.redocs/weave", Messages.Weave_label);
        public final DocProcessingToolConfig.StepConfig produce = new DocProcessingToolConfig.ProcessingStepConfig(this, "org.eclipse.statet.redocs/produce", Messages.Produce_label){

            public void initPre(ILaunchConfiguration configuration, SubMonitor m) throws CoreException {
                CloseInDocViewerOperation operation = new CloseInDocViewerOperation();
                operation.init((DocProcessingToolConfig.StepConfig)this, Collections.emptyMap(), m);
                this.addPre((DocProcessingOperation)operation);
            }
        };
        public final DocProcessingToolConfig.StepConfig preview = new DocProcessingToolConfig.PreviewStepConfig((DocProcessingToolConfig)this);

        protected Config() {
            this.setSteps(new DocProcessingToolConfig.StepConfig[]{this.weave, this.produce, this.preview});
        }

        protected boolean initRun(ILaunchConfiguration configuration) throws CoreException {
            byte runWeave = 0;
            byte runProduce = 0;
            byte runPreview = 0;
            Set steps = configuration.getAttribute("org.eclipse.statet.docmlet.base/run/BuildSteps.set", Collections.emptySet());
            if (steps.isEmpty()) {
                runWeave = 1;
                runProduce = 1;
                runPreview = 1;
            } else if (steps.contains("processing_steps")) {
                runWeave = 1;
                runProduce = 1;
            } else {
                if (steps.contains("weave")) {
                    runWeave = 2;
                }
                if (steps.contains("produce_output")) {
                    runProduce = 2;
                }
                if (steps.contains("open_output")) {
                    runPreview = 2;
                }
                if (runWeave == 0 && runProduce == 0 && runPreview == 0) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.redocs.wikitext.r", "Unsupported steps configurations: " + steps.toString()));
                }
            }
            this.weave.initRun(runWeave, configuration);
            this.produce.initRun(runProduce, configuration);
            this.preview.initRun(runPreview, configuration);
            return this.weave.isRun() || this.produce.isRun() || this.preview.isRun();
        }

        protected String getOutputExt(DocProcessingToolConfig.StepConfig stepConfig, String formatKey, SubMonitor m) throws CoreException {
            if (formatKey.equals("auto:wikitext")) {
                IFile inputFile = stepConfig.getInputFile();
                String ext = WikitextRweaveConfig.AUTO_WIKITEXT_FORMAT.getExt(inputFile.getFileExtension());
                if (ext == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.redocs.wikitext.r", NLS.bind((String)"Failed to resolve Wikitext filename extension for ''{0}''.", (Object)inputFile.getName())));
                }
                return ext;
            }
            if (formatKey.equals("auto:by-indoc-yaml")) {
                YamlFormatDetector detector = new YamlFormatDetector("WikidocRweave");
                return detector.detect(this.getSourceFile(), m);
            }
            return super.getOutputExt(stepConfig, formatKey, m);
        }

        protected DocProcessingOperation createStepOperation(String id) {
            if (id.equals("org.eclipse.statet.redocs.docProcessing.RunRConsoleSnippetOperation")) {
                return new RunRConsoleSnippetOperation();
            }
            if (id.equals("org.eclipse.statet.redocs.docProcessing.RunRCmdToolOperation")) {
                return new RunRCmdToolOperation();
            }
            if (id.equals("org.eclipse.statet.docmlet.base.docProcessing.RunExternalProgramOperation")) {
                return new RunExternalProgramOperation();
            }
            if (id.equals("org.eclipse.statet.docmlet.base.docProcessing.OpenUsingDocViewerOperation")) {
                return new OpenUsingDocViewerOperation();
            }
            if (id.equals("org.eclipse.statet.docmlet.base.docProcessing.OpenUsingEclipseOperation")) {
                return new OpenUsingEclipseOperation();
            }
            return null;
        }
    }
}

