/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.eclipse.statet.internal.rhelp.core.FIO;
import org.eclipse.statet.internal.rhelp.core.REnvHelpImpl;
import org.eclipse.statet.internal.rhelp.core.RHelpCoreInternals;
import org.eclipse.statet.internal.rhelp.core.RHelpKeywordGroupImpl;
import org.eclipse.statet.internal.rhelp.core.RHelpKeywordImpl;
import org.eclipse.statet.internal.rhelp.core.RHelpPageImpl;
import org.eclipse.statet.internal.rhelp.core.RPkgHelpImpl;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.rhelp.core.DocResource;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpKeyword;
import org.eclipse.statet.rhelp.core.RHelpKeywordGroup;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rj.renv.core.BasicRLibLocation;
import org.eclipse.statet.rj.renv.core.BasicRPkgDescription;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RNumVersion;
import org.eclipse.statet.rj.renv.core.RPkgDescription;

@NonNullByDefault
public class SerUtil {
    private static final int VERSION_11 = 11;
    private static final int VERSION_10 = 10;
    private static final int VERSION = 11;
    public static final String READABLE_SERVER = "11,10";
    private static final int COMPRESS = 16;
    private static final String RHELP_SER_FILE = "rhelp.ser";

    private boolean canRead(int version, REnvHelpConfiguration rEnvConfig) {
        switch (version) {
            case 11: {
                return true;
            }
            case 10: {
                return rEnvConfig.getStateSharedType() == "server";
            }
        }
        return false;
    }

    public static @Nullable Path getIndexDirectoryPath(REnvHelpConfiguration rEnvConfig) {
        try {
            Path stateDirectory = rEnvConfig.getStateSharedDirectoryPath();
            if (stateDirectory != null) {
                return stateDirectory.resolve("index");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Path getIndexDirectoryChecked(REnvHelpConfiguration rEnvConfig) {
        Exception e1 = null;
        try {
            Path stateDirectory = rEnvConfig.getStateSharedDirectoryPath();
            if (stateDirectory != null) {
                Path indexDirectory = stateDirectory.resolve("index");
                if (!Files.isDirectory(indexDirectory, new LinkOption[0])) {
                    Files.createDirectories(indexDirectory, new FileAttribute[0]);
                }
                return indexDirectory;
            }
        }
        catch (Exception e) {
            e1 = e;
        }
        throw new RuntimeException(String.format("Index directory could not be resolved: '%1$s'.", rEnvConfig.getStateSharedDirectory()), e1);
    }

    public static Path getBasicDataFilePath(Path indexDirectory) {
        return indexDirectory.resolve(RHELP_SER_FILE);
    }

    public static @Nullable Path getBasicDataFilePath(REnvHelpConfiguration rEnvConfig) {
        Path directory = SerUtil.getIndexDirectoryPath(rEnvConfig);
        if (directory != null) {
            return SerUtil.getBasicDataFilePath(directory);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save(REnvHelpConfiguration rEnvConfig, REnvHelpImpl help, Controller controller) {
        try {
            Path directory = SerUtil.getIndexDirectoryChecked(rEnvConfig);
            Path newFile = directory.resolve("rhelp.ser.new");
            Files.deleteIfExists(newFile);
            Object object = null;
            Object var7_9 = null;
            try (FIO fio = FIO.get(new BufferedOutputStream(Files.newOutputStream(newFile, StandardOpenOption.CREATE_NEW)));){
                this.save(help, fio, 16);
                fio.flush();
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                    throw object;
                }
                if (object == throwable) throw object;
                ((Throwable)object).addSuppressed(throwable);
                throw object;
            }
            object = controller.getFileLock();
            synchronized (object) {
                if (!controller.shouldSave()) {
                    return false;
                }
                Path serFile = directory.resolve(RHELP_SER_FILE);
                Files.move(newFile, serFile, StandardCopyOption.REPLACE_EXISTING);
                controller.onSaved();
                return true;
            }
        }
        catch (Exception e) {
            RHelpCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("An error occurred when saving R help data for '%1$s'.", rEnvConfig.getName()), (Throwable)e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save(REnvHelpConfiguration rEnvConfig, InputStream in, Controller controller) {
        try {
            Path directory = SerUtil.getIndexDirectoryChecked(rEnvConfig);
            Path newFile = directory.resolve("rhelp.ser.new");
            Files.deleteIfExists(newFile);
            Object object = null;
            Object var7_9 = null;
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(newFile, StandardOpenOption.CREATE_NEW));){
                FIO.copy(in, out);
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                    throw object;
                }
                if (object == throwable) throw object;
                ((Throwable)object).addSuppressed(throwable);
                throw object;
            }
            object = controller.getFileLock();
            synchronized (object) {
                if (!controller.shouldSave()) {
                    return false;
                }
                Path serFile = directory.resolve(RHELP_SER_FILE);
                Files.move(newFile, serFile, StandardCopyOption.REPLACE_EXISTING);
                controller.onSaved();
                return true;
            }
        }
        catch (Exception e) {
            RHelpCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("An error occurred when saving R help data for '%1$s'.", rEnvConfig.getName()), (Throwable)e));
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getStamp(REnvHelpConfiguration rEnvConfig) {
        try {
            Path serFile = SerUtil.getBasicDataFilePath(rEnvConfig);
            if (!Files.isRegularFile(serFile, new LinkOption[0])) {
                return 0L;
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try (FIO fio = FIO.get(new BufferedInputStream(Files.newInputStream(serFile, new OpenOption[0]), 64));){
                int version = fio.readInt();
                if (version == 11) return fio.readLong();
                if (this.canRead(version, rEnvConfig)) return fio.readLong();
                return 0L;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Throwable e) {
            if (e instanceof Error && !(e instanceof UnsupportedVersionException)) {
                throw (Error)e;
            }
            RHelpCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("An error occurred when loading R help data for '%1$s'.", rEnvConfig.getName()), e));
            return 0L;
        }
    }

    public @Nullable REnvHelpImpl load(REnvHelpConfiguration rEnvConfig) {
        Path serFile;
        block13: {
            try {
                serFile = SerUtil.getBasicDataFilePath(rEnvConfig);
                if (Files.isRegularFile(serFile, new LinkOption[0])) break block13;
                return null;
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                RHelpCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("An error occurred when loading R help data for '%1$s'.", rEnvConfig.getName()), e));
                return null;
            }
        }
        Throwable throwable = null;
        Object var4_6 = null;
        try (FIO fio = FIO.get(new BufferedInputStream(Files.newInputStream(serFile, new OpenOption[0])));){
            return this.load(rEnvConfig, fio);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void save(REnvHelpImpl help, FIO fio, int flags) throws IOException {
        fio.writeInt(11);
        fio.writeLong(help.getStamp());
        fio.writeInt(flags);
        if ((flags & 0x10) != 0) {
            fio.enableCompression();
        }
        fio.writeString(help.getDocDir());
        ImList<DocResource> resources = help.getManuals();
        int count = resources.size();
        fio.writeInt(count);
        int i = 0;
        while (i < count) {
            this.saveDocResource((DocResource)resources.get(i), fio);
            ++i;
        }
        resources = help.getMiscResources();
        count = resources.size();
        fio.writeInt(count);
        i = 0;
        while (i < count) {
            this.saveDocResource((DocResource)resources.get(i), fio);
            ++i;
        }
        ImList<RHelpKeywordGroup> keywordGroups = help.getKeywords();
        count = keywordGroups.size();
        fio.writeInt(count);
        i = 0;
        while (i < keywordGroups.size()) {
            this.saveKeywordGroup((RHelpKeywordGroup)keywordGroups.get(i), fio);
            ++i;
        }
        ImList<RPkgHelp> packages = help.getPkgs();
        count = packages.size();
        fio.writeInt(count);
        i = 0;
        while (i < packages.size()) {
            this.savePackage((RPkgHelp)packages.get(i), fio);
            ++i;
        }
    }

    public REnvHelpImpl load(REnvHelpConfiguration rEnvConfig, FIO fio) throws IOException {
        int version = fio.readInt();
        if (version != 11 && !this.canRead(version, rEnvConfig)) {
            throw new UnsupportedVersionException(version);
        }
        long stamp = fio.readLong();
        int flags = fio.readInt();
        if ((flags & 0x10) != 0) {
            fio.enableCompression();
        }
        String docDir = fio.readString();
        int count = fio.readInt();
        Object[] array = new DocResource[count];
        int i = 0;
        while (i < count) {
            array[i] = this.readDocResource(fio);
            ++i;
        }
        ImList manuals = ImCollections.newList((Object[])array);
        int count2 = fio.readInt();
        Object[] array2 = new DocResource[count2];
        int i2 = 0;
        while (i2 < count2) {
            array2[i2] = this.readDocResource(fio);
            ++i2;
        }
        ImList miscRes = ImCollections.newList((Object[])array2);
        int count3 = fio.readInt();
        Object[] array3 = new RHelpKeywordGroup[count3];
        int i3 = 0;
        while (i3 < count3) {
            array3[i3] = this.loadKeywordGroup(fio);
            ++i3;
        }
        ImList keywordGroups = ImCollections.newList((Object[])array3);
        int count4 = fio.readInt();
        Object[] array4 = new RPkgHelp[count4];
        int i4 = 0;
        while (i4 < count4) {
            array4[i4] = this.loadPackage(rEnvConfig, fio);
            ++i4;
        }
        ImList pkgHelps = ImCollections.newList((Object[])array4);
        return new REnvHelpImpl(rEnvConfig.getREnv(), stamp, docDir, (ImList<DocResource>)manuals, (ImList<DocResource>)miscRes, (ImList<RHelpKeywordGroup>)keywordGroups, (ImList<RPkgHelp>)pkgHelps);
    }

    private void saveDocResource(DocResource res, FIO fio) throws IOException {
        fio.writeString(res.getTitle());
        fio.writeString(res.getPath());
        fio.writeString(res.getPdfPath());
    }

    private DocResource readDocResource(FIO fio) throws IOException {
        return new DocResource(fio.readNonNullString(), fio.readNonNullString(), fio.readString());
    }

    private void saveKeywordGroup(RHelpKeywordGroup group, FIO fio) throws IOException {
        fio.writeString(group.getLabel());
        fio.writeString(group.getDescription());
        List<RHelpKeyword> keywords = group.getNestedKeywords();
        int count = keywords.size();
        fio.writeInt(count);
        int i = 0;
        while (i < count) {
            this.saveKeyword(keywords.get(i), fio);
            ++i;
        }
    }

    private RHelpKeywordGroup loadKeywordGroup(FIO fio) throws IOException {
        String label = fio.readString();
        String description = fio.readString();
        int count = fio.readInt();
        Object[] keywords = new RHelpKeyword[count];
        int i = 0;
        while (i < count) {
            keywords[i] = this.loadKeyword(fio);
            ++i;
        }
        return new RHelpKeywordGroupImpl(label, description, (ImList<RHelpKeyword>)ImCollections.newList((Object[])keywords));
    }

    private void saveKeyword(RHelpKeyword keyword, FIO fio) throws IOException {
        fio.writeString(keyword.getKeyword());
        fio.writeString(keyword.getDescription());
        List<RHelpKeyword> nestedKeywords = keyword.getNestedKeywords();
        int count = nestedKeywords.size();
        fio.writeInt(count);
        int i = 0;
        while (i < nestedKeywords.size()) {
            this.saveKeyword(nestedKeywords.get(i), fio);
            ++i;
        }
    }

    private RHelpKeyword loadKeyword(FIO fio) throws IOException {
        String keyword = fio.readString();
        String description = fio.readString();
        int n = fio.readInt();
        Object[] nestedKeywords = new RHelpKeyword[n];
        int i = 0;
        while (i < n) {
            nestedKeywords[i] = this.loadKeyword(fio);
            ++i;
        }
        return new RHelpKeywordImpl(keyword, description, (ImList<RHelpKeyword>)ImCollections.newList((Object[])nestedKeywords));
    }

    private void savePackage(RPkgHelp pkgHelp, FIO fio) throws IOException {
        this.savePkgDescription(pkgHelp.getPkgDescription(), fio);
        ImList<RHelpPage> pages = pkgHelp.getPages();
        int nPages = pages.size();
        fio.writeInt(nPages);
        int i = 0;
        while (i < nPages) {
            this.savePage((RHelpPage)pages.get(i), fio);
            ++i;
        }
    }

    private RPkgHelp loadPackage(REnvHelpConfiguration rEnvConfig, FIO fio) throws IOException {
        RPkgDescription pkgDescription = this.loadPkgDescription(rEnvConfig, fio);
        int nPages = fio.readInt();
        Object[] pages = new RHelpPage[nPages];
        RPkgHelpImpl pkg = new RPkgHelpImpl(pkgDescription, rEnvConfig.getREnv());
        int i = 0;
        while (i < nPages) {
            pages[i] = this.loadPage(pkg, fio);
            ++i;
        }
        pkg.setPages((ImList<RHelpPage>)ImCollections.newList((Object[])pages));
        return pkg;
    }

    private void savePkgDescription(RPkgDescription pkgDescription, FIO fio) throws IOException {
        fio.writeString(pkgDescription.getName());
        fio.writeString(pkgDescription.getVersion().toString());
        fio.writeString(pkgDescription.getTitle());
        fio.writeString(pkgDescription.getDescription());
        fio.writeString(pkgDescription.getAuthor());
        fio.writeString(pkgDescription.getMaintainer());
        fio.writeString(pkgDescription.getUrl());
        fio.writeString(pkgDescription.getBuilt());
        fio.writeString(pkgDescription.getLibLocation().getDirectory());
    }

    private RPkgDescription loadPkgDescription(REnvHelpConfiguration rEnvConfig, FIO fio) throws IOException {
        String name = fio.readNonNullString().intern();
        String version = fio.readNonNullString();
        String title = fio.readNonNullString();
        String description = fio.readNonNullString();
        String author = fio.readString();
        String maintainer = fio.readString();
        String url = fio.readString();
        String built = fio.readNonNullString();
        RLibLocation libLocation = this.getLibLocationSafe(rEnvConfig, fio.readNonNullString());
        return new BasicRPkgDescription(name, RNumVersion.create((String)version), title, description, author, maintainer, url, built, libLocation);
    }

    private RLibLocation getLibLocationSafe(REnvHelpConfiguration rEnvConfig, String directory) {
        RLibLocation libLocation = rEnvConfig.getRLibLocationByDirectory(directory);
        if (libLocation == null) {
            libLocation = new BasicRLibLocation("missing", directory, null);
        }
        return libLocation;
    }

    private void savePage(RHelpPage page, FIO fio) throws IOException {
        fio.writeString(page.getName());
        ImList<String> topics = page.getTopics();
        int nTopics = topics.size();
        fio.writeInt(nTopics);
        int i = 0;
        while (i < nTopics) {
            String topic = (String)topics.get(i);
            fio.writeString(topic == page.getName() ? null : topic);
            ++i;
        }
        fio.writeString(page.getTitle());
    }

    private RHelpPage loadPage(RPkgHelp pkg, FIO fio) throws IOException {
        String name = fio.readNonNullString().intern();
        int nTopics = fio.readInt();
        Object[] array = new String[nTopics];
        int i = 0;
        while (i < array.length) {
            String topic = fio.readString();
            array[i] = topic == null ? name : topic.intern();
            ++i;
        }
        ImList topics = ImCollections.newList((Object[])array);
        String title = fio.readNonNullString();
        return new RHelpPageImpl(pkg, name, (ImList<String>)topics, title);
    }

    public static interface Controller {
        public Object getFileLock();

        public boolean shouldSave();

        public void onSaved();
    }

    private static class UnsupportedVersionException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public UnsupportedVersionException(int inputVersion) {
            super("input= " + inputVersion);
        }
    }
}

