/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.emf.ui.forms;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.statet.ecommons.emf.core.databinding.IEMFEditContext;
import org.eclipse.statet.ecommons.emf.ui.databinding.CustomViewerObservables;
import org.eclipse.statet.ecommons.emf.ui.databinding.DetailContext;
import org.eclipse.statet.ecommons.emf.ui.forms.DetailStack;
import org.eclipse.statet.ecommons.emf.ui.forms.EFProperty;
import org.eclipse.statet.ecommons.emf.ui.forms.EFToolkit;
import org.eclipse.statet.ecommons.emf.ui.forms.IEFFormPage;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DropDownProperty<TProperty>
extends EFProperty {
    private Composite composite;
    private ComboViewer comboViewer;
    private DetailStack detailStack;
    private IObservableValue<TProperty> modelObservable;
    private final List<Object> initialInput = this.createInitialInput();

    public DropDownProperty(String label, String tooltip, EClass eClass, EStructuralFeature eFeature) {
        super(label, tooltip, eClass, eFeature);
    }

    protected List<Object> createInitialInput() {
        return Collections.emptyList();
    }

    @Override
    public void create(Composite parent, IEFFormPage page) {
        ComboViewer viewer;
        EFToolkit toolkit = page.getToolkit();
        toolkit.createPropLabel(parent, this.getLabel(), this.getTooltip());
        this.composite = new Composite(parent, 0);
        toolkit.adapt(this.composite);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)3));
        this.comboViewer = viewer = new ComboViewer(this.composite, 12);
        ILabelProvider labelProvider = this.createLabelProvider(page);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = LayoutUtils.hintWidth((Combo)this.getCombo(), this.initialInput, (ILabelProvider)labelProvider);
        viewer.getControl().setLayoutData((Object)gd);
        this.detailStack = this.createDetails(this.composite, page);
        this.detailStack.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    protected Combo getCombo() {
        return this.comboViewer.getCombo();
    }

    protected ILabelProvider createLabelProvider(IEFFormPage page) {
        return new AdapterFactoryLabelProvider(page.getEditor().getAdapterFactory());
    }

    protected DetailStack createDetails(Composite parent, IEFFormPage page) {
        return new DetailStack(page, this.composite);
    }

    @Override
    public void bind(IEMFEditContext context) {
        super.bind(context);
        IEMFEditValueProperty emfProperty = EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)this.getEFeature());
        this.modelObservable = emfProperty.observeDetail(this.getBaseObservable());
        context.getDataBindingContext().bindValue((IObservableValue)CustomViewerObservables.observeComboSelection((AbstractListViewer)this.comboViewer, this.initialInput), this.modelObservable);
        DetailContext detailContext = new DetailContext(context, this.modelObservable);
        this.detailStack.setContext((IEMFEditContext)detailContext);
    }

    public IObservableValue<TProperty> getPropertyObservable() {
        return this.modelObservable;
    }
}

