/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.dbg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.server.dbg.ElementTracepoints;
import org.eclipse.statet.rj.server.dbg.TracepointInstallationRequest;

@NonNullByDefault
public class ElementTracepointInstallationRequest
extends TracepointInstallationRequest {
    private static final int RESET = 1;
    private final List<? extends ElementTracepoints> requests;
    private int properties;

    public ElementTracepointInstallationRequest(List<? extends ElementTracepoints> checkedList, boolean reset) {
        this.requests = checkedList;
        this.properties = reset ? 1 : 0;
    }

    public ElementTracepointInstallationRequest(RJIO io) throws IOException {
        int l = io.readInt();
        ArrayList<? extends ElementTracepoints> list = new ArrayList<ElementTracepoints>(l);
        int i = 0;
        while (i < l) {
            list.add(new ElementTracepoints(io));
            ++i;
        }
        this.requests = list;
    }

    public void writeExternal(RJIO io) throws IOException {
        int l = this.requests.size();
        io.writeInt(l);
        int i = 0;
        while (i < l) {
            this.requests.get(i).writeExternal(io);
            ++i;
        }
    }

    public boolean getReset() {
        return (this.properties & 1) != 0;
    }

    public List<? extends ElementTracepoints> getRequests() {
        return this.requests;
    }
}

