/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.model;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.docmlet.wikitext.core.IWikitextCoreAccess;
import org.eclipse.statet.docmlet.wikitext.core.MarkupSourceModelStamp;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCore;
import org.eclipse.statet.docmlet.wikitext.core.ast.Embedded;
import org.eclipse.statet.docmlet.wikitext.core.ast.SourceComponent;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikidocParser;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstInfo;
import org.eclipse.statet.docmlet.wikitext.core.markup.IMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.markup.IMarkupLanguageManager1;
import org.eclipse.statet.docmlet.wikitext.core.model.EmbeddingReconcileItem;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikidocModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikidocSuModelContainerEmbeddedExtension;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikitextSourceUnit;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocSuModelContainer;
import org.eclipse.statet.docmlet.wikitext.core.source.MarkupLanguageDocumentSetupParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.IExtdocMarkupLanguage;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.LtxReconcilerExtension;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.SourceAnalyzer;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.WikidocSourceUnitModelInfo;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.WikitextModelManager;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.YamlReconcilerExtension;
import org.eclipse.statet.jcommons.string.InternStringCache;
import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.ltk.ast.core.util.AstPrinter;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.IWorkspaceSourceUnit;

public class WikidocReconciler {
    private static final boolean DEBUG_LOG_AST = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.statet.docmlet.wikitext/debug/Reconciler/logAst"));
    private final Map<IMarkupLanguage, IMarkupLanguage> languages = new HashMap<IMarkupLanguage, IMarkupLanguage>();
    private final WikitextModelManager modelManager;
    protected boolean stop = false;
    private final IMarkupLanguageManager1 markupLanguageManager;
    private final Object f1AstLock = new Object();
    private final WikidocParser f1Parser = new WikidocParser((StringFactory)new InternStringCache(32));
    private AstPrinter f1DebugAstPrinter;
    private final Object f2ModelLock = new Object();
    private final SourceAnalyzer f2SourceAnalyzer = new SourceAnalyzer();
    private final Object f3ReportLock = new Object();
    private IWikidocSuModelContainerEmbeddedExtension yamlExt;
    private IWikidocSuModelContainerEmbeddedExtension ltxExt;

    public WikidocReconciler(WikitextModelManager manager) {
        this.modelManager = manager;
        this.markupLanguageManager = WikitextCore.getMarkupLanguageManager();
        this.f1Parser.setCollectHeadingText(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcile(WikidocSuModelContainer<?> adapter, int flags, IProgressMonitor monitor) {
        IWikitextSourceUnit su = (IWikitextSourceUnit)adapter.getSourceUnit();
        Data data = new Data(adapter, monitor);
        if (data.content == null) {
            return;
        }
        Object object = this.f1AstLock;
        synchronized (object) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            this.updateAst(data, flags, monitor);
        }
        if (this.stop || monitor.isCanceled() || (flags & 0xF) < 2) {
            return;
        }
        object = this.f2ModelLock;
        synchronized (object) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            boolean updated = this.updateModel(data, flags, monitor);
            if (updated) {
                this.modelManager.getEventJob().addUpdate((IModelElement)su, data.oldModel, data.newModel);
            }
        }
        if ((flags & 0x2000000) != 0 && data.newModel != null) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            ProblemRequestor problemRequestor = null;
            Object object2 = this.f3ReportLock;
            synchronized (object2) {
                if (!this.stop && !monitor.isCanceled() && data.newModel == adapter.getCurrentModel() && (problemRequestor = adapter.createProblemRequestor()) != null) {
                    if (data.ast.getMarkupLanguage() instanceof IExtdocMarkupLanguage) {
                        ((IExtdocMarkupLanguage)data.ast.getMarkupLanguage()).getProblemReporter().run(su, data.content, data.newModel, problemRequestor, flags, monitor);
                    }
                    if (data.ast.getEmbeddedTypes().contains("Yaml")) {
                        this.yamlExt.reportEmbeddedProblems(data.content, data.newModel, problemRequestor, flags, monitor);
                    }
                    if (data.embedded != null) {
                        data.embedded.reportEmbeddedProblems(data.content, data.newModel, problemRequestor, flags, monitor);
                    }
                }
                if (problemRequestor != null) {
                    problemRequestor.finish();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IMarkupLanguage getMarkupLanguage(Data data, IProgressMonitor monitor) {
        IWikitextSourceUnit su = (IWikitextSourceUnit)data.adapter.getSourceUnit();
        IMarkupLanguage markupLanguage = null;
        if (su.getWorkingContext() == LTK.EDITOR_CONTEXT) {
            AbstractDocument document = su.getDocument(monitor);
            markupLanguage = MarkupLanguageDocumentSetupParticipant.getMarkupLanguage((IDocument)document, su.getDocumentContentInfo().getPartitioning());
        }
        if (markupLanguage == null && su instanceof IWorkspaceSourceUnit) {
            markupLanguage = this.markupLanguageManager.getLanguage((IFile)su.getResource(), null, true);
        }
        if (markupLanguage == null) {
            return null;
        }
        Map<IMarkupLanguage, IMarkupLanguage> map = this.languages;
        synchronized (map) {
            IMarkupLanguage internal = this.languages.get(markupLanguage);
            if (internal == null) {
                internal = markupLanguage.clone("Reconciler", markupLanguage.getMode());
                this.languages.put(internal, internal);
            }
            return internal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateAst(Data data, int flags, IProgressMonitor monitor) {
        IMarkupLanguage markupLanguage = this.getMarkupLanguage(data, monitor);
        if (markupLanguage == null) {
            throw new UnsupportedOperationException("Markup language is missing.");
        }
        MarkupSourceModelStamp stamp = new MarkupSourceModelStamp(data.content.getStamp(), markupLanguage);
        data.ast = (WikitextAstInfo)data.adapter.getCurrentAst();
        if (data.ast != null && !stamp.equals(data.ast.getStamp())) {
            data.ast = null;
        }
        if (data.ast == null) {
            this.f1Parser.setMarkupLanguage(markupLanguage);
            this.f1Parser.setCollectEmebeddedNodes(true);
            SourceComponent sourceNode = this.f1Parser.parse(data.content);
            List<Embedded> embeddedNodes = this.f1Parser.getEmbeddedNodes();
            IdentityHashMap<String, Boolean> embeddedTypes = new IdentityHashMap<String, Boolean>(4);
            for (Embedded node : embeddedNodes) {
                embeddedTypes.put(node.getForeignTypeId(), Boolean.TRUE);
            }
            if (embeddedTypes.containsKey("Yaml")) {
                if (this.yamlExt == null) {
                    this.yamlExt = new YamlReconcilerExtension();
                }
                this.yamlExt.reconcileEmbeddedAst(data.content, embeddedNodes, markupLanguage, flags, monitor);
            }
            if (embeddedTypes.containsKey("Ltx")) {
                if (this.ltxExt == null) {
                    this.ltxExt = new LtxReconcilerExtension();
                }
                this.ltxExt.reconcileEmbeddedAst(data.content, embeddedNodes, markupLanguage, flags, monitor);
            }
            if (data.embedded != null) {
                data.embedded.reconcileEmbeddedAst(data.content, embeddedNodes, markupLanguage, flags, monitor);
            }
            data.ast = new WikitextAstInfo(1, stamp, sourceNode, markupLanguage, embeddedTypes.keySet());
            if (DEBUG_LOG_AST) {
                if (this.f1DebugAstPrinter == null) {
                    this.f1DebugAstPrinter = new AstPrinter((Writer)new StringWriter());
                }
                StringWriter out = (StringWriter)this.f1DebugAstPrinter.getWriter();
                out.getBuffer().setLength(0);
                try {
                    out.append("====\nWikidoc AST:\n");
                    this.f1DebugAstPrinter.print(data.ast.getRoot(), data.content.getText());
                    out.append("====\n");
                    System.out.println(out.toString());
                }
                catch (Exception e) {
                    System.out.println(out.toString());
                    e.printStackTrace();
                }
            }
            WikidocSuModelContainer<?> wikidocSuModelContainer = data.adapter;
            synchronized (wikidocSuModelContainer) {
                data.adapter.setAst(data.ast);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean updateModel(Data data, int flags, IProgressMonitor monitor) {
        data.newModel = (IWikidocModelInfo)data.adapter.getCurrentModel();
        if (data.newModel != null && !data.ast.getStamp().equals(data.newModel.getStamp())) {
            data.newModel = null;
        }
        if (data.newModel == null) {
            WikidocSourceUnitModelInfo model = this.f2SourceAnalyzer.createModel((IWikitextSourceUnit)data.adapter.getSourceUnit(), data.content.getText(), data.ast);
            boolean isOK = model != null;
            List<EmbeddingReconcileItem> embeddedItems = this.f2SourceAnalyzer.getEmbeddedItems();
            if (data.ast.getEmbeddedTypes().contains("Yaml")) {
                this.yamlExt.reconcileEmbeddedModel(data.content, model, embeddedItems, flags, monitor);
            }
            if (data.ast.getEmbeddedTypes().contains("Ltx")) {
                this.ltxExt.reconcileEmbeddedModel(data.content, model, embeddedItems, flags, monitor);
            }
            if (data.embedded != null) {
                data.embedded.reconcileEmbeddedModel(data.content, model, embeddedItems, flags, monitor);
            }
            if (isOK) {
                WikidocSuModelContainer<?> wikidocSuModelContainer = data.adapter;
                synchronized (wikidocSuModelContainer) {
                    data.oldModel = (IWikidocModelInfo)data.adapter.getCurrentModel();
                    data.adapter.setModel(model);
                }
                data.newModel = model;
                return true;
            }
        }
        return false;
    }

    void stop() {
        this.stop = true;
    }

    protected static class Data {
        public final WikidocSuModelContainer<?> adapter;
        public final IWikidocSuModelContainerEmbeddedExtension embedded;
        public final SourceContent content;
        private final IWikitextCoreAccess coreAccess;
        public int parseOffset;
        public WikitextAstInfo ast;
        public IWikidocModelInfo oldModel;
        public IWikidocModelInfo newModel;

        public Data(WikidocSuModelContainer<?> adapter, IProgressMonitor monitor) {
            this.adapter = adapter;
            this.embedded = adapter instanceof IWikidocSuModelContainerEmbeddedExtension ? (IWikidocSuModelContainerEmbeddedExtension)((Object)adapter) : null;
            this.content = adapter.getParseContent(monitor);
            this.coreAccess = ((IWikitextSourceUnit)adapter.getSourceUnit()).getWikitextCoreAccess();
        }
    }
}

