/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.coordinate;

import java.util.ArrayList;
import java.util.List;

public final class LRange
implements Comparable<LRange> {
    public long start;
    public long end;

    public LRange(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public LRange(long value) {
        this.start = value;
        this.end = value + 1L;
    }

    public long size() {
        return this.end - this.start;
    }

    @Override
    public int compareTo(LRange o) {
        if (this.start < o.start) {
            return -1;
        }
        if (this.start > o.start) {
            return 1;
        }
        if (this.end < o.end) {
            return -1;
        }
        if (this.end > o.end) {
            return 1;
        }
        return 0;
    }

    public boolean contains(long position) {
        return position >= this.start && position < this.end;
    }

    public boolean overlap(LRange lRange) {
        return this.start < this.end && lRange.start < lRange.end && (this.contains(lRange.start) || this.contains(lRange.end - 1L) || lRange.contains(this.start) || lRange.contains(this.end - 1L));
    }

    public List<Long> getMembers() {
        long l = this.size();
        if (l > Integer.MAX_VALUE) {
            throw new RuntimeException("too long: " + l);
        }
        ArrayList<Long> members = new ArrayList<Long>((int)l);
        long i = this.start;
        while (i < this.end) {
            members.add(i);
            ++i;
        }
        return members;
    }

    public int hashCode() {
        int h = (int)(this.start ^ this.start >>> 32);
        h = Integer.rotateRight(h, 15);
        return (h ^= (int)(this.end ^ this.end >>> 32)) ^ h >>> 7;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LRange)) {
            return false;
        }
        LRange other = (LRange)obj;
        return this.start == other.start && this.end == other.end;
    }

    public String toString() {
        return "LRange {" + this.start + ", " + this.end + "}";
    }
}

